/*
 * Decompiled with CFR 0.152.
 */
package com.griefcraft.modules.unlock;

import com.griefcraft.lwc.LWC;
import com.griefcraft.model.Protection;
import com.griefcraft.scripting.JavaModule;
import com.griefcraft.scripting.event.LWCCommandEvent;
import com.griefcraft.util.StringUtils;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class UnlockModule
extends JavaModule {
    @Override
    public void onCommand(LWCCommandEvent event) {
        if (event.isCancelled()) {
            return;
        }
        if (!event.hasFlag("u", "unlock")) {
            return;
        }
        LWC lwc = event.getLWC();
        CommandSender sender = event.getSender();
        String[] args = event.getArgs();
        event.setCancelled(true);
        if (!(sender instanceof Player)) {
            sender.sendMessage("\u00a74Console is not supported.");
            return;
        }
        if (!lwc.hasPlayerPermission(sender, "lwc.unlock")) {
            lwc.sendLocale(sender, "protection.accessdenied", new Object[0]);
            return;
        }
        if (args.length < 1) {
            lwc.sendSimpleUsage(sender, "/lwc -u <Password>");
            return;
        }
        Player player = (Player)sender;
        String password = StringUtils.join(args, 0);
        password = StringUtils.encrypt(password);
        if (!lwc.getMemoryDatabase().hasPendingUnlock(player.getName())) {
            player.sendMessage("\u00a74Nothing selected. Open a locked protection first.");
            return;
        }
        int chestID = lwc.getMemoryDatabase().getUnlockID(player.getName());
        if (chestID == -1) {
            lwc.sendLocale((CommandSender)player, "protection.internalerror", "id", "ulock");
            return;
        }
        Protection entity = lwc.getPhysicalDatabase().loadProtection(chestID);
        if (entity.getType() != 1) {
            lwc.sendLocale((CommandSender)player, "protection.unlock.notpassword", new Object[0]);
            return;
        }
        if (entity.getData().equals(password)) {
            lwc.getMemoryDatabase().unregisterUnlock(player.getName());
            lwc.getMemoryDatabase().registerPlayer(player.getName(), chestID);
            lwc.sendLocale((CommandSender)player, "protection.unlock.password.valid", new Object[0]);
        } else {
            lwc.sendLocale((CommandSender)player, "protection.unlock.password.invalid", new Object[0]);
        }
    }
}

