/*
 * Decompiled with CFR 0.152.
 */
package com.griefcraft.util;

import com.griefcraft.cache.CacheSet;
import com.griefcraft.lwc.LWC;
import com.griefcraft.lwc.LWCInfo;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.logging.Logger;

public class Performance {
    private static Logger logger = Logger.getLogger("Performance");
    private static int memDBQueries = 0;
    private static int physDBQueries = 0;
    private static long startTime = 0L;

    public static void addMemDBQuery() {
        ++memDBQueries;
    }

    public static void addPhysDBQuery() {
        ++physDBQueries;
    }

    public static double getAverage(int queries) {
        return (double)queries / (double)Performance.getTimeRunningSeconds();
    }

    public static List<String> generateReport() {
        ArrayList<String> report = new ArrayList<String>();
        LWC lwc = LWC.getInstance();
        CacheSet caches = lwc.getCaches();
        report.add(" ");
        report.add(" + Version:\t\u00a78" + LWCInfo.FULL_VERSION);
        report.add(" + Engine:\t\u00a78" + (Object)((Object)lwc.getPhysicalDatabase().getType()));
        report.add(" + Date:\t\u00a78" + new Date());
        report.add(" + Time:\t\u00a78" + Performance.getTimeRunningSeconds() + " seconds");
        report.add(" + Players:\t\u00a78" + lwc.getPlugin().getServer().getOnlinePlayers().length);
        report.add(" + Protections:\t\u00a78" + lwc.getPhysicalDatabase().getProtectionCount());
        report.add(" + Cache:\t\u00a78" + caches.getProtections().size() + "\u00a7e" + "/" + "\u00a78" + lwc.getConfiguration().getInt("core.cacheSize", 10000));
        report.add(" ");
        report.add(" - Physical database");
        report.add("  + Queries:\t\u00a78" + physDBQueries);
        report.add("  + Average:\t\u00a78" + Performance.getAverage(physDBQueries) + "\u00a7e" + " /second");
        report.add(" ");
        report.add(" - Memory database");
        report.add("  + Queries:\t\u00a78" + memDBQueries);
        report.add("  + Average:\t\u00a78" + Performance.getAverage(memDBQueries) + "\u00a7e" + " /second");
        report.add(" ");
        return report;
    }

    public static int getTimeRunningSeconds() {
        return (int)((System.currentTimeMillis() - startTime) / 1000L);
    }

    public static void init() {
        startTime = System.currentTimeMillis();
    }
}

