/*
 * Decompiled with CFR 0.152.
 */
package com.griefcraft.util;

import com.griefcraft.lwc.LWC;
import com.griefcraft.lwc.LWCInfo;
import com.griefcraft.sql.Database;
import com.griefcraft.util.UpdaterFile;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Logger;

public class Updater {
    private Logger logger = Logger.getLogger(this.getClass().getSimpleName());
    private final List<UpdaterFile> needsUpdating = Collections.synchronizedList(new ArrayList());
    public static final String DEST_LIBRARY_FOLDER = "plugins/LWC/";
    public static final String DIST_FILE = "lwc/release/LWC.jar";
    public static final String UPDATE_SITE = "http://griefcraft.com/bukkit/";
    public static final String VERSION_FILE = "lwc/VERSION";
    private double latestPluginVersion = 0.0;

    public void download(UpdaterFile updaterFile) {
        this.needsUpdating.add(updaterFile);
        try {
            this.update();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void check() {
        if (LWCInfo.VERSION == 0.0) {
            return;
        }
        if (Database.DefaultType == Database.Type.SQLite) {
            String[] shared;
            for (String path : shared = new String[]{"plugins/LWC/lib/sqlite.jar", this.getFullNativeLibraryPath()}) {
                File file = new File(path);
                if (file.exists() || file.isDirectory()) continue;
                UpdaterFile updaterFile = new UpdaterFile("http://griefcraft.com/bukkit/shared/" + path.replaceAll(DEST_LIBRARY_FOLDER, ""));
                updaterFile.setLocalLocation(path);
                if (this.needsUpdating.contains(updaterFile)) continue;
                this.needsUpdating.add(updaterFile);
            }
        }
        if (LWC.getInstance().getConfiguration().getBoolean("core.autoUpdate", false) && this.latestPluginVersion > LWCInfo.VERSION) {
            this.logger.info("Update detected for LWC");
            this.logger.info("Latest version: " + this.latestPluginVersion);
        }
    }

    public boolean checkDist() {
        this.check();
        if (LWCInfo.VERSION == 0.0) {
            return false;
        }
        if (this.latestPluginVersion > LWCInfo.VERSION) {
            UpdaterFile updaterFile = new UpdaterFile("http://griefcraft.com/bukkit/lwc/release/LWC.jar");
            updaterFile.setLocalLocation("plugins/LWC.jar");
            this.needsUpdating.add(updaterFile);
            try {
                this.update();
                this.logger.info("Updated successful");
                return true;
            }
            catch (Exception e) {
                this.logger.info("Update failed: " + e.getMessage());
                e.printStackTrace();
            }
        }
        return false;
    }

    public void downloadConfig(String config) {
        File file = new File(DEST_LIBRARY_FOLDER + config);
        UpdaterFile updaterFile = new UpdaterFile("http://griefcraft.com/bukkit/lwc/skel/" + config);
        updaterFile.setLocalLocation(file.getPath());
        this.download(updaterFile);
    }

    public String getFullNativeLibraryPath() {
        return this.getOSSpecificFolder() + this.getOSSpecificFileName();
    }

    public double getLatestPluginVersion() {
        return this.latestPluginVersion;
    }

    public String getOSSpecificFileName() {
        String osname = System.getProperty("os.name").toLowerCase();
        if (osname.contains("windows")) {
            return "sqlitejdbc.dll";
        }
        if (osname.contains("mac")) {
            return "libsqlitejdbc.jnilib";
        }
        return "libsqlitejdbc.so";
    }

    public String getOSSpecificFolder() {
        String osname = System.getProperty("os.name").toLowerCase();
        String arch = System.getProperty("os.arch").toLowerCase();
        if (osname.contains("windows")) {
            return "plugins/LWC/lib/native/Windows/" + arch + "/";
        }
        if (osname.contains("mac")) {
            return "plugins/LWC/lib/native/Mac/" + arch + "/";
        }
        return "plugins/LWC/lib/native/Linux/" + arch + "/";
    }

    public void loadVersions(boolean background) {
        class Background_Check_Thread
        implements Runnable {
            Background_Check_Thread() {
            }

            @Override
            public void run() {
                try {
                    URL url = new URL("http://griefcraft.com/bukkit/lwc/VERSION");
                    InputStream inputStream = url.openStream();
                    BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
                    Updater.this.latestPluginVersion = Double.parseDouble(bufferedReader.readLine());
                    bufferedReader.close();
                }
                catch (Exception e) {
                    // empty catch block
                }
                try {
                    if (LWC.getInstance().getConfiguration().getBoolean("core.autoUpdate", false)) {
                        Updater.this.checkDist();
                    } else {
                        Updater.this.check();
                    }
                    Updater.this.update();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        Background_Check_Thread worker = new Background_Check_Thread();
        if (background) {
            new Thread(worker).start();
        } else {
            worker.run();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void update() throws Exception {
        if (this.needsUpdating.size() == 0) {
            return;
        }
        File folder = new File(this.getOSSpecificFolder());
        folder.mkdirs();
        folder = new File("plugins/LWC/lib/");
        folder.mkdirs();
        List<UpdaterFile> list = this.needsUpdating;
        synchronized (list) {
            Iterator<UpdaterFile> iterator = this.needsUpdating.iterator();
            while (iterator.hasNext()) {
                UpdaterFile item = iterator.next();
                String fileName = item.getRemoteLocation();
                fileName = fileName.substring(fileName.lastIndexOf(47) + 1);
                URL url = new URL(item.getRemoteLocation());
                File file = new File(item.getLocalLocation());
                this.logger.info("Downloading: " + item.getRemoteLocation());
                if (file.exists()) {
                    file.delete();
                }
                InputStream inputStream = url.openStream();
                FileOutputStream outputStream = new FileOutputStream(file);
                Updater.saveTo(inputStream, outputStream);
                inputStream.close();
                ((OutputStream)outputStream).close();
                iterator.remove();
            }
        }
    }

    public static void saveTo(InputStream inputStream, OutputStream outputStream) throws IOException {
        byte[] buffer = new byte[1024];
        int len = 0;
        while ((len = inputStream.read(buffer)) > 0) {
            outputStream.write(buffer, 0, len);
        }
    }
}

