/*
 * Decompiled with CFR 0.152.
 */
package com.griefcraft.util.config;

import com.griefcraft.lwc.LWC;
import com.griefcraft.util.Updater;
import com.griefcraft.util.config.ConfigurationException;
import com.griefcraft.util.config.ConfigurationNode;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.util.HashMap;
import java.util.Map;
import org.yaml.snakeyaml.DumperOptions;
import org.yaml.snakeyaml.Yaml;
import org.yaml.snakeyaml.constructor.BaseConstructor;
import org.yaml.snakeyaml.constructor.SafeConstructor;
import org.yaml.snakeyaml.reader.UnicodeReader;
import org.yaml.snakeyaml.representer.Representer;

public class Configuration
extends ConfigurationNode {
    private Yaml yaml;
    private File file;
    private static Map<String, Configuration> loaded = new HashMap<String, Configuration>();

    public Configuration(File file) {
        super(new HashMap<String, Object>());
        DumperOptions options = new DumperOptions();
        options.setIndent(4);
        options.setDefaultFlowStyle(DumperOptions.FlowStyle.BLOCK);
        this.yaml = new Yaml((BaseConstructor)new SafeConstructor(), new Representer(), options);
        this.file = file;
    }

    public static void reload() {
        for (Configuration configuration : loaded.values()) {
            configuration.load();
        }
    }

    public static Map<String, Configuration> getLoaded() {
        return loaded;
    }

    public static Configuration load(String config) {
        File file = new File("plugins/LWC/" + config);
        if (!file.exists()) {
            Updater updater = LWC.getInstance().getPlugin().getUpdater();
            updater.downloadConfig(config);
        }
        Configuration configuration = new Configuration(file);
        configuration.load();
        loaded.put(config, configuration);
        return configuration;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void load() {
        FileInputStream stream = null;
        try {
            stream = new FileInputStream(this.file);
            this.read(this.yaml.load((Reader)new UnicodeReader((InputStream)stream)));
        }
        catch (IOException e) {
            this.root = new HashMap();
        }
        catch (ConfigurationException e) {
            this.root = new HashMap();
        }
        finally {
            try {
                if (stream != null) {
                    stream.close();
                }
            }
            catch (IOException e) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean save() {
        FileOutputStream stream = null;
        File parent = this.file.getParentFile();
        if (parent != null) {
            parent.mkdirs();
        }
        try {
            stream = new FileOutputStream(this.file);
            this.yaml.dump((Object)this.root, (Writer)new OutputStreamWriter((OutputStream)stream, "UTF-8"));
            boolean bl = true;
            return bl;
        }
        catch (IOException e) {
        }
        finally {
            try {
                if (stream != null) {
                    stream.close();
                }
            }
            catch (IOException e) {}
        }
        return false;
    }

    private void read(Object input) throws ConfigurationException {
        try {
            this.root = null == input ? new HashMap() : (Map)input;
        }
        catch (ClassCastException e) {
            throw new ConfigurationException("Root document must be an key-value structure");
        }
    }

    public static ConfigurationNode getEmptyNode() {
        return new ConfigurationNode(new HashMap<String, Object>());
    }
}

