/*
 * Decompiled with CFR 0.152.
 */
package me.taylorkelly.bigbrother;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Collection;
import java.util.HashMap;
import me.taylorkelly.bigbrother.BBLogging;
import me.taylorkelly.bigbrother.BBSettings;
import me.taylorkelly.bigbrother.datasource.ConnectionManager;

public class WorldManager {
    public static final String WORLD_TABLE_NAME = "bbworlds";
    private static final String WORLD_TABLE_SQL = "CREATE TABLE `bbworlds` (`id` INTEGER PRIMARY KEY,`name` varchar(50) NOT NULL DEFAULT 'world');";
    private HashMap<String, Integer> worldMap;

    public WorldManager() {
        if (!WorldManager.worldTableExists()) {
            WorldManager.createWorldTable();
        } else if (BBSettings.debugMode) {
            BBLogging.debug("`bbworlds` table already exists");
        }
        this.worldMap = this.loadWorlds();
    }

    public int getWorld(String world) {
        if (this.worldMap.containsKey(world)) {
            return this.worldMap.get(world);
        }
        int nextKey = 0;
        if (!this.worldMap.isEmpty()) {
            nextKey = WorldManager.getMax(this.worldMap.values()) + 1;
        }
        this.saveWorld(world, nextKey);
        this.worldMap.put(world, nextKey);
        return nextKey;
    }

    public static int getMax(Collection<Integer> values) {
        int max = -1;
        for (Integer value : values) {
            if (value <= max) continue;
            max = value;
        }
        return max;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean saveWorld(String world, int index) {
        Connection conn = null;
        PreparedStatement ps = null;
        try {
            conn = ConnectionManager.getConnection();
            ps = conn.prepareStatement("INSERT INTO bbworlds (id, name) VALUES (?,?)");
            ps.setInt(1, index);
            ps.setString(2, world);
            ps.executeUpdate();
            conn.commit();
            boolean bl = true;
            return bl;
        }
        catch (SQLException ex) {
            BBLogging.severe("World Insert Exception", ex);
            boolean bl = false;
            return bl;
        }
        finally {
            ConnectionManager.cleanup("World Insert", conn, ps, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private HashMap<String, Integer> loadWorlds() {
        HashMap<String, Integer> ret = new HashMap<String, Integer>();
        Connection conn = null;
        Statement statement = null;
        ResultSet set = null;
        try {
            conn = ConnectionManager.getConnection();
            statement = conn.createStatement();
            set = statement.executeQuery("SELECT * FROM `bbworlds`;");
            int size = 0;
            while (set.next()) {
                ++size;
                int index = set.getInt("id");
                String name = set.getString("name");
                ret.put(name, index);
            }
        }
        catch (SQLException ex) {
            try {
                BBLogging.severe("World Load Exception", ex);
            }
            catch (Throwable throwable) {
                ConnectionManager.cleanup("World Load", conn, statement, set);
                throw throwable;
            }
            ConnectionManager.cleanup("World Load", conn, statement, set);
        }
        ConnectionManager.cleanup("World Load", conn, statement, set);
        BBLogging.debug("Loaded worlds: " + ret.keySet().toString());
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean worldTableExists() {
        boolean bl;
        ResultSet rs;
        Connection conn;
        block5: {
            conn = null;
            rs = null;
            conn = ConnectionManager.getConnection();
            DatabaseMetaData dbm = conn.getMetaData();
            rs = dbm.getTables(null, null, WORLD_TABLE_NAME, null);
            if (rs.next()) break block5;
            boolean bl2 = false;
            ConnectionManager.cleanup("World Table Check", conn, null, rs);
            return bl2;
        }
        try {
            bl = true;
        }
        catch (SQLException ex) {
            boolean bl3;
            try {
                BBLogging.severe("World Table Check SQL Exception", ex);
                bl3 = false;
            }
            catch (Throwable throwable) {
                ConnectionManager.cleanup("World Table Check", conn, null, rs);
                throw throwable;
            }
            ConnectionManager.cleanup("World Table Check", conn, null, rs);
            return bl3;
        }
        ConnectionManager.cleanup("World Table Check", conn, null, rs);
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void createWorldTable() {
        Connection conn = null;
        Statement st = null;
        try {
            conn = ConnectionManager.getConnection();
            st = conn.createStatement();
            st.executeUpdate(WORLD_TABLE_SQL);
            conn.commit();
        }
        catch (SQLException e) {
            BBLogging.severe("Create World Table SQL Exception", e);
        }
        finally {
            ConnectionManager.cleanup("Create World Table", conn, st, null);
        }
    }
}

