/*
 * Decompiled with CFR 0.152.
 */
package me.taylorkelly.bigbrother.datablock;

import java.util.ArrayList;
import me.taylorkelly.bigbrother.BBSettings;
import me.taylorkelly.bigbrother.datablock.BBDataBlock;
import me.taylorkelly.bigbrother.datablock.DeltaChest;
import me.taylorkelly.bigbrother.datablock.DestroySignText;
import org.bukkit.Material;
import org.bukkit.Server;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.block.Chest;
import org.bukkit.block.Sign;
import org.bukkit.inventory.ItemStack;

public class BrokenBlock
extends BBDataBlock {
    private ArrayList<BBDataBlock> bystanders;

    public BrokenBlock(String player, Block block, String world) {
        this(player, block, world, true);
    }

    public BrokenBlock(String player, Block block, String world, boolean checks) {
        super(player, BBDataBlock.Action.BLOCK_BROKEN, world, block.getX(), block.getY(), block.getZ(), block.getTypeId(), Byte.toString(block.getData()));
        this.bystanders = new ArrayList();
        if (checks) {
            this.torchCheck(player, block);
            this.surroundingSignChecks(player, block);
            this.signCheck(player, block);
            this.chestCheck(player, block);
            this.checkGnomesLivingOnTop(player, block);
            this.bedCheck(player, block);
        }
    }

    private void chestCheck(String player, Block block) {
        if (block.getState() instanceof Chest) {
            Chest chest = (Chest)block.getState();
            StringBuilder builder = new StringBuilder();
            for (int i = 0; i < chest.getInventory().getSize(); ++i) {
                ItemStack stack = chest.getInventory().getItem(i);
                if (stack != null && stack.getAmount() != 0) {
                    builder.append(stack.getTypeId());
                    if (stack.getData() != null && stack.getData().getData() != 0) {
                        builder.append(":");
                        builder.append(stack.getData().getData());
                    }
                    builder.append(",");
                    builder.append("-").append(stack.getAmount());
                }
                if (i + 1 >= chest.getInventory().getSize()) continue;
                builder.append(";");
            }
            this.bystanders.add(new DeltaChest(player, chest, builder.toString(), this.world));
        }
    }

    public BrokenBlock(String player, String world, int x, int y, int z, int type, byte data) {
        super(player, BBDataBlock.Action.BLOCK_BROKEN, world, x, y, z, type, Byte.toString(data));
        this.bystanders = new ArrayList();
    }

    @Override
    public void send() {
        for (BBDataBlock block : this.bystanders) {
            block.send();
        }
        super.send();
    }

    @Override
    public void rollback(Server server) {
        if (this.type != 51 || BBSettings.restoreFire) {
            World currWorld = server.getWorld(this.world);
            if (!currWorld.isChunkLoaded(this.x >> 4, this.z >> 4)) {
                currWorld.loadChunk(this.x >> 4, this.z >> 4);
            }
            byte blockData = Byte.parseByte(this.data);
            currWorld.getBlockAt(this.x, this.y, this.z).setTypeId(this.type);
            currWorld.getBlockAt(this.x, this.y, this.z).setData(blockData);
        }
    }

    @Override
    public void redo(Server server) {
        World currWorld = server.getWorld(this.world);
        if (!currWorld.isChunkLoaded(this.x >> 4, this.z >> 4)) {
            currWorld.loadChunk(this.x >> 4, this.z >> 4);
        }
        currWorld.getBlockAt(this.x, this.y, this.z).setTypeId(0);
    }

    public static BBDataBlock getBBDataBlock(String player, String world, int x, int y, int z, int type, String data) {
        return new BrokenBlock(player, world, x, y, z, type, data);
    }

    private BrokenBlock(String player, String world, int x, int y, int z, int type, String data) {
        super(player, BBDataBlock.Action.BLOCK_BROKEN, world, x, y, z, type, data);
    }

    private void torchCheck(String player, Block block) {
        Block torchWest;
        Block torchEast;
        Block torchSouth;
        Block torchNorth;
        ArrayList<Integer> torchTypes = new ArrayList<Integer>();
        torchTypes.add(50);
        torchTypes.add(75);
        torchTypes.add(76);
        int x = block.getX();
        int y = block.getY();
        int z = block.getZ();
        Block torchTop = block.getWorld().getBlockAt(x, y + 1, z);
        if (torchTypes.contains(torchTop.getTypeId()) && torchTop.getData() == 5) {
            this.bystanders.add(new BrokenBlock(player, torchTop, this.world));
        }
        if (torchTypes.contains((torchNorth = block.getWorld().getBlockAt(x + 1, y, z)).getTypeId()) && torchNorth.getData() == 1) {
            this.bystanders.add(new BrokenBlock(player, torchNorth, this.world));
        }
        if (torchTypes.contains((torchSouth = block.getWorld().getBlockAt(x - 1, y, z)).getTypeId()) && torchSouth.getData() == 2) {
            this.bystanders.add(new BrokenBlock(player, torchSouth, this.world));
        }
        if (torchTypes.contains((torchEast = block.getWorld().getBlockAt(x, y, z + 1)).getTypeId()) && torchEast.getData() == 3) {
            this.bystanders.add(new BrokenBlock(player, torchEast, this.world));
        }
        if (torchTypes.contains((torchWest = block.getWorld().getBlockAt(x, y, z - 1)).getTypeId()) && torchWest.getData() == 4) {
            this.bystanders.add(new BrokenBlock(player, torchWest, this.world));
        }
    }

    private void surroundingSignChecks(String player, Block block) {
        Block west;
        Block east;
        Block south;
        Block north;
        int x = block.getX();
        int y = block.getY();
        int z = block.getZ();
        Block top = block.getWorld().getBlockAt(x, y + 1, z);
        if (top.getTypeId() == 63) {
            this.bystanders.add(new BrokenBlock(player, top, this.world));
        }
        if ((north = block.getWorld().getBlockAt(x + 1, y, z)).getTypeId() == 68 && north.getData() == 5) {
            this.bystanders.add(new BrokenBlock(player, north, this.world));
        }
        if ((south = block.getWorld().getBlockAt(x - 1, y, z)).getTypeId() == 68 && south.getData() == 4) {
            this.bystanders.add(new BrokenBlock(player, south, this.world));
        }
        if ((east = block.getWorld().getBlockAt(x, y, z + 1)).getTypeId() == 68 && east.getData() == 3) {
            this.bystanders.add(new BrokenBlock(player, east, this.world));
        }
        if ((west = block.getWorld().getBlockAt(x, y, z - 1)).getTypeId() == 68 && west.getData() == 2) {
            this.bystanders.add(new BrokenBlock(player, west, this.world));
        }
    }

    private void signCheck(String player, Block block) {
        if (block.getState() instanceof Sign) {
            Sign sign = (Sign)block.getState();
            this.bystanders.add(new DestroySignText(player, sign, this.world));
        }
    }

    private void checkGnomesLivingOnTop(String player, Block block) {
        ArrayList<Integer> gnomes = new ArrayList<Integer>();
        gnomes.add(6);
        gnomes.add(37);
        gnomes.add(38);
        gnomes.add(39);
        gnomes.add(40);
        gnomes.add(55);
        gnomes.add(59);
        gnomes.add(64);
        gnomes.add(66);
        gnomes.add(69);
        gnomes.add(70);
        gnomes.add(71);
        gnomes.add(72);
        gnomes.add(78);
        gnomes.add(81);
        gnomes.add(83);
        int x = block.getX();
        int y = block.getY();
        int z = block.getZ();
        Block mrGnome = block.getWorld().getBlockAt(x, y + 1, z);
        if (gnomes.contains(mrGnome.getTypeId())) {
            this.bystanders.add(new BrokenBlock(player, mrGnome, this.world));
        }
    }

    private void bedCheck(String player, Block bed) {
        if (bed.getType() == Material.BED_BLOCK) {
            if (bed.getData() >= 8) {
                Block foot = null;
                switch (bed.getData() - 8) {
                    case 0: {
                        foot = bed.getWorld().getBlockAt(this.x, this.y, this.z - 1);
                        this.bystanders.add(new BrokenBlock(player, foot, this.world, false));
                        break;
                    }
                    case 1: {
                        foot = bed.getWorld().getBlockAt(this.x + 1, this.y, this.z);
                        this.bystanders.add(new BrokenBlock(player, foot, this.world, false));
                        break;
                    }
                    case 2: {
                        foot = bed.getWorld().getBlockAt(this.x, this.y, this.z + 1);
                        this.bystanders.add(new BrokenBlock(player, foot, this.world, false));
                        break;
                    }
                    case 3: {
                        foot = bed.getWorld().getBlockAt(this.x - 1, this.y, this.z);
                        this.bystanders.add(new BrokenBlock(player, foot, this.world, false));
                    }
                }
            } else {
                Block head = null;
                switch (bed.getData()) {
                    case 0: {
                        head = bed.getWorld().getBlockAt(this.x, this.y, this.z + 1);
                        this.bystanders.add(new BrokenBlock(player, head, this.world, false));
                        break;
                    }
                    case 1: {
                        head = bed.getWorld().getBlockAt(this.x - 1, this.y, this.z);
                        this.bystanders.add(new BrokenBlock(player, head, this.world, false));
                        break;
                    }
                    case 2: {
                        head = bed.getWorld().getBlockAt(this.x, this.y, this.z - 1);
                        this.bystanders.add(new BrokenBlock(player, head, this.world, false));
                        break;
                    }
                    case 3: {
                        head = bed.getWorld().getBlockAt(this.x + 1, this.y, this.z);
                        this.bystanders.add(new BrokenBlock(player, head, this.world, false));
                    }
                }
            }
        }
    }
}

