/*
 * Decompiled with CFR 0.152.
 */
package me.taylorkelly.bigbrother.datablock;

import me.taylorkelly.bigbrother.BBLogging;
import me.taylorkelly.bigbrother.datablock.BBDataBlock;
import org.bukkit.Server;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.block.Chest;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;

public class DeltaChest
extends BBDataBlock {
    public DeltaChest(String player, Chest chest, String changes, String world) {
        super(player, BBDataBlock.Action.DELTA_CHEST, world, chest.getX(), chest.getY(), chest.getZ(), chest.getTypeId(), changes);
    }

    private DeltaChest(String player, String world, int x, int y, int z, int type, String data) {
        super(player, BBDataBlock.Action.DELTA_CHEST, world, x, y, z, type, data);
    }

    @Override
    public void rollback(Server server) {
        World currWorld = server.getWorld(this.world);
        if (!currWorld.isChunkLoaded(this.x >> 4, this.z >> 4)) {
            currWorld.loadChunk(this.x >> 4, this.z >> 4);
        }
        String[] changes = this.data.split(";");
        Block block = currWorld.getBlockAt(this.x, this.y, this.z);
        if (block.getState() instanceof Chest) {
            Chest chest = (Chest)block.getState();
            Inventory inv = chest.getInventory();
            for (int i = 0; i < changes.length; ++i) {
                String change = changes[i];
                try {
                    String[] pieces;
                    if (change.equals("") || (pieces = change.split(",")).length != 2) continue;
                    int id = 0;
                    int itemData = 0;
                    if (pieces[0].contains(":")) {
                        String[] subPieces = pieces[0].split(":");
                        id = Integer.parseInt(subPieces[0]);
                        itemData = Integer.parseInt(subPieces[1]);
                    } else {
                        id = Integer.parseInt(pieces[0]);
                    }
                    int amount = -1 * Integer.parseInt(pieces[1]);
                    ItemStack stack = inv.getItem(i);
                    if (stack == null || stack.getAmount() == 0) {
                        if (amount > 0) {
                            ItemStack newStack = new ItemStack(id, amount, 1, Byte.valueOf((byte)itemData));
                            inv.setItem(i, newStack);
                            continue;
                        }
                        BBLogging.warning("Chest restore conflict. Trying to remove from a empty slot");
                        continue;
                    }
                    if (stack.getTypeId() != id) {
                        BBLogging.warning("Chest restore conflict. Different types.");
                        continue;
                    }
                    amount = stack.getAmount() + amount;
                    short damage = stack.getDurability();
                    if (amount < 0) {
                        inv.clear(i);
                        continue;
                    }
                    ItemStack newStack = new ItemStack(id, amount, (short)((byte)damage), Byte.valueOf((byte)itemData));
                    inv.setItem(i, newStack);
                    continue;
                }
                catch (NumberFormatException e) {
                    BBLogging.warning("Broken Chest Log with piece: " + change);
                }
            }
        } else {
            BBLogging.warning("Error when restoring chest");
        }
    }

    @Override
    public void redo(Server server) {
        World currWorld = server.getWorld(this.world);
        if (!currWorld.isChunkLoaded(this.x >> 4, this.z >> 4)) {
            currWorld.loadChunk(this.x >> 4, this.z >> 4);
        }
        String[] changes = this.data.split(";");
        Block block = currWorld.getBlockAt(this.x, this.y, this.z);
        if (block.getState() instanceof Chest) {
            Chest chest = (Chest)block.getState();
            Inventory inv = chest.getInventory();
            for (int i = 0; i < changes.length; ++i) {
                String change = changes[i];
                try {
                    String[] pieces;
                    if (change.equals("") || (pieces = change.split(",")).length != 2) continue;
                    int id = 0;
                    int itemData = 0;
                    if (pieces[0].contains(":")) {
                        String[] subPieces = pieces[0].split(":");
                        id = Integer.parseInt(subPieces[0]);
                        itemData = Integer.parseInt(subPieces[1]);
                    } else {
                        id = Integer.parseInt(pieces[0]);
                    }
                    int amount = Integer.parseInt(pieces[1]);
                    ItemStack stack = inv.getItem(i);
                    if (stack == null || stack.getAmount() == 0) {
                        if (amount > 0) {
                            ItemStack newStack = new ItemStack(id, amount, 1, Byte.valueOf((byte)itemData));
                            inv.setItem(i, newStack);
                            continue;
                        }
                        BBLogging.warning("Chest restore conflict. Trying to remove from a empty slot");
                        continue;
                    }
                    if (stack.getTypeId() != id) {
                        BBLogging.warning("Chest restore conflict. Different types.");
                        continue;
                    }
                    amount = stack.getAmount() + amount;
                    short damage = stack.getDurability();
                    if (amount < 0) {
                        inv.clear(i);
                        continue;
                    }
                    ItemStack newStack = new ItemStack(id, amount, (short)((byte)damage), Byte.valueOf((byte)itemData));
                    inv.setItem(i, newStack);
                    continue;
                }
                catch (NumberFormatException e) {
                    BBLogging.warning("Broken Chest Log with piece: " + change);
                }
            }
        } else {
            BBLogging.warning("Error when restoring chest");
        }
    }

    public static BBDataBlock getBBDataBlock(String player, String world, int x, int y, int z, int type, String data) {
        return new DeltaChest(player, world, x, y, z, type, data);
    }
}

