/*
 * Decompiled with CFR 0.152.
 */
package me.taylorkelly.bigbrother.datablock;

import me.taylorkelly.bigbrother.BBLogging;
import me.taylorkelly.bigbrother.datablock.BBDataBlock;
import org.bukkit.Server;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.block.Sign;

public class DestroySignText
extends BBDataBlock {
    public DestroySignText(String name, Sign sign, String world) {
        super(name, BBDataBlock.Action.DESTROY_SIGN_TEXT, world, sign.getX(), sign.getY(), sign.getZ(), 323, DestroySignText.getText(sign));
    }

    private static String getText(Sign sign) {
        StringBuilder message = new StringBuilder();
        String[] lines = sign.getLines();
        for (int i = 0; i < lines.length; ++i) {
            message.append(lines[i]);
            if (i >= lines.length - 1) continue;
            message.append("`");
        }
        return message.toString();
    }

    public static BBDataBlock getBBDataBlock(String player, String world, int x, int y, int z, int type, String data) {
        return new DestroySignText(player, world, x, y, z, type, data);
    }

    private DestroySignText(String player, String world, int x, int y, int z, int type, String data) {
        super(player, BBDataBlock.Action.DESTROY_SIGN_TEXT, world, x, y, z, type, data);
    }

    @Override
    public void rollback(Server server) {
        World currWorld = server.getWorld(this.world);
        if (!currWorld.isChunkLoaded(this.x >> 4, this.z >> 4)) {
            currWorld.loadChunk(this.x >> 4, this.z >> 4);
        }
        String[] lines = this.data.split("`");
        Block block = currWorld.getBlockAt(this.x, this.y, this.z);
        if (block.getState() instanceof Sign) {
            Sign sign = (Sign)block.getState();
            for (int i = 0; i < lines.length; ++i) {
                sign.setLine(i, lines[i]);
            }
        } else {
            BBLogging.warning("Error when restoring sign");
        }
    }

    @Override
    public void redo(Server server) {
        Block block;
        World currWorld = server.getWorld(this.world);
        if (!currWorld.isChunkLoaded(this.x >> 4, this.z >> 4)) {
            currWorld.loadChunk(this.x >> 4, this.z >> 4);
        }
        if ((block = currWorld.getBlockAt(this.x, this.y, this.z)).getState() instanceof Sign) {
            Sign sign = (Sign)block.getState();
            for (int i = 0; i < sign.getLines().length; ++i) {
                sign.setLine(i, "");
            }
        } else {
            BBLogging.warning("Error when restoring sign");
        }
    }
}

