/*
 * Decompiled with CFR 0.152.
 */
package me.taylorkelly.bigbrother.finder;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import me.taylorkelly.bigbrother.BBLogging;
import me.taylorkelly.bigbrother.WorldManager;
import me.taylorkelly.bigbrother.datablock.BBDataBlock;
import me.taylorkelly.bigbrother.datasource.ConnectionManager;
import me.taylorkelly.bigbrother.tablemgrs.BBDataTable;
import org.bukkit.block.Block;

public class BlockHistory {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ArrayList<BBDataBlock> hist(Block block, WorldManager manager) {
        PreparedStatement ps = null;
        ResultSet rs = null;
        Connection conn = null;
        ArrayList<BBDataBlock> blockList = new ArrayList<BBDataBlock>();
        try {
            conn = ConnectionManager.getConnection();
            ps = conn.prepareStatement("SELECT  bbdata.id, date, player, action, x, y, z, type, data, rbacked, bbworlds.name AS `world` FROM " + BBDataTable.getTableName() + " INNER JOIN bbworlds ON bbworlds.id = bbdata.world  WHERE rbacked = 0 AND x = ? AND y = ?  AND z = ? AND bbdata.world = ? ORDER BY bbdata.id ASC;");
            ps.setInt(1, block.getX());
            ps.setInt(2, block.getY());
            ps.setInt(3, block.getZ());
            ps.setInt(4, manager.getWorld(block.getWorld().getName()));
            rs = ps.executeQuery();
            conn.commit();
            while (rs.next()) {
                BBDataBlock newBlock = BBDataBlock.getBBDataBlock(rs.getString("player"), BBDataBlock.Action.values()[rs.getInt("action")], rs.getString("world"), rs.getInt("x"), rs.getInt("y"), rs.getInt("z"), rs.getInt("type"), rs.getString("data"));
                newBlock.date = rs.getLong("date");
                blockList.add(newBlock);
            }
            ConnectionManager.cleanup("Find", conn, ps, rs);
        }
        catch (SQLException ex) {
            BBLogging.severe("Find SQL Exception", ex);
        }
        finally {
            ConnectionManager.cleanup("Find", conn, ps, rs);
        }
        return blockList;
    }
}

