/*
 * Decompiled with CFR 0.152.
 */
package me.taylorkelly.bigbrother.finder;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import me.taylorkelly.bigbrother.BBLogging;
import me.taylorkelly.bigbrother.BBSettings;
import me.taylorkelly.bigbrother.BigBrother;
import me.taylorkelly.bigbrother.WorldManager;
import me.taylorkelly.bigbrother.datablock.BBDataBlock;
import me.taylorkelly.bigbrother.datasource.ConnectionManager;
import me.taylorkelly.bigbrother.tablemgrs.BBDataTable;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.entity.Player;

public class Finder {
    private Location location;
    private int radius;
    private ArrayList<Player> players;
    private WorldManager manager;

    public Finder(Location location, List<World> worlds, WorldManager manager) {
        this.manager = manager;
        this.location = location;
        this.radius = BBSettings.defaultSearchRadius;
        this.players = new ArrayList();
    }

    public void setRadius(double radius) {
        this.radius = (int)radius;
    }

    public void addReciever(Player player) {
        this.players.add(player);
    }

    public void find() {
        this.mysqlFind();
    }

    public void find(String player) {
        this.mysqlFind(player);
    }

    public void find(ArrayList<String> players) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void mysqlFind() {
        PreparedStatement ps = null;
        ResultSet rs = null;
        Connection conn = null;
        HashMap<String, Integer> modifications = new HashMap<String, Integer>();
        try {
            conn = ConnectionManager.getConnection();
            String actionString = "action IN('" + BBDataBlock.Action.BLOCK_BROKEN.ordinal() + "', '" + BBDataBlock.Action.BLOCK_PLACED.ordinal() + "', '" + BBDataBlock.Action.LEAF_DECAY.ordinal() + "', '" + BBDataBlock.Action.TNT_EXPLOSION.ordinal() + "', '" + BBDataBlock.Action.CREEPER_EXPLOSION.ordinal() + "', '" + BBDataBlock.Action.MISC_EXPLOSION.ordinal() + "', '" + BBDataBlock.Action.LAVA_FLOW.ordinal() + "', '" + BBDataBlock.Action.BLOCK_BURN.ordinal() + "')";
            ps = conn.prepareStatement("SELECT player, count(player) AS modifications FROM " + BBDataTable.getTableName() + " WHERE " + actionString + " AND rbacked = '0' AND x < ? AND x > ? AND y < ? AND y > ? AND z < ? AND z > ? AND world = ? GROUP BY player ORDER BY id DESC");
            ps.setInt(1, this.location.getBlockX() + this.radius);
            ps.setInt(2, this.location.getBlockX() - this.radius);
            ps.setInt(3, this.location.getBlockY() + this.radius);
            ps.setInt(4, this.location.getBlockY() - this.radius);
            ps.setInt(5, this.location.getBlockZ() + this.radius);
            ps.setInt(6, this.location.getBlockZ() - this.radius);
            ps.setInt(7, this.manager.getWorld(this.location.getWorld().getName()));
            rs = ps.executeQuery();
            conn.commit();
            int size = 0;
            while (rs.next()) {
                String player = rs.getString("player");
                int mods = rs.getInt("modifications");
                modifications.put(player, mods);
                ++size;
            }
            if (size > 0) {
                StringBuilder playerList = new StringBuilder();
                for (Map.Entry entry : modifications.entrySet()) {
                    playerList.append((String)entry.getKey());
                    playerList.append(" (");
                    playerList.append(entry.getValue());
                    playerList.append("), ");
                }
                playerList.delete(playerList.lastIndexOf(","), playerList.length());
                for (Player player : this.players) {
                    player.sendMessage(BigBrother.premessage + size + " player(s) have modified this area:");
                    player.sendMessage(playerList.toString());
                }
            } else {
                for (Player player : this.players) {
                    player.sendMessage(BigBrother.premessage + "No modifications in this area.");
                }
            }
            ConnectionManager.cleanup("Find SQL", conn, ps, rs);
        }
        catch (SQLException ex) {
            BBLogging.severe("Find SQL Exception", ex);
        }
        finally {
            ConnectionManager.cleanup("Find SQL", conn, ps, rs);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void mysqlFind(String playerName) {
        PreparedStatement ps = null;
        ResultSet rs = null;
        HashMap<Integer, Integer> creations = new HashMap<Integer, Integer>();
        HashMap<Integer, Integer> destructions = new HashMap<Integer, Integer>();
        HashMap<Integer, Integer> explosions = new HashMap<Integer, Integer>();
        HashMap<Integer, Integer> burns = new HashMap<Integer, Integer>();
        Connection conn = null;
        try {
            conn = ConnectionManager.getConnection();
            String actionString = "action IN('" + BBDataBlock.Action.BLOCK_BROKEN.ordinal() + "', '" + BBDataBlock.Action.BLOCK_PLACED.ordinal() + "', '" + BBDataBlock.Action.LEAF_DECAY.ordinal() + "', '" + BBDataBlock.Action.TNT_EXPLOSION.ordinal() + "', '" + BBDataBlock.Action.CREEPER_EXPLOSION.ordinal() + "', '" + BBDataBlock.Action.MISC_EXPLOSION.ordinal() + "', '" + BBDataBlock.Action.LAVA_FLOW.ordinal() + "', '" + BBDataBlock.Action.BLOCK_BURN.ordinal() + "')";
            ps = conn.prepareStatement("SELECT action, type FROM " + BBDataTable.getTableName() + " WHERE " + actionString + " AND rbacked = 0 AND x < ? AND x > ? AND y < ? AND y > ?  AND z < ? AND z > ? AND player = ? AND world = ? order by date desc");
            ps.setInt(1, this.location.getBlockX() + this.radius);
            ps.setInt(2, this.location.getBlockX() - this.radius);
            ps.setInt(3, this.location.getBlockY() + this.radius);
            ps.setInt(4, this.location.getBlockY() - this.radius);
            ps.setInt(5, this.location.getBlockZ() + this.radius);
            ps.setInt(6, this.location.getBlockZ() - this.radius);
            ps.setString(7, playerName);
            ps.setInt(8, this.manager.getWorld(this.location.getWorld().getName()));
            rs = ps.executeQuery();
            conn.commit();
            int size = 0;
            while (rs.next()) {
                BBDataBlock.Action action = BBDataBlock.Action.values()[rs.getInt("action")];
                int type = rs.getInt("type");
                switch (action) {
                    case BLOCK_BROKEN: 
                    case LEAF_DECAY: {
                        if (destructions.containsKey(type)) {
                            destructions.put(type, (Integer)destructions.get(type) + 1);
                            ++size;
                            break;
                        }
                        destructions.put(type, 1);
                        ++size;
                        break;
                    }
                    case BLOCK_PLACED: {
                        if (creations.containsKey(type)) {
                            creations.put(type, (Integer)creations.get(type) + 1);
                            ++size;
                            break;
                        }
                        creations.put(type, 1);
                        ++size;
                        break;
                    }
                    case TNT_EXPLOSION: 
                    case CREEPER_EXPLOSION: 
                    case MISC_EXPLOSION: {
                        if (explosions.containsKey(type)) {
                            explosions.put(type, (Integer)explosions.get(type) + 1);
                            ++size;
                        } else {
                            explosions.put(type, 1);
                            ++size;
                        }
                    }
                    case BLOCK_BURN: {
                        if (burns.containsKey(type)) {
                            burns.put(type, (Integer)burns.get(type) + 1);
                            ++size;
                            break;
                        }
                        burns.put(type, 1);
                        ++size;
                        break;
                    }
                    case LAVA_FLOW: {
                        if (creations.containsKey(type)) {
                            creations.put(type, (Integer)creations.get(type) + 1);
                            ++size;
                            break;
                        }
                        creations.put(type, 1);
                        ++size;
                    }
                }
            }
            if (size > 0) {
                StringBuilder creationList = new StringBuilder();
                creationList.append(ChatColor.AQUA.toString());
                creationList.append("Placed Blocks: ");
                creationList.append(ChatColor.WHITE.toString());
                for (Map.Entry entry : creations.entrySet()) {
                    creationList.append(Material.getMaterial((int)((Integer)entry.getKey())));
                    creationList.append(" (");
                    creationList.append(entry.getValue());
                    creationList.append("), ");
                }
                if (creationList.toString().contains(",")) {
                    creationList.delete(creationList.lastIndexOf(","), creationList.length());
                }
                StringBuilder brokenList = new StringBuilder();
                brokenList.append(ChatColor.RED.toString());
                brokenList.append("Broken Blocks: ");
                brokenList.append(ChatColor.WHITE.toString());
                for (Map.Entry entry : destructions.entrySet()) {
                    brokenList.append(Material.getMaterial((int)((Integer)entry.getKey())));
                    brokenList.append(" (");
                    brokenList.append(entry.getValue());
                    brokenList.append("), ");
                }
                if (brokenList.toString().contains(",")) {
                    brokenList.delete(brokenList.lastIndexOf(","), brokenList.length());
                }
                StringBuilder explodeList = new StringBuilder();
                explodeList.append(ChatColor.RED.toString());
                explodeList.append("Exploded Blocks: ");
                explodeList.append(ChatColor.WHITE.toString());
                for (Map.Entry entry : explosions.entrySet()) {
                    explodeList.append(Material.getMaterial((int)((Integer)entry.getKey())));
                    explodeList.append(" (");
                    explodeList.append(entry.getValue());
                    explodeList.append("), ");
                }
                if (explodeList.toString().contains(",")) {
                    explodeList.delete(explodeList.lastIndexOf(","), explodeList.length());
                }
                StringBuilder burnList = new StringBuilder();
                burnList.append(ChatColor.RED.toString());
                burnList.append("Burned Blocks: ");
                burnList.append(ChatColor.WHITE.toString());
                for (Map.Entry entry : burns.entrySet()) {
                    burnList.append(Material.getMaterial((int)((Integer)entry.getKey())));
                    burnList.append(" (");
                    burnList.append(entry.getValue());
                    burnList.append("), ");
                }
                if (burnList.toString().contains(",")) {
                    burnList.delete(burnList.lastIndexOf(","), burnList.length());
                }
                for (Player player : this.players) {
                    player.sendMessage(BigBrother.premessage + playerName + " has made " + size + " modifications");
                    if (creations.entrySet().size() > 0) {
                        player.sendMessage(creationList.toString());
                    }
                    if (destructions.entrySet().size() > 0) {
                        player.sendMessage(brokenList.toString());
                    }
                    if (explosions.entrySet().size() > 0) {
                        player.sendMessage(explodeList.toString());
                    }
                    if (burns.entrySet().size() <= 0) continue;
                    player.sendMessage(burnList.toString());
                }
            } else {
                for (Player player : this.players) {
                    player.sendMessage(BigBrother.premessage + playerName + " has no modifications in this area.");
                }
            }
            ConnectionManager.cleanup("Find SQL", conn, ps, rs);
        }
        catch (SQLException ex) {
            BBLogging.severe("Find SQL Exception", ex);
        }
        finally {
            ConnectionManager.cleanup("Find SQL", conn, ps, rs);
        }
    }
}

