/*
 * Decompiled with CFR 0.152.
 */
package me.taylorkelly.bigbrother.fixes;

import java.io.File;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import me.taylorkelly.bigbrother.BBLogging;
import me.taylorkelly.bigbrother.BBSettings;
import me.taylorkelly.bigbrother.datasource.ConnectionManager;
import me.taylorkelly.bigbrother.fixes.Fix;

public class Fix1
extends Fix {
    protected int version = 1;
    public static final String[] UPDATE_SQLITE = new String[]{"CREATE TEMPORARY TABLE bbdata_backup(id, date, player, action, world, x, y, z, type, data, rbacked);", "INSERT INTO bbdata_backup SELECT id, date, player, action, world, x, y, z, type, data, rbacked FROM bbdata;", "DROP TABLE bbdata;", "CREATE TABLE `bbdata` (`id` INTEGER PRIMARY KEY,`date` INT UNSIGNED NOT NULL DEFAULT '0',`player` varchar(32) NOT NULL DEFAULT 'Player',`action` tinyint NOT NULL DEFAULT '0',`world` tinyint NOT NULL DEFAULT '0',`x` int NOT NULL DEFAULT '0',`y` tinyint NOT NULL DEFAULT '0',`z` int NOT NULL DEFAULT '0',`type` smallint NOT NULL DEFAULT '0',`data` varchar(150) NOT NULL DEFAULT '',`rbacked` boolean NOT NULL DEFAULT '0');", "INSERT INTO bbdata SELECT id, date, player, action, world, x, y, z, type, data, rbacked FROM bbdata_backup;", "DROP TABLE bbdata_backup;"};
    public static final String UPDATE_MYSQL = "ALTER TABLE bbdata MODIFY type smallint;";

    public Fix1(File dataFolder) {
        super(dataFolder);
    }

    @Override
    public void apply() {
        if (this.needsUpdate(this.version)) {
            boolean sqlite;
            BBLogging.info("Updating table for 1.3");
            boolean bl = sqlite = BBSettings.databaseSystem == BBSettings.DBMS.SQLITE;
            if (Fix1.updateTable(sqlite)) {
                this.updateVersion(this.version);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean updateTable(boolean sqlite) {
        Connection conn = null;
        Statement st = null;
        try {
            boolean i;
            conn = ConnectionManager.getConnection();
            st = conn.createStatement();
            if (sqlite) {
                for (i = false; i < UPDATE_SQLITE.length; i += 1) {
                    st.executeUpdate(UPDATE_SQLITE[i]);
                }
            } else {
                st.executeUpdate(UPDATE_MYSQL);
            }
            conn.commit();
            i = true;
            return i;
        }
        catch (SQLException e) {
            BBLogging.severe("Update Table 1.3 Fail " + (sqlite ? " sqlite" : " mysql"), e);
            boolean bl = false;
            return bl;
        }
        finally {
            ConnectionManager.cleanup("Update Table 1.3", conn, st, null);
        }
    }
}

