/*
 * Decompiled with CFR 0.152.
 */
package me.taylorkelly.bigbrother.rollback;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.LinkedList;
import me.taylorkelly.bigbrother.BBLogging;
import me.taylorkelly.bigbrother.BBSettings;
import me.taylorkelly.bigbrother.BigBrother;
import me.taylorkelly.bigbrother.WorldManager;
import me.taylorkelly.bigbrother.datablock.BBDataBlock;
import me.taylorkelly.bigbrother.datasource.ConnectionManager;
import me.taylorkelly.bigbrother.rollback.RollbackPreparedStatement;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.Server;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitScheduler;

public class Rollback {
    public final Server server;
    private final ArrayList<Player> recievers;
    public final ArrayList<String> players;
    public boolean rollbackAll;
    public long time;
    public final ArrayList<Integer> blockTypes;
    public int radius;
    public Location center;
    private final LinkedList<BBDataBlock> listBlocks;
    private static final LinkedList<BBDataBlock> lastRollback = new LinkedList();
    private static String undoRollback = null;
    private final WorldManager manager;
    private final Plugin plugin;

    public Rollback(Server server, WorldManager manager, Plugin plugin) {
        this.manager = manager;
        this.rollbackAll = false;
        this.server = server;
        this.plugin = plugin;
        this.time = 0L;
        this.blockTypes = new ArrayList();
        this.players = new ArrayList();
        this.recievers = new ArrayList();
        this.listBlocks = new LinkedList();
    }

    public void addReciever(Player player) {
        this.recievers.add(player);
    }

    public void rollback() {
        Thread.currentThread().setContextClassLoader(this.getClass().getClassLoader());
        Rollbacker rollbacker = new Rollbacker(this.plugin, this.server.getScheduler());
        rollbacker.start();
    }

    private String getSimpleString(ArrayList<?> list) {
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < list.size(); ++i) {
            builder.append(list.get(i).toString());
            if (i + 1 >= list.size()) continue;
            builder.append(", ");
        }
        return builder.toString();
    }

    public void rollbackAll() {
        this.rollbackAll = true;
    }

    public void addPlayers(ArrayList<String> playerList) {
        this.players.addAll(playerList);
    }

    public void setTime(long l) {
        this.time = l;
    }

    public void addTypes(ArrayList<Integer> blockTypes) {
        this.blockTypes.addAll(blockTypes);
    }

    private void rollbackBlocks() {
        lastRollback.clear();
        new RollbackByTick(this.plugin.getServer().getScheduler(), this.plugin);
    }

    public static boolean canUndo() {
        if (lastRollback != null) {
            return lastRollback.size() > 0;
        }
        return false;
    }

    public static int undoSize() {
        if (lastRollback != null) {
            return lastRollback.size();
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void undo(Server server, Player player) {
        int i = 0;
        while (lastRollback.size() > 0) {
            BBDataBlock dataBlock = lastRollback.removeFirst();
            if (dataBlock == null) continue;
            dataBlock.redo(server);
            ++i;
        }
        if (undoRollback != null) {
            Connection conn = null;
            PreparedStatement ps = null;
            try {
                conn = ConnectionManager.getConnection();
                ps = conn.prepareStatement(undoRollback);
                ps.execute();
                conn.commit();
                undoRollback = null;
                player.sendMessage(ChatColor.AQUA + "Successfully undid a rollback of " + i + " edits");
            }
            catch (SQLException ex) {
                BBLogging.severe("Rollback undo SQL Exception", ex);
            }
            finally {
                ConnectionManager.cleanup("Rollback undo", conn, ps, null);
            }
        }
    }

    public void setRadius(int radius, Location center) {
        this.radius = radius;
        this.center = center;
    }

    private class RollbackByTick
    implements Runnable {
        private final int id;

        public RollbackByTick(BukkitScheduler scheduler, Plugin plugin) {
            this.id = scheduler.scheduleSyncRepeatingTask(plugin, (Runnable)this, 0L, 1L);
        }

        @Override
        public void run() {
            int count = 0;
            while (count < BBSettings.rollbacksPerTick && Rollback.this.listBlocks.size() > 0) {
                BBDataBlock dataBlock = (BBDataBlock)Rollback.this.listBlocks.removeFirst();
                if (dataBlock == null) continue;
                lastRollback.addFirst(dataBlock);
                try {
                    dataBlock.rollback(Rollback.this.server);
                }
                catch (Exception e) {
                    BBLogging.warning("Caught exception when rolling back a " + (Object)((Object)dataBlock.action));
                }
                ++count;
            }
            if (Rollback.this.listBlocks.size() == 0) {
                BBLogging.debug("Finished rollback");
                Rollback.this.plugin.getServer().getScheduler().cancelTask(this.id);
            } else {
                BBLogging.debug("Need to rollback " + Rollback.this.listBlocks.size() + " more");
            }
        }
    }

    private class Rollbacker
    extends Thread {
        private Rollbacker(Plugin plugin, BukkitScheduler scheduler) {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            Connection conn;
            ResultSet set;
            PreparedStatement ps;
            block13: {
                ps = null;
                set = null;
                conn = null;
                try {
                    conn = ConnectionManager.getConnection();
                    ps = conn.prepareStatement(RollbackPreparedStatement.create(Rollback.this, Rollback.this.manager));
                    set = ps.executeQuery();
                    conn.commit();
                    int rollbackSize = 0;
                    while (set.next()) {
                        Rollback.this.listBlocks.addLast(BBDataBlock.getBBDataBlock(set.getString("player"), BBDataBlock.Action.values()[set.getInt("action")], set.getString("world"), set.getInt("x"), set.getInt("y"), set.getInt("z"), set.getInt("type"), set.getString("data")));
                        ++rollbackSize;
                    }
                    if (rollbackSize > 0) {
                        for (Player player : Rollback.this.recievers) {
                            player.sendMessage(BigBrother.premessage + "Rolling back " + rollbackSize + " edits.");
                            String playersString = Rollback.this.rollbackAll ? "All Players" : Rollback.this.getSimpleString(Rollback.this.players);
                            player.sendMessage(ChatColor.BLUE + "Player(s): " + ChatColor.WHITE + playersString);
                            if (Rollback.this.blockTypes.size() > 0) {
                                player.sendMessage(ChatColor.BLUE + "Block Type(s): " + ChatColor.WHITE + Rollback.this.getSimpleString(Rollback.this.blockTypes));
                            }
                            if (Rollback.this.time != 0L) {
                                Calendar cal = Calendar.getInstance();
                                String DATE_FORMAT = "kk:mm:ss 'on' MMM d";
                                SimpleDateFormat sdf = new SimpleDateFormat(DATE_FORMAT);
                                cal.setTimeInMillis(Rollback.this.time * 1000L);
                                player.sendMessage(ChatColor.BLUE + "Since: " + ChatColor.WHITE + sdf.format(cal.getTime()));
                            }
                            if (Rollback.this.radius == 0) continue;
                            player.sendMessage(ChatColor.BLUE + "Radius: " + ChatColor.WHITE + Rollback.this.radius + " blocks");
                        }
                        try {
                            ps.close();
                            Rollback.this.rollbackBlocks();
                            for (Player player : Rollback.this.recievers) {
                                player.sendMessage(BigBrother.premessage + "Successfully rollback'd.");
                            }
                            ps = conn.prepareStatement(RollbackPreparedStatement.update(Rollback.this, Rollback.this.manager));
                            ps.execute();
                            conn.commit();
                            undoRollback = RollbackPreparedStatement.undoStatement(Rollback.this, Rollback.this.manager);
                        }
                        catch (SQLException ex) {
                            BBLogging.severe("Rollback edit SQL Exception", ex);
                        }
                        break block13;
                    }
                    for (Player player : Rollback.this.recievers) {
                        player.sendMessage(BigBrother.premessage + "Nothing to rollback.");
                    }
                }
                catch (SQLException ex) {
                    try {
                        BBLogging.severe("Rollback get SQL Exception", ex);
                    }
                    catch (Throwable throwable) {
                        ConnectionManager.cleanup("Rollback get", conn, ps, set);
                        throw throwable;
                    }
                    ConnectionManager.cleanup("Rollback get", conn, ps, set);
                }
            }
            ConnectionManager.cleanup("Rollback get", conn, ps, set);
        }
    }
}

