/*
 * Decompiled with CFR 0.152.
 */
package me.taylorkelly.bigbrother.tablemgrs;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import me.taylorkelly.bigbrother.BBLogging;
import me.taylorkelly.bigbrother.BBSettings;
import me.taylorkelly.bigbrother.datasource.ConnectionManager;
import me.taylorkelly.bigbrother.tablemgrs.BBDataTable;

public class BBDataMySQL
extends BBDataTable {
    public final int revision = 1;

    public String toString() {
        return "BBData MySQL Driver r" + Integer.valueOf(1);
    }

    public static String getMySQLIgnore() {
        if (BBSettings.mysqlLowPrioInserts) {
            return " LOW_PRIORITY ";
        }
        return " ";
    }

    @Override
    public String getPreparedDataBlockStatement(Connection conn) throws SQLException {
        return "INSERT " + BBDataMySQL.getMySQLIgnore() + " INTO " + BBDataTable.getTableName() + " (date, player, action, world, x, y, z, type, data, rbacked) VALUES (?,?,?,?,?,?,?,?,?,0)";
    }

    @Override
    public String getCreateSyntax() {
        return "CREATE TABLE `" + BBDataMySQL.getTableName() + "` (" + "`id` INT NOT NULL AUTO_INCREMENT," + "`date` INT UNSIGNED NOT NULL DEFAULT '0'," + "`player` varchar(32) NOT NULL DEFAULT 'Player'," + "`action` tinyint NOT NULL DEFAULT '0'," + "`world` tinyint NOT NULL DEFAULT '0'," + "`x` int NOT NULL DEFAULT '0'," + "`y` tinyint UNSIGNED NOT NULL DEFAULT '0'," + "`z` int NOT NULL DEFAULT '0'," + "`type` smallint NOT NULL DEFAULT '0'," + "`data` varchar(500) NOT NULL DEFAULT ''," + "`rbacked` boolean NOT NULL DEFAULT '0'," + "PRIMARY KEY (`id`)," + "INDEX(`world`)," + "INDEX(`x`,`y`,`z`)," + "INDEX(`player`(10))," + "INDEX(`action`)," + "INDEX(`date`)," + "INDEX(`type`)," + "INDEX(`rbacked`)" + ")";
    }

    @Override
    public void onLoad() {
        this.checkDBEngine(BBDataMySQL.getTableName(), "MyISAM", true);
    }

    private void checkDBEngine(String tableName, String requiredEngine, boolean optional) {
        String engine = this.getEngine(tableName);
        if (engine == null) {
            return;
        }
        if (!engine.equalsIgnoreCase(requiredEngine)) {
            if (!optional) {
                BBLogging.warning("Changing " + tableName + " so that it uses " + requiredEngine + " instead of " + engine + ". THIS MAY TAKE A WHILE!");
                this.setEngine(tableName, requiredEngine);
            } else {
                BBLogging.warning("Table " + tableName + " uses the MySQL storage engine " + engine + ".");
                BBLogging.info("For optimal performance, we suggest changing to " + requiredEngine + " via the following SQL statement:");
                BBLogging.info("  ALTER TABLE " + tableName + " ENGINE = " + requiredEngine + ";");
                BBLogging.info("Please note that, on many tables, this could take a very long time.");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setEngine(String tableName, String engine) {
        Connection conn = null;
        Statement st = null;
        try {
            conn = ConnectionManager.getConnection();
            st = conn.createStatement();
            st.executeUpdate("ALTER TABLE " + tableName + " ENGINE = " + engine);
            conn.commit();
        }
        catch (SQLException e) {
            BBLogging.severe("Altering " + tableName + " to use " + engine + " triggered an exception.", e);
        }
        finally {
            ConnectionManager.cleanup("setEngine", conn, st, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getEngine(String tableName) {
        Connection conn = null;
        ResultSet rs = null;
        Statement stmt = null;
        String engine = null;
        try {
            conn = ConnectionManager.getConnection();
            stmt = conn.createStatement();
            if (!stmt.execute("SHOW TABLE STATUS WHERE Name = '" + tableName + "'")) {
                BBLogging.severe("Could not fetch table information for table " + tableName);
                String string = null;
                ConnectionManager.cleanup("getEngine", conn, stmt, rs);
                return string;
            }
            rs = stmt.getResultSet();
            rs.first();
            engine = rs.getString("Engine");
            ConnectionManager.cleanup("getEngine", conn, stmt, rs);
        }
        catch (SQLException e) {
            BBLogging.severe("Could not retreive table information.", e);
        }
        finally {
            ConnectionManager.cleanup("getEngine", conn, stmt, rs);
        }
        return engine;
    }
}

