/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.worldguard.bukkit;

import com.sk89q.worldedit.Vector;
import com.sk89q.worldguard.LocalPlayer;
import com.sk89q.worldguard.bukkit.WorldGuardPlugin;
import org.bukkit.Location;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class BukkitPlayer
extends LocalPlayer {
    private Player player;
    private WorldGuardPlugin plugin;

    public BukkitPlayer(WorldGuardPlugin plugin, Player player) {
        this.plugin = plugin;
        this.player = player;
    }

    public String getName() {
        return this.player.getName();
    }

    public boolean hasGroup(String group) {
        return this.plugin.inGroup(this.player, group);
    }

    public Vector getPosition() {
        Location loc = this.player.getLocation();
        return new Vector(loc.getX(), loc.getY(), loc.getZ());
    }

    public void kick(String msg) {
        this.player.kickPlayer(msg);
    }

    public void ban(String msg) {
        this.player.kickPlayer(msg);
    }

    public String[] getGroups() {
        return this.plugin.getGroups(this.player);
    }

    public void printRaw(String msg) {
        this.player.sendMessage(msg);
    }

    public boolean hasPermission(String perm) {
        return this.plugin.hasPermission((CommandSender)this.player, perm);
    }
}

