/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.worldguard.bukkit;

import com.sk89q.worldguard.LocalPlayer;
import com.sk89q.worldguard.blacklist.Blacklist;
import com.sk89q.worldguard.bukkit.WorldConfiguration;
import com.sk89q.worldguard.bukkit.WorldGuardPlugin;
import java.io.File;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.bukkit.World;
import org.bukkit.entity.Player;
import org.bukkit.util.config.Configuration;

public class ConfigurationManager {
    private static final String CONFIG_HEADER = "#\r\n# WorldGuard's main configuration file\r\n#\r\n# This is the global configuration file. Anything placed into here will\r\n# be applied to all worlds. However, each world has its own configuration\r\n# file to allow you to replace any setting in here for that world only.\r\n#\r\n# About editing this file:\r\n# - DO NOT USE TABS. You MUST use spaces or Bukkit will complain. If\r\n#   you use an editor like Notepad++ (recommended for Windows users), you\r\n#   must configure it to \"replace tabs with spaces.\" In Notepad++, this can\r\n#   be changed in Settings > Preferences > Language Menu.\r\n# - Don't get rid of the indents. They are indented so some entries are\r\n#   in categories (like \"enforce-single-session\" is in the \"protection\"\r\n#   category.\r\n# - If you want to check the format of this file before putting it\r\n#   into WorldGuard, paste it into http://yaml-online-parser.appspot.com/\r\n#   and see if it gives \"ERROR:\".\r\n# - Lines starting with # are comments and so they are ignored.\r\n#\r\n";
    private WorldGuardPlugin plugin;
    private Map<String, WorldConfiguration> worlds;
    private Set<String> hasGodMode = new HashSet<String>();
    private Set<String> hasAmphibious = new HashSet<String>();
    public boolean suppressTickSyncWarnings;
    public boolean useRegionsScheduler;
    public boolean activityHaltToggle = false;
    public boolean autoGodMode;

    public ConfigurationManager(WorldGuardPlugin plugin) {
        this.plugin = plugin;
        this.worlds = new HashMap<String, WorldConfiguration>();
    }

    public void load() {
        WorldGuardPlugin.createDefaultConfiguration(new File(this.plugin.getDataFolder(), "config.yml"), "config.yml");
        Configuration config = this.plugin.getConfiguration();
        config.load();
        this.suppressTickSyncWarnings = config.getBoolean("suppress-tick-sync-warnings", false);
        this.useRegionsScheduler = config.getBoolean("regions.use-scheduler", true);
        this.autoGodMode = config.getBoolean("auto-invincible-permission", false);
        for (World world : this.plugin.getServer().getWorlds()) {
            this.get(world);
        }
        try {
            config.setHeader(CONFIG_HEADER);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        config.save();
    }

    public void unload() {
        this.worlds.clear();
    }

    public WorldConfiguration get(World world) {
        String worldName = world.getName();
        WorldConfiguration config = this.worlds.get(worldName);
        if (config == null) {
            config = new WorldConfiguration(this.plugin, worldName);
            this.worlds.put(worldName, config);
        }
        return config;
    }

    public void forgetPlayer(LocalPlayer player) {
        for (Map.Entry<String, WorldConfiguration> entry : this.worlds.entrySet()) {
            Blacklist bl = entry.getValue().getBlacklist();
            if (bl == null) continue;
            bl.forgetPlayer(player);
        }
        this.hasGodMode.remove(player.getName());
        this.hasAmphibious.remove(player.getName());
    }

    public void enableGodMode(Player player) {
        this.hasGodMode.add(player.getName());
    }

    public void disableGodMode(Player player) {
        this.hasGodMode.remove(player.getName());
    }

    public boolean hasGodMode(Player player) {
        return this.hasGodMode.contains(player.getName());
    }

    public void enableAmphibiousMode(Player player) {
        this.hasAmphibious.add(player.getName());
    }

    public void disableAmphibiousMode(Player player) {
        this.hasAmphibious.remove(player.getName());
    }

    public boolean hasAmphibiousMode(Player player) {
        return this.hasAmphibious.contains(player.getName());
    }
}

