/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.worldguard.bukkit;

import com.sk89q.worldedit.Vector;
import com.sk89q.worldguard.bukkit.BukkitUtil;
import com.sk89q.worldguard.bukkit.ConfigurationManager;
import com.sk89q.worldguard.bukkit.WorldConfiguration;
import com.sk89q.worldguard.bukkit.WorldGuardPlugin;
import com.sk89q.worldguard.protection.ApplicableRegionSet;
import com.sk89q.worldguard.protection.flags.DefaultFlag;
import com.sk89q.worldguard.protection.managers.RegionManager;
import java.util.HashMap;
import java.util.Map;
import org.bukkit.World;
import org.bukkit.entity.Player;

public class FlagStateManager
implements Runnable {
    public static final int RUN_DELAY = 20;
    private WorldGuardPlugin plugin;
    private Map<String, PlayerFlagState> states;

    public FlagStateManager(WorldGuardPlugin plugin) {
        this.plugin = plugin;
        this.states = new HashMap<String, PlayerFlagState>();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        Player[] players = this.plugin.getServer().getOnlinePlayers();
        ConfigurationManager config = this.plugin.getGlobalStateManager();
        for (Player player : players) {
            PlayerFlagState state;
            WorldConfiguration worldConfig = config.get(player.getWorld());
            if (!worldConfig.useRegions) continue;
            FlagStateManager flagStateManager = this;
            synchronized (flagStateManager) {
                state = this.states.get(player.getName());
                if (state == null) {
                    state = new PlayerFlagState();
                    this.states.put(player.getName(), state);
                }
            }
            Vector playerLocation = BukkitUtil.toVector(player.getLocation());
            RegionManager regionManager = this.plugin.getGlobalRegionManager().get(player.getWorld());
            ApplicableRegionSet applicable = regionManager.getApplicableRegions(playerLocation);
            this.processHeal(applicable, player, state);
        }
    }

    private void processHeal(ApplicableRegionSet applicable, Player player, PlayerFlagState state) {
        if (player.getHealth() <= 0) {
            return;
        }
        long now = System.currentTimeMillis();
        Integer healAmount = (Integer)applicable.getFlag(DefaultFlag.HEAL_AMOUNT);
        Integer healDelay = (Integer)applicable.getFlag(DefaultFlag.HEAL_DELAY);
        if (healAmount == null || healDelay == null || healAmount == 0 || healDelay < 0) {
            return;
        }
        if (player.getHealth() >= 20 && healAmount > 0) {
            return;
        }
        if (healDelay <= 0 && healAmount > 0) {
            player.setHealth(20);
            state.lastHeal = now;
        } else if (now - state.lastHeal > (long)(healDelay * 1000)) {
            player.setHealth(Math.min(20, Math.max(0, player.getHealth() + healAmount)));
            state.lastHeal = now;
        }
    }

    public synchronized void forget(Player player) {
        this.states.remove(player.getName());
    }

    public synchronized PlayerFlagState getState(Player player) {
        PlayerFlagState state = this.states.get(player.getName());
        if (state == null) {
            state = new PlayerFlagState();
            this.states.put(player.getName(), state);
        }
        return state;
    }

    public static class PlayerFlagState {
        public long lastHeal;
        public String lastGreeting;
        public String lastFarewell;
        public Boolean lastExitAllowed = null;
        public Boolean notifiedForLeave = false;
        public Boolean notifiedForEnter = false;
        public World lastWorld;
        public int lastBlockX;
        public int lastBlockY;
        public int lastBlockZ;
    }
}

