/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.worldguard.bukkit;

import com.sk89q.worldguard.bukkit.WorldGuardPlugin;
import com.sk89q.worldguard.protection.databases.CSVDatabase;
import com.sk89q.worldguard.protection.managers.RegionManager;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.logging.Logger;
import org.bukkit.World;

public class LegacyWorldGuardMigration {
    protected static final Logger logger = Logger.getLogger("Minecraft.WorldGuard");

    public static void migrateBlacklist(WorldGuardPlugin plugin) {
        World mainWorld = (World)plugin.getServer().getWorlds().get(0);
        String mainWorldName = mainWorld.getName();
        String newPath = "worlds/" + mainWorldName + "/blacklist.txt";
        File oldFile = new File(plugin.getDataFolder(), "blacklist.txt");
        File newFile = new File(plugin.getDataFolder(), newPath);
        if (!newFile.exists() && oldFile.exists()) {
            logger.warning("WorldGuard: WorldGuard will now update your blacklist from an older version of WorldGuard.");
            newFile.getParentFile().mkdirs();
            if (LegacyWorldGuardMigration.copyFile(oldFile, newFile)) {
                oldFile.renameTo(new File(plugin.getDataFolder(), "blacklist.txt.old"));
            } else {
                logger.warning("WorldGuard: blacklist.txt has been converted for the main world at " + newPath + "");
                logger.warning("WorldGuard: Your other worlds currently have no blacklist defined!");
            }
        }
    }

    public static void migrateRegions(WorldGuardPlugin plugin) {
        try {
            File oldDatabase = new File(plugin.getDataFolder(), "regions.txt");
            if (!oldDatabase.exists()) {
                return;
            }
            logger.info("WorldGuard: The regions database has changed in 4.x. Your old regions database will be converted to the new format and set as your primarily world's database.");
            World w = (World)plugin.getServer().getWorlds().get(0);
            RegionManager mgr = plugin.getGlobalRegionManager().get(w);
            CSVDatabase db = new CSVDatabase(oldDatabase);
            db.load();
            mgr.setRegions(db.getRegions());
            mgr.save();
            oldDatabase.renameTo(new File(plugin.getDataFolder(), "regions.txt.old"));
            logger.info("WorldGuard: Regions database converted!");
        }
        catch (FileNotFoundException e) {
        }
        catch (IOException e) {
            logger.warning("WorldGuard: Failed to load regions: " + e.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean copyFile(File from, File to) {
        FileInputStream in = null;
        OutputStream out = null;
        try {
            int len;
            in = new FileInputStream(from);
            out = new FileOutputStream(to);
            byte[] buf = new byte[1024];
            while ((len = ((InputStream)in).read(buf)) > 0) {
                out.write(buf, 0, len);
            }
            ((InputStream)in).close();
            out.close();
            boolean bl = true;
            return bl;
        }
        catch (FileNotFoundException ex) {
        }
        catch (IOException e) {
        }
        finally {
            if (in != null) {
                try {
                    ((InputStream)in).close();
                }
                catch (IOException e) {}
            }
            if (out != null) {
                try {
                    out.close();
                }
                catch (IOException e) {}
            }
        }
        return false;
    }
}

