/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.worldguard.bukkit;

import com.sk89q.worldedit.BlockVector;
import com.sk89q.worldedit.Vector;
import com.sk89q.worldguard.LocalPlayer;
import com.sk89q.worldguard.blacklist.events.BlockInteractBlacklistEvent;
import com.sk89q.worldguard.blacklist.events.ItemAcquireBlacklistEvent;
import com.sk89q.worldguard.blacklist.events.ItemDropBlacklistEvent;
import com.sk89q.worldguard.blacklist.events.ItemUseBlacklistEvent;
import com.sk89q.worldguard.bukkit.BukkitUtil;
import com.sk89q.worldguard.bukkit.ConfigurationManager;
import com.sk89q.worldguard.bukkit.FlagStateManager;
import com.sk89q.worldguard.bukkit.WorldConfiguration;
import com.sk89q.worldguard.bukkit.WorldGuardPlugin;
import com.sk89q.worldguard.protection.ApplicableRegionSet;
import com.sk89q.worldguard.protection.flags.DefaultFlag;
import com.sk89q.worldguard.protection.flags.RegionGroupFlag;
import com.sk89q.worldguard.protection.managers.RegionManager;
import com.sk89q.worldguard.protection.regions.ProtectedRegion;
import java.util.Iterator;
import java.util.Set;
import java.util.logging.Logger;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Item;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.entity.Tameable;
import org.bukkit.event.Event;
import org.bukkit.event.Listener;
import org.bukkit.event.block.Action;
import org.bukkit.event.player.PlayerBedEnterEvent;
import org.bukkit.event.player.PlayerBucketEmptyEvent;
import org.bukkit.event.player.PlayerBucketFillEvent;
import org.bukkit.event.player.PlayerCommandPreprocessEvent;
import org.bukkit.event.player.PlayerDropItemEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.event.player.PlayerItemHeldEvent;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerListener;
import org.bukkit.event.player.PlayerLoginEvent;
import org.bukkit.event.player.PlayerMoveEvent;
import org.bukkit.event.player.PlayerPickupItemEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.event.player.PlayerRespawnEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.PluginManager;

public class WorldGuardPlayerListener
extends PlayerListener {
    private static final Logger logger = Logger.getLogger("Minecraft.WorldGuard");
    private WorldGuardPlugin plugin;

    public WorldGuardPlayerListener(WorldGuardPlugin plugin) {
        this.plugin = plugin;
    }

    public void registerEvents() {
        PluginManager pm = this.plugin.getServer().getPluginManager();
        this.registerEvent("PLAYER_INTERACT", Event.Priority.High);
        this.registerEvent("PLAYER_DROP_ITEM", Event.Priority.High);
        this.registerEvent("PLAYER_PICKUP_ITEM", Event.Priority.High);
        this.registerEvent("PLAYER_JOIN", Event.Priority.Normal);
        this.registerEvent("PLAYER_LOGIN", Event.Priority.Normal);
        this.registerEvent("PLAYER_QUIT", Event.Priority.Normal);
        this.registerEvent("PLAYER_BUCKET_FILL", Event.Priority.High);
        this.registerEvent("PLAYER_BUCKET_EMPTY", Event.Priority.High);
        this.registerEvent("PLAYER_RESPAWN", Event.Priority.High);
        this.registerEvent("PLAYER_ITEM_HELD", Event.Priority.High);
        this.registerEvent("PLAYER_BED_ENTER", Event.Priority.High);
        this.registerEvent("PLAYER_MOVE", Event.Priority.High);
        this.registerEvent("PLAYER_COMMAND_PREPROCESS", Event.Priority.High);
    }

    private void registerEvent(String typeName, Event.Priority priority) {
        try {
            Event.Type type = Event.Type.valueOf((String)typeName);
            PluginManager pm = this.plugin.getServer().getPluginManager();
            pm.registerEvent(type, (Listener)this, priority, (Plugin)this.plugin);
        }
        catch (IllegalArgumentException e) {
            logger.info("WorldGuard: Unable to register missing event type " + typeName);
        }
    }

    public void onPlayerLogin(PlayerLoginEvent event) {
        Player player = event.getPlayer();
        ConfigurationManager cfg = this.plugin.getGlobalStateManager();
        WorldConfiguration wcfg = cfg.get(player.getWorld());
        if (wcfg.enforceOneSession) {
            String name = player.getName();
            for (Player pl : this.plugin.getServer().getOnlinePlayers()) {
                if (!pl.getName().equalsIgnoreCase(name)) continue;
                pl.kickPlayer("Logged in from another location.");
            }
        }
    }

    public void onPlayerJoin(PlayerJoinEvent event) {
        Player player = event.getPlayer();
        World world = player.getWorld();
        ConfigurationManager cfg = this.plugin.getGlobalStateManager();
        WorldConfiguration wcfg = cfg.get(player.getWorld());
        if (cfg.activityHaltToggle) {
            player.sendMessage(ChatColor.YELLOW + "Intensive server activity has been HALTED.");
            int removed = 0;
            for (Entity entity : player.getWorld().getEntities()) {
                if (!(entity instanceof Item) && (!(entity instanceof LivingEntity) || entity instanceof Tameable || entity instanceof Player)) continue;
                entity.remove();
                ++removed;
            }
            if (removed > 10) {
                logger.info("WG Halt-Act: " + removed + " entities (>10) auto-removed from " + player.getWorld().toString());
            }
        }
        if (wcfg.fireSpreadDisableToggle) {
            player.sendMessage(ChatColor.YELLOW + "Fire spread is currently globally disabled for this world.");
        }
        if (this.plugin.inGroup(player, "wg-invincible") || cfg.autoGodMode && this.plugin.hasPermission((CommandSender)player, "worldguard.auto-invincible")) {
            cfg.enableGodMode(player);
        }
        if (this.plugin.inGroup(player, "wg-amphibious")) {
            cfg.enableAmphibiousMode(player);
        }
        if (wcfg.useRegions) {
            FlagStateManager.PlayerFlagState state = this.plugin.getFlagStateManager().getState(player);
            Location loc = player.getLocation();
            state.lastWorld = loc.getWorld();
            state.lastBlockX = loc.getBlockX();
            state.lastBlockY = loc.getBlockY();
            state.lastBlockZ = loc.getBlockZ();
        }
    }

    public void onPlayerQuit(PlayerQuitEvent event) {
        Player player = event.getPlayer();
        World world = player.getWorld();
        ConfigurationManager cfg = this.plugin.getGlobalStateManager();
        WorldConfiguration wcfg = cfg.get(world);
        if (wcfg.useRegions) {
            boolean hasBypass = this.plugin.getGlobalRegionManager().hasBypass(player, world);
            FlagStateManager.PlayerFlagState state = this.plugin.getFlagStateManager().getState(player);
            if (state.lastWorld != null && !hasBypass) {
                LocalPlayer localPlayer = this.plugin.wrapPlayer(player);
                RegionManager mgr = this.plugin.getGlobalRegionManager().get(world);
                Location loc = player.getLocation();
                Vector pt = new Vector(loc.getBlockX(), loc.getBlockY(), loc.getBlockZ());
                ApplicableRegionSet set = mgr.getApplicableRegions(pt);
                if (state.lastExitAllowed == null) {
                    state.lastExitAllowed = set.allows(DefaultFlag.EXIT, localPlayer);
                }
                if (!(state.lastExitAllowed.booleanValue() && set.allows(DefaultFlag.ENTRY, localPlayer) || !state.lastWorld.equals(world))) {
                    Location newLoc = new Location(world, (double)state.lastBlockX + 0.5, (double)state.lastBlockY, (double)state.lastBlockZ + 0.5);
                    player.teleport(newLoc);
                }
            }
        }
        cfg.forgetPlayer(this.plugin.wrapPlayer(player));
        this.plugin.forgetPlayer(player);
    }

    public void onPlayerInteract(PlayerInteractEvent event) {
        Player player = event.getPlayer();
        World world = player.getWorld();
        if (event.getAction() == Action.RIGHT_CLICK_BLOCK) {
            this.handleBlockRightClick(event);
        } else if (event.getAction() == Action.RIGHT_CLICK_AIR) {
            this.handleAirRightClick(event);
        } else if (event.getAction() == Action.LEFT_CLICK_BLOCK) {
            this.handleBlockLeftClick(event);
        } else if (event.getAction() == Action.LEFT_CLICK_AIR) {
            this.handleAirLeftClick(event);
        } else if (event.getAction() == Action.PHYSICAL) {
            this.handlePhysicalInteract(event);
        }
        ConfigurationManager cfg = this.plugin.getGlobalStateManager();
        WorldConfiguration wcfg = cfg.get(world);
        if (wcfg.removeInfiniteStacks && !this.plugin.hasPermission((CommandSender)player, "worldguard.override.infinite-stack")) {
            int slot = player.getInventory().getHeldItemSlot();
            ItemStack heldItem = player.getInventory().getItem(slot);
            if (heldItem.getAmount() < 0) {
                player.getInventory().setItem(slot, null);
                player.sendMessage(ChatColor.RED + "Infinite stack removed.");
            }
        }
    }

    public void onPlayerMove(PlayerMoveEvent event) {
        Player player = event.getPlayer();
        World world = player.getWorld();
        ConfigurationManager cfg = this.plugin.getGlobalStateManager();
        WorldConfiguration wcfg = cfg.get(world);
        if (wcfg.useRegions && (event.getFrom().getBlockX() != event.getTo().getBlockX() || event.getFrom().getBlockY() != event.getTo().getBlockY() || event.getFrom().getBlockZ() != event.getTo().getBlockZ())) {
            FlagStateManager.PlayerFlagState state = this.plugin.getFlagStateManager().getState(player);
            LocalPlayer localPlayer = this.plugin.wrapPlayer(player);
            boolean hasBypass = this.plugin.getGlobalRegionManager().hasBypass(player, world);
            RegionManager mgr = this.plugin.getGlobalRegionManager().get(world);
            Vector pt = new Vector(event.getTo().getBlockX(), event.getTo().getBlockY(), event.getTo().getBlockZ());
            ApplicableRegionSet set = mgr.getApplicableRegions(pt);
            boolean entryAllowed = set.allows(DefaultFlag.ENTRY, localPlayer);
            if (!hasBypass && !entryAllowed) {
                player.sendMessage(ChatColor.DARK_RED + "You are not permitted to enter this area.");
                Location newLoc = event.getFrom();
                newLoc.setX((double)newLoc.getBlockX() + 0.5);
                newLoc.setY((double)newLoc.getBlockY());
                newLoc.setZ((double)newLoc.getBlockZ() + 0.5);
                event.setTo(newLoc);
                return;
            }
            if (state.lastExitAllowed == null) {
                state.lastExitAllowed = mgr.getApplicableRegions(BukkitUtil.toVector(event.getFrom())).allows(DefaultFlag.EXIT, localPlayer);
            }
            boolean exitAllowed = set.allows(DefaultFlag.EXIT, localPlayer);
            if (!hasBypass && exitAllowed && !state.lastExitAllowed.booleanValue()) {
                player.sendMessage(ChatColor.DARK_RED + "You are not permitted to leave this area.");
                Location newLoc = event.getFrom();
                newLoc.setX((double)newLoc.getBlockX() + 0.5);
                newLoc.setY((double)newLoc.getBlockY());
                newLoc.setZ((double)newLoc.getBlockZ() + 0.5);
                event.setTo(newLoc);
                return;
            }
            String greeting = (String)set.getFlag(DefaultFlag.GREET_MESSAGE);
            String farewell = (String)set.getFlag(DefaultFlag.FAREWELL_MESSAGE);
            Boolean notifyEnter = (Boolean)set.getFlag(DefaultFlag.NOTIFY_ENTER);
            Boolean notifyLeave = (Boolean)set.getFlag(DefaultFlag.NOTIFY_LEAVE);
            if (!(state.lastFarewell == null || farewell != null && state.lastFarewell.equals(farewell))) {
                String replacedFarewell = this.plugin.replaceMacros((CommandSender)player, BukkitUtil.replaceColorMacros(state.lastFarewell));
                player.sendMessage(ChatColor.AQUA + " ** " + replacedFarewell);
            }
            if (!(greeting == null || state.lastGreeting != null && state.lastGreeting.equals(greeting))) {
                String replacedGreeting = this.plugin.replaceMacros((CommandSender)player, BukkitUtil.replaceColorMacros(greeting));
                player.sendMessage(ChatColor.AQUA + " ** " + replacedGreeting);
            }
            if ((notifyLeave == null || !notifyLeave.booleanValue()) && state.notifiedForLeave != null && state.notifiedForLeave.booleanValue()) {
                this.plugin.broadcastNotification(ChatColor.GRAY + "WG: " + ChatColor.LIGHT_PURPLE + player.getName() + ChatColor.GOLD + " left NOTIFY region");
            }
            if (notifyEnter != null && notifyEnter.booleanValue() && (state.notifiedForEnter == null || !state.notifiedForEnter.booleanValue())) {
                StringBuilder regionList = new StringBuilder();
                for (ProtectedRegion region : set) {
                    if (regionList.length() != 0) {
                        regionList.append(", ");
                    }
                    regionList.append(region.getId());
                }
                this.plugin.broadcastNotification(ChatColor.GRAY + "WG: " + ChatColor.LIGHT_PURPLE + player.getName() + ChatColor.GOLD + " entered NOTIFY region: " + ChatColor.WHITE + regionList);
            }
            state.lastGreeting = greeting;
            state.lastFarewell = farewell;
            state.notifiedForEnter = notifyEnter;
            state.notifiedForLeave = notifyLeave;
            state.lastExitAllowed = exitAllowed;
            state.lastWorld = event.getTo().getWorld();
            state.lastBlockX = event.getTo().getBlockX();
            state.lastBlockY = event.getTo().getBlockY();
            state.lastBlockZ = event.getTo().getBlockZ();
        }
    }

    private void handleAirLeftClick(PlayerInteractEvent event) {
    }

    private void handleBlockLeftClick(PlayerInteractEvent event) {
        if (event.isCancelled()) {
            return;
        }
        Player player = event.getPlayer();
        Block block = event.getClickedBlock();
        Material type = block.getType();
        World world = player.getWorld();
        ConfigurationManager cfg = this.plugin.getGlobalStateManager();
        WorldConfiguration wcfg = cfg.get(world);
        if (wcfg.useRegions) {
            BlockVector pt = BukkitUtil.toVector(block);
            RegionManager mgr = this.plugin.getGlobalRegionManager().get(world);
            ApplicableRegionSet set = mgr.getApplicableRegions(pt);
            LocalPlayer localPlayer = this.plugin.wrapPlayer(player);
            if (!(type != Material.STONE_BUTTON && type != Material.LEVER && type != Material.WOODEN_DOOR && type != Material.TRAP_DOOR && type != Material.NOTE_BLOCK || this.plugin.getGlobalRegionManager().hasBypass(player, world) || set.allows(DefaultFlag.USE) || set.canBuild(localPlayer))) {
                player.sendMessage(ChatColor.DARK_RED + "You don't have permission to use that in this area.");
                event.setUseInteractedBlock(Event.Result.DENY);
                event.setCancelled(true);
                return;
            }
        }
    }

    private void handleAirRightClick(PlayerInteractEvent event) {
        if (event.isCancelled()) {
            return;
        }
        Player player = event.getPlayer();
        World world = player.getWorld();
        ItemStack item = player.getItemInHand();
        ConfigurationManager cfg = this.plugin.getGlobalStateManager();
        WorldConfiguration wcfg = cfg.get(world);
        if (wcfg.getBlacklist() != null && !wcfg.getBlacklist().check(new ItemUseBlacklistEvent(this.plugin.wrapPlayer(player), BukkitUtil.toVector(player.getLocation()), item.getTypeId()), false, false)) {
            event.setCancelled(true);
            event.setUseItemInHand(Event.Result.DENY);
            return;
        }
    }

    private void handleBlockRightClick(PlayerInteractEvent event) {
        if (event.isCancelled()) {
            return;
        }
        Block block = event.getClickedBlock();
        World world = block.getWorld();
        Material type = block.getType();
        Player player = event.getPlayer();
        ItemStack item = player.getItemInHand();
        ConfigurationManager cfg = this.plugin.getGlobalStateManager();
        WorldConfiguration wcfg = cfg.get(world);
        if ((type == Material.CHEST || type == Material.JUKEBOX || type == Material.DISPENSER || type == Material.FURNACE || type == Material.BURNING_FURNACE) && wcfg.removeInfiniteStacks && !this.plugin.hasPermission((CommandSender)player, "worldguard.override.infinite-stack")) {
            for (int slot = 0; slot < 40; ++slot) {
                ItemStack heldItem = player.getInventory().getItem(slot);
                if (heldItem == null || heldItem.getAmount() >= 0) continue;
                player.getInventory().setItem(slot, null);
                player.sendMessage(ChatColor.RED + "Infinite stack in slot #" + slot + " removed.");
            }
        }
        if (wcfg.useRegions) {
            BlockVector pt = BukkitUtil.toVector(block);
            RegionManager mgr = this.plugin.getGlobalRegionManager().get(world);
            ApplicableRegionSet set = mgr.getApplicableRegions(pt);
            LocalPlayer localPlayer = this.plugin.wrapPlayer(player);
            if (item.getTypeId() == wcfg.regionWand) {
                if (set.size() > 0) {
                    player.sendMessage(ChatColor.YELLOW + "Can you build? " + (set.canBuild(localPlayer) ? "Yes" : "No"));
                    StringBuilder str = new StringBuilder();
                    Iterator<ProtectedRegion> it = set.iterator();
                    while (it.hasNext()) {
                        str.append(it.next().getId());
                        if (!it.hasNext()) continue;
                        str.append(", ");
                    }
                    player.sendMessage(ChatColor.YELLOW + "Applicable regions: " + str.toString());
                } else {
                    player.sendMessage(ChatColor.YELLOW + "WorldGuard: No defined regions here!");
                }
                event.setCancelled(true);
                return;
            }
            if (item.getType() == Material.INK_SACK && item.getData() != null && item.getData().getData() == 15 && type == Material.GRASS && !this.plugin.getGlobalRegionManager().hasBypass(player, world) && !set.canBuild(localPlayer)) {
                event.setCancelled(true);
                event.setUseInteractedBlock(Event.Result.DENY);
                event.setUseItemInHand(Event.Result.DENY);
            }
            if (!(type != Material.CHEST && type != Material.JUKEBOX && type != Material.DISPENSER && type != Material.FURNACE && type != Material.BURNING_FURNACE || this.plugin.getGlobalRegionManager().hasBypass(player, world) || set.allows(DefaultFlag.CHEST_ACCESS) || set.canBuild(localPlayer))) {
                player.sendMessage(ChatColor.DARK_RED + "You don't have permission to open that in this area.");
                event.setCancelled(true);
                return;
            }
            if (!(type != Material.LEVER && type != Material.STONE_BUTTON && type != Material.NOTE_BLOCK && type != Material.DIODE_BLOCK_OFF && type != Material.DIODE_BLOCK_ON && type != Material.WOODEN_DOOR && type != Material.TRAP_DOOR && type != Material.WORKBENCH || this.plugin.getGlobalRegionManager().hasBypass(player, world) || set.allows(DefaultFlag.USE) || set.canBuild(localPlayer))) {
                player.sendMessage(ChatColor.DARK_RED + "You don't have permission to use that in this area.");
                event.setUseInteractedBlock(Event.Result.DENY);
                event.setCancelled(true);
                return;
            }
            if (type == Material.CAKE_BLOCK && !this.plugin.getGlobalRegionManager().hasBypass(player, world) && !set.canBuild(localPlayer)) {
                player.sendMessage(ChatColor.DARK_RED + "You're not invited to this tea party!");
                event.setCancelled(true);
                return;
            }
            if (!(type != Material.RAILS && type != Material.POWERED_RAIL && type != Material.DETECTOR_RAIL || item.getType() != Material.MINECART || this.plugin.getGlobalRegionManager().hasBypass(player, world) || set.canBuild(localPlayer) || set.allows(DefaultFlag.PLACE_VEHICLE))) {
                player.sendMessage(ChatColor.DARK_RED + "You don't have permission to place vehicles here.");
                event.setCancelled(true);
                return;
            }
            if (!(item.getType() != Material.BOAT || this.plugin.getGlobalRegionManager().hasBypass(player, world) || set.canBuild(localPlayer) || set.allows(DefaultFlag.PLACE_VEHICLE))) {
                player.sendMessage(ChatColor.DARK_RED + "You don't have permission to place vehicles here.");
                event.setCancelled(true);
                return;
            }
        }
        if (wcfg.getBlacklist() != null && block.getType() != Material.CHEST && block.getType() != Material.DISPENSER && block.getType() != Material.FURNACE && block.getType() != Material.BURNING_FURNACE) {
            if (!wcfg.getBlacklist().check(new ItemUseBlacklistEvent(this.plugin.wrapPlayer(player), BukkitUtil.toVector(block), item.getTypeId()), false, false)) {
                event.setCancelled(true);
                return;
            }
            if (!wcfg.getBlacklist().check(new BlockInteractBlacklistEvent(this.plugin.wrapPlayer(player), BukkitUtil.toVector(block), block.getTypeId()), false, false)) {
                event.setCancelled(true);
                return;
            }
        }
        if ((block.getType() == Material.CHEST || block.getType() == Material.DISPENSER || block.getType() == Material.FURNACE || block.getType() == Material.BURNING_FURNACE) && wcfg.isChestProtected(block, player)) {
            player.sendMessage(ChatColor.DARK_RED + "The chest is protected.");
            event.setCancelled(true);
            return;
        }
    }

    private void handlePhysicalInteract(PlayerInteractEvent event) {
        if (event.isCancelled()) {
            return;
        }
        Player player = event.getPlayer();
        Block block = event.getClickedBlock();
        Material type = block.getType();
        World world = player.getWorld();
        ConfigurationManager cfg = this.plugin.getGlobalStateManager();
        WorldConfiguration wcfg = cfg.get(world);
        if (block.getType() == Material.SOIL && wcfg.disablePlayerCropTrampling) {
            event.setCancelled(true);
            return;
        }
        if (wcfg.useRegions) {
            BlockVector pt = BukkitUtil.toVector(block);
            RegionManager mgr = this.plugin.getGlobalRegionManager().get(world);
            ApplicableRegionSet set = mgr.getApplicableRegions(pt);
            LocalPlayer localPlayer = this.plugin.wrapPlayer(player);
            if (!(type != Material.STONE_PLATE && type != Material.WOOD_PLATE || this.plugin.getGlobalRegionManager().hasBypass(player, world) || set.allows(DefaultFlag.USE) || set.canBuild(localPlayer))) {
                event.setUseInteractedBlock(Event.Result.DENY);
                event.setCancelled(true);
                return;
            }
        }
    }

    public void onPlayerDropItem(PlayerDropItemEvent event) {
        if (event.isCancelled()) {
            return;
        }
        ConfigurationManager cfg = this.plugin.getGlobalStateManager();
        WorldConfiguration wcfg = cfg.get(event.getPlayer().getWorld());
        if (wcfg.getBlacklist() != null) {
            Item ci = event.getItemDrop();
            if (!wcfg.getBlacklist().check(new ItemDropBlacklistEvent(this.plugin.wrapPlayer(event.getPlayer()), BukkitUtil.toVector(ci.getLocation()), ci.getItemStack().getTypeId()), false, false)) {
                event.setCancelled(true);
                return;
            }
        }
    }

    public void onPlayerPickupItem(PlayerPickupItemEvent event) {
        if (event.isCancelled()) {
            return;
        }
        ConfigurationManager cfg = this.plugin.getGlobalStateManager();
        WorldConfiguration wcfg = cfg.get(event.getPlayer().getWorld());
        if (wcfg.getBlacklist() != null) {
            Item ci = event.getItem();
            if (!wcfg.getBlacklist().check(new ItemAcquireBlacklistEvent(this.plugin.wrapPlayer(event.getPlayer()), BukkitUtil.toVector(ci.getLocation()), ci.getItemStack().getTypeId()), false, true)) {
                event.setCancelled(true);
                return;
            }
        }
    }

    public void onPlayerBucketFill(PlayerBucketFillEvent event) {
        Player player = event.getPlayer();
        World world = player.getWorld();
        ConfigurationManager cfg = this.plugin.getGlobalStateManager();
        WorldConfiguration wcfg = cfg.get(world);
        if (!this.plugin.getGlobalRegionManager().canBuild(player, event.getBlockClicked())) {
            player.sendMessage(ChatColor.DARK_RED + "You don't have permission for this area.");
            event.setCancelled(true);
            return;
        }
        if (wcfg.getBlacklist() != null && !wcfg.getBlacklist().check(new ItemUseBlacklistEvent(this.plugin.wrapPlayer(player), BukkitUtil.toVector(player.getLocation()), event.getBucket().getId()), false, false)) {
            event.setCancelled(true);
            return;
        }
    }

    public void onPlayerBucketEmpty(PlayerBucketEmptyEvent event) {
        Player player = event.getPlayer();
        World world = player.getWorld();
        ConfigurationManager cfg = this.plugin.getGlobalStateManager();
        WorldConfiguration wcfg = cfg.get(world);
        if (!this.plugin.getGlobalRegionManager().canBuild(player, event.getBlockClicked())) {
            player.sendMessage(ChatColor.DARK_RED + "You don't have permission for this area.");
            event.setCancelled(true);
            return;
        }
        if (wcfg.getBlacklist() != null && !wcfg.getBlacklist().check(new ItemUseBlacklistEvent(this.plugin.wrapPlayer(player), BukkitUtil.toVector(player.getLocation()), event.getBucket().getId()), false, false)) {
            event.setCancelled(true);
            return;
        }
    }

    public void onPlayerRespawn(PlayerRespawnEvent event) {
        Player player = event.getPlayer();
        Location location = player.getLocation();
        ConfigurationManager cfg = this.plugin.getGlobalStateManager();
        WorldConfiguration wcfg = cfg.get(player.getWorld());
        if (wcfg.useRegions) {
            Vector pt = BukkitUtil.toVector(location);
            RegionManager mgr = this.plugin.getGlobalRegionManager().get(player.getWorld());
            ApplicableRegionSet set = mgr.getApplicableRegions(pt);
            Vector spawn = (Vector)set.getFlag(DefaultFlag.SPAWN_LOC);
            if (spawn != null) {
                RegionGroupFlag.RegionGroup group = (RegionGroupFlag.RegionGroup)((Object)set.getFlag(DefaultFlag.SPAWN_PERM));
                Location spawnLoc = BukkitUtil.toLocation(player.getWorld(), spawn);
                if (group != null) {
                    LocalPlayer localPlayer = this.plugin.wrapPlayer(player);
                    if (RegionGroupFlag.isMember(set, group, localPlayer)) {
                        event.setRespawnLocation(spawnLoc);
                    }
                } else {
                    event.setRespawnLocation(spawnLoc);
                }
            }
        }
    }

    public void onItemHeldChange(PlayerItemHeldEvent event) {
        Player player = event.getPlayer();
        ConfigurationManager cfg = this.plugin.getGlobalStateManager();
        WorldConfiguration wcfg = cfg.get(player.getWorld());
        if (wcfg.removeInfiniteStacks && !this.plugin.hasPermission((CommandSender)player, "worldguard.override.infinite-stack")) {
            int newSlot = event.getNewSlot();
            ItemStack heldItem = player.getInventory().getItem(newSlot);
            if (heldItem.getAmount() < 0) {
                player.getInventory().setItem(newSlot, null);
                player.sendMessage(ChatColor.RED + "Infinite stack removed.");
            }
        }
    }

    public void onPlayerBedEnter(PlayerBedEnterEvent event) {
        if (event.isCancelled()) {
            return;
        }
        Player player = event.getPlayer();
        Location location = player.getLocation();
        ConfigurationManager cfg = this.plugin.getGlobalStateManager();
        WorldConfiguration wcfg = cfg.get(player.getWorld());
        if (wcfg.useRegions) {
            Vector pt = BukkitUtil.toVector(location);
            RegionManager mgr = this.plugin.getGlobalRegionManager().get(player.getWorld());
            ApplicableRegionSet set = mgr.getApplicableRegions(pt);
            if (!this.plugin.getGlobalRegionManager().hasBypass(player, player.getWorld()) && !set.allows(DefaultFlag.SLEEP)) {
                event.setCancelled(true);
                player.sendMessage("This bed doesn't belong to you!");
                return;
            }
        }
    }

    public void onPlayerCommandPreprocess(PlayerCommandPreprocessEvent event) {
        Player player = event.getPlayer();
        World world = player.getWorld();
        ConfigurationManager cfg = this.plugin.getGlobalStateManager();
        WorldConfiguration wcfg = cfg.get(world);
        if (wcfg.useRegions && !this.plugin.getGlobalRegionManager().hasBypass(player, world)) {
            Vector pt = BukkitUtil.toVector(player.getLocation());
            RegionManager mgr = this.plugin.getGlobalRegionManager().get(world);
            ApplicableRegionSet set = mgr.getApplicableRegions(pt);
            String[] parts = event.getMessage().split(" ");
            Set allowedCommands = (Set)set.getFlag(DefaultFlag.ALLOWED_CMDS);
            if (allowedCommands != null && !allowedCommands.contains(parts[0].toLowerCase())) {
                player.sendMessage(ChatColor.RED + parts[0].toLowerCase() + " is not allowed in this area.");
                event.setCancelled(true);
                return;
            }
            Set blockedCommands = (Set)set.getFlag(DefaultFlag.BLOCKED_CMDS);
            if (blockedCommands != null && blockedCommands.contains(parts[0].toLowerCase())) {
                player.sendMessage(ChatColor.RED + parts[0].toLowerCase() + " is blocked in this area.");
                event.setCancelled(true);
                return;
            }
        }
    }
}

