/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.worldguard.bukkit.commands;

import com.sk89q.minecraft.util.commands.Command;
import com.sk89q.minecraft.util.commands.CommandContext;
import com.sk89q.minecraft.util.commands.CommandException;
import com.sk89q.minecraft.util.commands.CommandPermissions;
import com.sk89q.worldguard.bukkit.ConfigurationManager;
import com.sk89q.worldguard.bukkit.WorldConfiguration;
import com.sk89q.worldguard.bukkit.WorldGuardPlugin;
import org.bukkit.ChatColor;
import org.bukkit.World;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Item;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.entity.Tameable;

public class ToggleCommands {
    @Command(aliases={"stopfire"}, usage="[<world>]", desc="Disables all fire spread temporarily", flags="", min=0, max=1)
    @CommandPermissions(value={"worldguard.fire-toggle.stop"})
    public static void stopFire(CommandContext args, WorldGuardPlugin plugin, CommandSender sender) throws CommandException {
        World world = args.argsLength() == 0 ? plugin.checkPlayer(sender).getWorld() : plugin.matchWorld(sender, args.getString(0));
        WorldConfiguration wcfg = plugin.getGlobalStateManager().get(world);
        if (!wcfg.fireSpreadDisableToggle) {
            plugin.getServer().broadcastMessage(ChatColor.YELLOW + "Fire spread has been globally disabled for '" + world.getName() + "' by " + plugin.toName(sender) + ".");
        } else {
            sender.sendMessage(ChatColor.YELLOW + "Fire spread was already globally disabled.");
        }
        wcfg.fireSpreadDisableToggle = true;
    }

    @Command(aliases={"allowfire"}, usage="[<world>]", desc="Allows all fire spread temporarily", flags="", min=0, max=1)
    @CommandPermissions(value={"worldguard.fire-toggle.stop"})
    public static void allowFire(CommandContext args, WorldGuardPlugin plugin, CommandSender sender) throws CommandException {
        World world = args.argsLength() == 0 ? plugin.checkPlayer(sender).getWorld() : plugin.matchWorld(sender, args.getString(0));
        WorldConfiguration wcfg = plugin.getGlobalStateManager().get(world);
        if (wcfg.fireSpreadDisableToggle) {
            plugin.getServer().broadcastMessage(ChatColor.YELLOW + "Fire spread has been globally for '" + world.getName() + "' re-enabled by " + plugin.toName(sender) + ".");
        } else {
            sender.sendMessage(ChatColor.YELLOW + "Fire spread was already globally enabled.");
        }
        wcfg.fireSpreadDisableToggle = false;
    }

    @Command(aliases={"halt-activity"}, usage="", desc="Attempts to cease as much activity in order to stop lag", flags="c", min=0, max=0)
    @CommandPermissions(value={"worldguard.halt-activity"})
    public static void stopLag(CommandContext args, WorldGuardPlugin plugin, CommandSender sender) throws CommandException {
        ConfigurationManager configManager = plugin.getGlobalStateManager();
        boolean bl = configManager.activityHaltToggle = !args.hasFlag('c');
        if (configManager.activityHaltToggle) {
            if (!(sender instanceof Player)) {
                sender.sendMessage(ChatColor.YELLOW + "ALL intensive server activity halted.");
            }
            plugin.getServer().broadcastMessage(ChatColor.YELLOW + "ALL intensive server activity halted by " + plugin.toName(sender) + ".");
            for (World world : plugin.getServer().getWorlds()) {
                int removed = 0;
                for (Entity entity : world.getEntities()) {
                    if (!(entity instanceof Item) && (!(entity instanceof LivingEntity) || entity instanceof Tameable || entity instanceof Player)) continue;
                    entity.remove();
                    ++removed;
                }
                if (removed <= 10) continue;
                sender.sendMessage("" + removed + " entities (>10) auto-removed from " + world.toString());
            }
        } else {
            if (!(sender instanceof Player)) {
                sender.sendMessage(ChatColor.YELLOW + "ALL intensive server activity no longer halted.");
            }
            plugin.getServer().broadcastMessage(ChatColor.YELLOW + "ALL intensive server activity is now allowed.");
        }
    }
}

