/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.worldguard.domains;

import com.sk89q.worldguard.LocalPlayer;
import com.sk89q.worldguard.domains.Domain;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultDomain
implements Domain {
    private Set<String> groups = new LinkedHashSet<String>();
    private Set<String> players = new HashSet<String>();

    public void addPlayer(String name) {
        this.players.add(name.toLowerCase());
    }

    public void addPlayer(LocalPlayer player) {
        this.players.add(player.getName().toLowerCase());
    }

    public void removePlayer(String name) {
        this.players.remove(name.toLowerCase());
    }

    public void removePlayer(LocalPlayer player) {
        this.players.remove(player.getName().toLowerCase());
    }

    public void addGroup(String name) {
        this.groups.add(name.toLowerCase());
    }

    public void removeGroup(String name) {
        this.groups.remove(name.toLowerCase());
    }

    public Set<String> getGroups() {
        return this.groups;
    }

    public Set<String> getPlayers() {
        return this.players;
    }

    @Override
    public boolean contains(LocalPlayer player) {
        if (this.players.contains(player.getName().toLowerCase())) {
            return true;
        }
        for (String group : this.groups) {
            if (!player.hasGroup(group)) continue;
            return true;
        }
        return false;
    }

    public int size() {
        return this.groups.size() + this.players.size();
    }

    public String toPlayersString() {
        StringBuilder str = new StringBuilder();
        Iterator<String> it = this.players.iterator();
        while (it.hasNext()) {
            str.append(it.next());
            if (!it.hasNext()) continue;
            str.append(", ");
        }
        return str.toString();
    }

    public String toGroupsString() {
        StringBuilder str = new StringBuilder();
        Iterator<String> it = this.groups.iterator();
        while (it.hasNext()) {
            str.append("*");
            str.append(it.next());
            if (!it.hasNext()) continue;
            str.append(", ");
        }
        return str.toString();
    }

    public String toUserFriendlyString() {
        StringBuilder str = new StringBuilder();
        if (this.players.size() > 0) {
            str.append(this.toPlayersString());
        }
        if (this.groups.size() > 0) {
            if (str.length() > 0) {
                str.append("; ");
            }
            str.append(this.toGroupsString());
        }
        return str.toString();
    }
}

