/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.worldguard.protection.regions;

import com.sk89q.worldedit.BlockVector;
import com.sk89q.worldedit.BlockVector2D;
import com.sk89q.worldedit.Vector;
import com.sk89q.worldguard.protection.UnsupportedIntersectionException;
import com.sk89q.worldguard.protection.regions.ProtectedCuboidRegion;
import com.sk89q.worldguard.protection.regions.ProtectedRegion;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProtectedPolygonalRegion
extends ProtectedRegion {
    protected List<BlockVector2D> points;
    protected int minY;
    protected int maxY;
    private BlockVector min;
    private BlockVector max;

    public ProtectedPolygonalRegion(String id, List<BlockVector2D> points, int minY, int maxY) {
        super(id);
        this.points = points;
        this.minY = minY;
        this.maxY = maxY;
        int minX = points.get(0).getBlockX();
        int minZ = points.get(0).getBlockZ();
        int maxX = points.get(0).getBlockX();
        int maxZ = points.get(0).getBlockZ();
        for (BlockVector2D v : points) {
            int x = v.getBlockX();
            int z = v.getBlockZ();
            if (x < minX) {
                minX = x;
            }
            if (z < minZ) {
                minZ = z;
            }
            if (x > maxX) {
                maxX = x;
            }
            if (z <= maxZ) continue;
            maxZ = z;
        }
        this.min = new BlockVector(minX, minY, minZ);
        this.max = new BlockVector(maxX, maxY, maxZ);
    }

    public List<BlockVector2D> getPoints() {
        return this.points;
    }

    @Override
    public BlockVector getMinimumPoint() {
        return this.min;
    }

    @Override
    public BlockVector getMaximumPoint() {
        return this.max;
    }

    @Override
    public boolean contains(Vector pt) {
        int targetX = pt.getBlockX();
        int targetY = pt.getBlockY();
        int targetZ = pt.getBlockZ();
        if (targetY < this.minY || targetY > this.maxY) {
            return false;
        }
        if (targetX < this.min.getBlockX() || targetX > this.max.getBlockX() || targetZ < this.min.getBlockZ() || targetZ > this.max.getBlockZ()) {
            return false;
        }
        boolean inside = false;
        int npoints = this.points.size();
        int xOld = this.points.get(npoints - 1).getBlockX();
        int zOld = this.points.get(npoints - 1).getBlockZ();
        for (int i = 0; i < npoints; ++i) {
            int z2;
            int z1;
            int x2;
            int x1;
            int xNew = this.points.get(i).getBlockX();
            int zNew = this.points.get(i).getBlockZ();
            if (xNew == targetX && zNew == targetZ) {
                return true;
            }
            if (xNew > xOld) {
                x1 = xOld;
                x2 = xNew;
                z1 = zOld;
                z2 = zNew;
            } else {
                x1 = xNew;
                x2 = xOld;
                z1 = zNew;
                z2 = zOld;
            }
            if (xNew < targetX == targetX <= xOld && ((long)targetZ - (long)z1) * (long)(x2 - x1) <= ((long)z2 - (long)z1) * (long)(targetX - x1)) {
                inside = !inside;
            }
            xOld = xNew;
            zOld = zNew;
        }
        return inside;
    }

    @Override
    public List<ProtectedRegion> getIntersectingRegions(List<ProtectedRegion> regions) throws UnsupportedIntersectionException {
        int numRegions = regions.size();
        int numPoints = this.points.size();
        ArrayList<ProtectedRegion> intersectingRegions = new ArrayList<ProtectedRegion>();
        block0: for (int i = 0; i < numRegions; ++i) {
            ProtectedRegion region = regions.get(i);
            BlockVector rMinPoint = region.getMinimumPoint();
            BlockVector rMaxPoint = region.getMaximumPoint();
            if (rMinPoint.getBlockX() < this.min.getBlockX() && rMaxPoint.getBlockX() < this.min.getBlockX() || rMinPoint.getBlockX() > this.max.getBlockX() && rMaxPoint.getBlockX() > this.max.getBlockX() && (rMinPoint.getBlockY() < this.min.getBlockY() && rMaxPoint.getBlockY() < this.min.getBlockY() || rMinPoint.getBlockY() > this.max.getBlockY() && rMaxPoint.getBlockY() > this.max.getBlockY()) && (rMinPoint.getBlockZ() < this.min.getBlockZ() && rMaxPoint.getBlockZ() < this.min.getBlockZ() || rMinPoint.getBlockZ() > this.max.getBlockZ() && rMaxPoint.getBlockZ() > this.max.getBlockZ())) {
                intersectingRegions.add(regions.get(i));
                continue;
            }
            int i2 = 0;
            while (i < numPoints) {
                Vector pt = new Vector(this.points.get(i2).getBlockX(), this.minY, this.points.get(i2).getBlockZ());
                Vector pt2 = new Vector(this.points.get(i2).getBlockX(), this.maxY, this.points.get(i2).getBlockZ());
                if (region.contains(pt) || region.contains(pt2)) {
                    intersectingRegions.add(regions.get(i));
                }
                ++i;
            }
            if (region instanceof ProtectedPolygonalRegion) {
                i2 = 0;
                while (i < ((ProtectedPolygonalRegion)region).getPoints().size()) {
                    BlockVector2D pt2Dr = ((ProtectedPolygonalRegion)region).getPoints().get(i2);
                    int minYr = ((ProtectedPolygonalRegion)region).minY;
                    int maxYr = ((ProtectedPolygonalRegion)region).maxY;
                    Vector ptr = new Vector(pt2Dr.getBlockX(), minYr, pt2Dr.getBlockZ());
                    Vector ptr2 = new Vector(pt2Dr.getBlockX(), maxYr, pt2Dr.getBlockZ());
                    if (this.contains(ptr) || this.contains(ptr2)) {
                        intersectingRegions.add(regions.get(i));
                    }
                    ++i;
                }
            } else if (region instanceof ProtectedCuboidRegion) {
                BlockVector ptcMin = region.getMinimumPoint();
                BlockVector ptcMax = region.getMaximumPoint();
                if (this.contains(new Vector(ptcMin.getBlockX(), ptcMin.getBlockY(), ptcMin.getBlockZ())) || this.contains(new Vector(ptcMin.getBlockX(), ptcMin.getBlockY(), ptcMax.getBlockZ())) || this.contains(new Vector(ptcMin.getBlockX(), ptcMax.getBlockY(), ptcMax.getBlockZ())) || this.contains(new Vector(ptcMin.getBlockX(), ptcMax.getBlockY(), ptcMin.getBlockZ())) || this.contains(new Vector(ptcMax.getBlockX(), ptcMax.getBlockY(), ptcMax.getBlockZ())) || this.contains(new Vector(ptcMax.getBlockX(), ptcMax.getBlockY(), ptcMin.getBlockZ())) || this.contains(new Vector(ptcMax.getBlockX(), ptcMin.getBlockY(), ptcMin.getBlockZ())) || this.contains(new Vector(ptcMax.getBlockX(), ptcMin.getBlockY(), ptcMax.getBlockZ()))) {
                    intersectingRegions.add(regions.get(i));
                    continue;
                }
            } else {
                throw new UnsupportedOperationException("Not supported yet.");
            }
            boolean regionIsIntersecting = false;
            for (i2 = 0; i2 < numPoints; ++i2) {
                boolean checkNextPoint = false;
                BlockVector2D currPoint = this.points.get(i2);
                BlockVector2D nextPoint = i2 == numPoints - 1 ? this.points.get(0) : this.points.get(i2 + 1);
                int currX = currPoint.getBlockX();
                int currZ = currPoint.getBlockZ();
                while (!checkNextPoint) {
                    for (int i3 = this.minY; i3 <= this.maxY; ++i3) {
                        if (!region.contains(new Vector(currX, i3, currZ))) continue;
                        intersectingRegions.add(regions.get(i));
                        regionIsIntersecting = true;
                        break;
                    }
                    if (currX == nextPoint.getBlockX() || currZ == nextPoint.getBlockZ() || regionIsIntersecting) {
                        checkNextPoint = true;
                    }
                    currX = nextPoint.getBlockX() > currPoint.getBlockX() ? ++currX : --currX;
                    if (nextPoint.getBlockZ() > currPoint.getBlockZ()) {
                        ++currZ;
                        continue;
                    }
                    --currZ;
                }
                if (regionIsIntersecting) continue block0;
            }
        }
        return intersectingRegions;
    }

    @Override
    public String getTypeName() {
        return "polygon";
    }

    @Override
    public int volume() {
        int xa;
        int volume = 0;
        int numPoints = this.points.size();
        if (numPoints < 3) {
            return 0;
        }
        double area = 0.0;
        for (int i = 0; i <= numPoints - 1; ++i) {
            xa = this.points.get(i).getBlockX();
            int z1 = this.points.get(i + 1) == null ? this.points.get(0).getBlockZ() : this.points.get(i + 1).getBlockZ();
            int z2 = this.points.get(i - 1) == null ? this.points.get(numPoints - 1).getBlockZ() : this.points.get(i - 1).getBlockZ();
            area += (double)(xa * (z1 - z2));
        }
        xa = this.points.get(0).getBlockX();
        volume = (Math.abs(this.maxY - this.minY) + 1) * (int)Math.ceil(Math.abs(area += (double)(xa * (this.points.get(1).getBlockZ() - this.points.get(numPoints - 1).getBlockZ()))) / 2.0);
        return volume;
    }
}

