/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.worldguard.util;

import com.sk89q.worldguard.domains.DefaultDomain;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class RegionUtil {
    private static Pattern groupPattern = Pattern.compile("^[gG]:(.+)$");

    private RegionUtil() {
    }

    public static void addToDomain(DefaultDomain domain, String[] split, int startIndex) {
        for (int i = startIndex; i < split.length; ++i) {
            String s = split[i];
            Matcher m = groupPattern.matcher(s);
            if (m.matches()) {
                domain.addGroup(m.group(1));
                continue;
            }
            domain.addPlayer(s);
        }
    }

    public static void removeFromDomain(DefaultDomain domain, String[] split, int startIndex) {
        for (int i = startIndex; i < split.length; ++i) {
            String s = split[i];
            Matcher m = groupPattern.matcher(s);
            if (m.matches()) {
                domain.removeGroup(m.group(1));
                continue;
            }
            domain.removePlayer(s);
        }
    }

    public static DefaultDomain parseDomainString(String[] split, int startIndex) {
        DefaultDomain domain = new DefaultDomain();
        for (int i = startIndex; i < split.length; ++i) {
            String s = split[i];
            Matcher m = groupPattern.matcher(s);
            if (m.matches()) {
                domain.addGroup(m.group(1));
                continue;
            }
            domain.addPlayer(s);
        }
        return domain;
    }
}

