/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.minecraft.util.commands;

import java.util.HashSet;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CommandContext {
    protected String[] args;
    protected Set<Character> flags = new HashSet<Character>();

    public CommandContext(String args) {
        this(args.split(" "));
    }

    public CommandContext(String[] args) {
        int i;
        for (i = 1; i < args.length; ++i) {
            if (args[i].length() == 0) continue;
            if (args[i].charAt(0) != '-' || !args[i].matches("^-[a-zA-Z]+$")) break;
            for (int k = 1; k < args[i].length(); ++k) {
                this.flags.add(Character.valueOf(args[i].charAt(k)));
            }
        }
        String[] newArgs = new String[args.length - i + 1];
        System.arraycopy(args, i, newArgs, 1, args.length - i);
        newArgs[0] = args[0];
        this.args = newArgs;
    }

    public String getCommand() {
        return this.args[0];
    }

    public boolean matches(String command) {
        return this.args[0].equalsIgnoreCase(command);
    }

    public String getString(int index) {
        return this.args[index + 1];
    }

    public String getString(int index, String def) {
        return index + 1 < this.args.length ? this.args[index + 1] : def;
    }

    public String getJoinedStrings(int initialIndex) {
        StringBuilder buffer = new StringBuilder(this.args[++initialIndex]);
        for (int i = initialIndex + 1; i < this.args.length; ++i) {
            buffer.append(" ").append(this.args[i]);
        }
        return buffer.toString();
    }

    public int getInteger(int index) throws NumberFormatException {
        return Integer.parseInt(this.args[index + 1]);
    }

    public int getInteger(int index, int def) throws NumberFormatException {
        return index + 1 < this.args.length ? Integer.parseInt(this.args[index + 1]) : def;
    }

    public double getDouble(int index) throws NumberFormatException {
        return Double.parseDouble(this.args[index + 1]);
    }

    public double getDouble(int index, double def) throws NumberFormatException {
        return index + 1 < this.args.length ? Double.parseDouble(this.args[index + 1]) : def;
    }

    public String[] getSlice(int index) {
        String[] slice = new String[this.args.length - index];
        System.arraycopy(this.args, index, slice, 0, this.args.length - index);
        return slice;
    }

    public String[] getPaddedSlice(int index, int padding) {
        String[] slice = new String[this.args.length - index + padding];
        System.arraycopy(this.args, index, slice, padding, this.args.length - index);
        return slice;
    }

    public boolean hasFlag(char ch) {
        return this.flags.contains(Character.valueOf(ch));
    }

    public Set<Character> getFlags() {
        return this.flags;
    }

    public int length() {
        return this.args.length;
    }

    public int argsLength() {
        return this.args.length - 1;
    }
}

