/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.worldedit.bags;

import com.sk89q.worldedit.Vector;
import com.sk89q.worldedit.bags.BlockBagException;
import com.sk89q.worldedit.bags.OutOfBlocksException;
import com.sk89q.worldedit.bags.UnplaceableBlockException;
import com.sk89q.worldedit.blocks.BlockType;

public abstract class BlockBag {
    public void storeDroppedBlock(int id) throws BlockBagException {
        int dropped = BlockType.getDroppedBlock(id);
        if (dropped > 0) {
            this.storeBlock(dropped);
        }
    }

    public void fetchPlacedBlock(int id) throws BlockBagException {
        try {
            if (id == 7 || id == 14 || id == 15 || id == 16 || id == 56 || id == 18 || id == 46 || id == 52 || id == 59 || id == 73 || id == 74 || id == 78 || id == 89 || id == 90) {
                throw new UnplaceableBlockException();
            }
            if (id == 8 || id == 9 || id == 10 || id == 11) {
                return;
            }
            this.fetchBlock(id);
        }
        catch (OutOfBlocksException e) {
            if (id == 1) {
                this.fetchBlock(4);
            }
            if (id == 2) {
                this.fetchBlock(3);
            }
            if (id == 55) {
                this.fetchBlock(331);
            }
            if (id == 62) {
                this.fetchBlock(61);
            }
            if (id == 75) {
                this.fetchBlock(76);
            }
            if (id == 68 || id == 63) {
                this.fetchBlock(323);
            }
            throw e;
        }
    }

    public abstract void fetchBlock(int var1) throws BlockBagException;

    public abstract void storeBlock(int var1) throws BlockBagException;

    public boolean peekBlock(int id) {
        try {
            this.fetchBlock(id);
            this.storeBlock(id);
            return true;
        }
        catch (BlockBagException e) {
            return false;
        }
    }

    public abstract void flushChanges();

    public abstract void addSourcePosition(Vector var1);

    public abstract void addSingleSourcePosition(Vector var1);
}

