/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.worldedit.blocks;

import com.sk89q.jnbt.ShortTag;
import com.sk89q.jnbt.StringTag;
import com.sk89q.jnbt.Tag;
import com.sk89q.worldedit.blocks.BaseBlock;
import com.sk89q.worldedit.blocks.TileEntityBlock;
import com.sk89q.worldedit.data.Chunk;
import com.sk89q.worldedit.data.DataException;
import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MobSpawnerBlock
extends BaseBlock
implements TileEntityBlock {
    private String mobType;
    private short delay;

    public MobSpawnerBlock() {
        super(52);
        this.mobType = "Pig";
    }

    public MobSpawnerBlock(String mobType) {
        super(52);
        this.mobType = mobType;
    }

    public MobSpawnerBlock(int data) {
        super(52, data);
    }

    public MobSpawnerBlock(int data, String mobType) {
        super(52, data);
        this.mobType = mobType;
    }

    public String getMobType() {
        return this.mobType;
    }

    public void setMobType(String mobType) {
        this.mobType = mobType;
    }

    public short getDelay() {
        return this.delay;
    }

    public void setDelay(short delay) {
        this.delay = delay;
    }

    @Override
    public String getTileEntityID() {
        return "MobSpawner";
    }

    @Override
    public Map<String, Tag> toTileEntityNBT() throws DataException {
        HashMap<String, Tag> values = new HashMap<String, Tag>();
        values.put("EntityId", new StringTag("EntityId", this.mobType));
        values.put("Delay", new ShortTag("Delay", this.delay));
        return values;
    }

    @Override
    public void fromTileEntityNBT(Map<String, Tag> values) throws DataException {
        if (values == null) {
            return;
        }
        Tag t = values.get("id");
        if (!(t instanceof StringTag) || !((StringTag)t).getValue().equals("MobSpawner")) {
            throw new DataException("'MobSpawner' tile entity expected");
        }
        StringTag mobTypeTag = (StringTag)Chunk.getChildTag(values, "EntityId", StringTag.class);
        ShortTag delayTag = (ShortTag)Chunk.getChildTag(values, "Delay", ShortTag.class);
        this.mobType = mobTypeTag.getValue();
        this.delay = delayTag.getValue();
    }
}

