/*
 * Decompiled with CFR 0.152.
 */
package cc.co.evenprime.bukkit.nocheat.checks.moving;

import cc.co.evenprime.bukkit.nocheat.NoCheat;
import cc.co.evenprime.bukkit.nocheat.checks.moving.FlyingCheck;
import cc.co.evenprime.bukkit.nocheat.checks.moving.MorePacketsCheck;
import cc.co.evenprime.bukkit.nocheat.checks.moving.MovingEventHelper;
import cc.co.evenprime.bukkit.nocheat.checks.moving.NoclipCheck;
import cc.co.evenprime.bukkit.nocheat.checks.moving.RunningCheck;
import cc.co.evenprime.bukkit.nocheat.config.cache.ConfigurationCache;
import cc.co.evenprime.bukkit.nocheat.data.MovingData;
import org.bukkit.Location;
import org.bukkit.block.Block;
import org.bukkit.entity.Player;

public class MovingCheck {
    private final FlyingCheck flyingCheck;
    private final RunningCheck runningCheck;
    private final NoclipCheck noclippingCheck;
    private final MorePacketsCheck morePacketsCheck;
    private final MovingEventHelper helper = new MovingEventHelper();

    public MovingCheck(NoCheat plugin) {
        this.flyingCheck = new FlyingCheck(plugin);
        this.runningCheck = new RunningCheck(plugin);
        this.noclippingCheck = new NoclipCheck(plugin);
        this.morePacketsCheck = new MorePacketsCheck(plugin);
    }

    public Location check(Player player, Location from, Location to, MovingData data, ConfigurationCache cc) {
        boolean noclipCheck;
        if (player.isInsideVehicle()) {
            return null;
        }
        Location newToLocation = null;
        if (data.horizVelocityCounter > 0) {
            --data.horizVelocityCounter;
        } else {
            data.horizFreedom *= 0.9;
        }
        if (data.vertVelocityCounter > 0) {
            --data.vertVelocityCounter;
            data.vertFreedom += data.vertVelocity;
            data.vertVelocity *= 0.9;
        } else {
            data.vertFreedom = 0.0;
        }
        boolean flyCheck = cc.moving.flyingCheck && !player.hasPermission("nocheat.checks.moving.flying");
        boolean runCheck = cc.moving.runningCheck && !player.hasPermission("nocheat.checks.moving.running");
        boolean morepacketsCheck = cc.moving.morePacketsCheck && !player.hasPermission("nocheat.checks.moving.morepackets");
        boolean bl = noclipCheck = cc.moving.noclipCheck && !player.hasPermission("nocheat.checks.moving.noclip");
        if (flyCheck && runCheck) {
            newToLocation = this.runningCheck.check(player, from, to, this.helper, cc, data);
        } else if (flyCheck) {
            newToLocation = this.flyingCheck.check(player, from, to, cc, data);
        }
        if (newToLocation == null && morepacketsCheck) {
            newToLocation = this.morePacketsCheck.check(player, cc, data);
        }
        if (newToLocation == null && noclipCheck) {
            newToLocation = this.noclippingCheck.check(player, from, to, this.helper, cc, data);
        }
        return newToLocation;
    }

    public void blockPlaced(Player player, MovingData data, Block blockPlaced) {
        int type;
        if (blockPlaced == null || data.movingsetBackPoint == null) {
            return;
        }
        Location lblock = blockPlaced.getLocation();
        Location lplayer = player.getLocation();
        if (Math.abs(lplayer.getBlockX() - lblock.getBlockX()) <= 1 && Math.abs(lplayer.getBlockZ() - lblock.getBlockZ()) <= 1 && lplayer.getBlockY() - lblock.getBlockY() >= 0 && lplayer.getBlockY() - lblock.getBlockY() <= 2 && (this.helper.isSolid(type = this.helper.types[blockPlaced.getTypeId()]) || this.helper.isLiquid(type)) && (double)(lblock.getBlockY() + 1) >= data.movingsetBackPoint.getY()) {
            data.movingsetBackPoint.setY((double)(lblock.getBlockY() + 1));
            data.jumpPhase = 0;
        }
    }
}

