/*
 * Decompiled with CFR 0.152.
 */
package cc.co.evenprime.bukkit.nocheat.config;

import cc.co.evenprime.bukkit.nocheat.DefaultConfiguration;
import cc.co.evenprime.bukkit.nocheat.actions.ActionManager;
import cc.co.evenprime.bukkit.nocheat.config.Configuration;
import cc.co.evenprime.bukkit.nocheat.config.cache.ConfigurationCache;
import cc.co.evenprime.bukkit.nocheat.config.tree.ActionListOption;
import cc.co.evenprime.bukkit.nocheat.config.tree.ChildOption;
import cc.co.evenprime.bukkit.nocheat.config.tree.ConfigurationTree;
import cc.co.evenprime.bukkit.nocheat.config.tree.Option;
import cc.co.evenprime.bukkit.nocheat.config.tree.ParentOption;
import cc.co.evenprime.bukkit.nocheat.file.DescriptionGenerator;
import cc.co.evenprime.bukkit.nocheat.file.FlatActionParser;
import cc.co.evenprime.bukkit.nocheat.file.FlatConfigGenerator;
import cc.co.evenprime.bukkit.nocheat.file.FlatConfigParser;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.text.SimpleDateFormat;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.FileHandler;
import java.util.logging.Formatter;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;

public class ConfigurationManager {
    private static final String configFileName = "config.txt";
    private static final String actionFileName = "actions.txt";
    private static final String defaultActionFileName = "default_actions.txt";
    private static final String descriptionsFileName = "descriptions.txt";
    private final Map<String, ConfigurationCache> worldnameToConfigCacheMap = new HashMap<String, ConfigurationCache>();
    private final Map<File, FileHandler> fileToFileHandlerMap = new HashMap<File, FileHandler>();
    private final ConfigurationTree defaultTree = DefaultConfiguration.buildDefaultConfigurationTree();

    public ConfigurationManager(String rootConfigFolder, ActionManager action) {
        this.initializeActions(rootConfigFolder, action);
        this.initializeConfig(rootConfigFolder, action);
    }

    private void initializeActions(String rootConfigFolder, ActionManager action) {
        FlatActionParser parser = new FlatActionParser();
        DefaultConfiguration.writeDefaultActionFile(new File(rootConfigFolder, defaultActionFileName));
        parser.read(action, new File(rootConfigFolder, defaultActionFileName));
        parser.read(action, new File(rootConfigFolder, actionFileName));
    }

    private void initializeConfig(String rootConfigFolder, ActionManager actionManager) {
        ConfigurationTree root;
        File globalConfigFile = ConfigurationManager.getGlobalConfigFile(rootConfigFolder);
        try {
            root = ConfigurationManager.createFullConfigurationTree(this.defaultTree, globalConfigFile);
        }
        catch (Exception e) {
            root = DefaultConfiguration.buildDefaultConfigurationTree();
        }
        ConfigurationManager.writeConfigFile(globalConfigFile, root);
        this.worldnameToConfigCacheMap.put(null, new ConfigurationCache(root, this.setupFileLogger(new File(rootConfigFolder, root.getString("logging.filename")))));
        Map<String, File> worldFiles = ConfigurationManager.getWorldSpecificConfigFiles(rootConfigFolder);
        for (String worldName : worldFiles.keySet()) {
            File worldConfigFile = worldFiles.get(worldName);
            try {
                ConfigurationTree world = ConfigurationManager.createPartialConfigurationTree(root, worldConfigFile);
                this.worldnameToConfigCacheMap.put(worldName, this.createConfigurationCache(rootConfigFolder, world));
                ConfigurationManager.writeConfigFile(worldFiles.get(worldName), world);
            }
            catch (IOException e) {
                System.out.println("NoCheat: Couldn't load world-specific config for " + worldName);
            }
        }
        ConfigurationManager.writeDescriptionFile(new File(rootConfigFolder, descriptionsFileName), this.defaultTree);
    }

    private ConfigurationCache createConfigurationCache(String rootConfigFolder, Configuration configProvider) {
        return new ConfigurationCache(configProvider, this.setupFileLogger(new File(rootConfigFolder, configProvider.getString("logging.filename"))));
    }

    public static File getGlobalConfigFile(String rootFolder) {
        File globalConfig = new File(rootFolder, configFileName);
        return globalConfig;
    }

    public static Map<String, File> getWorldSpecificConfigFiles(String rootConfigFolder) {
        HashMap<String, File> files = new HashMap<String, File>();
        File rootFolder = new File(rootConfigFolder);
        if (rootFolder.isDirectory()) {
            File[] fileArray = rootFolder.listFiles();
            int n = fileArray.length;
            int n2 = 0;
            while (n2 < n) {
                String filename;
                File f = fileArray[n2];
                if (f.isFile() && (filename = f.getName()).matches(".+_config.txt$")) {
                    String worldname = filename.substring(0, filename.length() - (configFileName.length() + 1));
                    files.put(worldname, f);
                }
                ++n2;
            }
        }
        return files;
    }

    public static ConfigurationTree createFullConfigurationTree(ConfigurationTree defaultTree, File configurationFile) throws IOException {
        return ConfigurationManager.yamlToTree(defaultTree, configurationFile, true);
    }

    public static ConfigurationTree createPartialConfigurationTree(ConfigurationTree defaultTree, File configurationFile) throws IOException {
        ConfigurationTree tree = ConfigurationManager.yamlToTree(defaultTree, configurationFile, false);
        tree.setParent(defaultTree);
        return tree;
    }

    private static ConfigurationTree yamlToTree(ConfigurationTree defaults, File configurationFile, boolean fullCopy) throws IOException {
        FlatConfigParser source = new FlatConfigParser();
        source.read(configurationFile);
        ConfigurationTree partial = new ConfigurationTree();
        for (Option o : defaults.getAllOptions()) {
            Option o2;
            if (o instanceof ActionListOption) {
                o2 = ((ActionListOption)o).clone();
                partial.add(o.getParent().getFullIdentifier(), o2);
                Object prop = source.getProperty(o2.getFullIdentifier());
                if (prop instanceof Map && prop != null) {
                    Map m = (Map)prop;
                    ((ActionListOption)o2).clear();
                    for (Map.Entry entry : m.entrySet()) {
                        try {
                            ((ActionListOption)o2).add(Integer.parseInt((String)entry.getKey()), (String)entry.getValue());
                        }
                        catch (Exception e) {
                            System.out.println("NoCheat: PROBLEM OFFICER?!?!");
                        }
                    }
                }
                if (fullCopy || prop != null) continue;
                o2.setActive(false);
                continue;
            }
            if (o instanceof ParentOption) {
                o2 = new ParentOption(o.getIdentifier());
                partial.add(o.getParent().getFullIdentifier(), o2);
                continue;
            }
            if (!(o instanceof ChildOption)) continue;
            o2 = ((ChildOption)o).clone();
            partial.add(o.getParent().getFullIdentifier(), o2);
            ((ChildOption)o2).setStringValue(source.getString(o2.getFullIdentifier(), ((ChildOption)o2).getStringValue()));
            if (fullCopy || source.getProperty(o.getFullIdentifier()) != null) continue;
            o2.setActive(false);
        }
        return partial;
    }

    private Logger setupFileLogger(File logfile) {
        FileHandler fh = this.fileToFileHandlerMap.get(logfile);
        if (fh == null) {
            try {
                try {
                    logfile.getParentFile().mkdirs();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                fh = new FileHandler(logfile.getCanonicalPath(), true);
                fh.setLevel(Level.ALL);
                fh.setFormatter(new LogFileFormatter());
                this.fileToFileHandlerMap.put(logfile, fh);
            }
            catch (SecurityException e) {
                e.printStackTrace();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        Logger l = Logger.getAnonymousLogger();
        l.setLevel(Level.INFO);
        l.setUseParentHandlers(false);
        l.addHandler(fh);
        return l;
    }

    public void cleanup() {
        for (ConfigurationCache c : this.worldnameToConfigCacheMap.values()) {
            Handler[] handlerArray = c.logging.filelogger.getHandlers();
            int n = handlerArray.length;
            int n2 = 0;
            while (n2 < n) {
                Handler h = handlerArray[n2];
                c.logging.filelogger.removeHandler(h);
                ++n2;
            }
        }
        for (FileHandler fh : this.fileToFileHandlerMap.values()) {
            fh.flush();
            fh.close();
        }
    }

    public static void writeConfigFile(File f, ConfigurationTree configuration) {
        try {
            if (f.getParentFile() != null) {
                f.getParentFile().mkdirs();
            }
            f.createNewFile();
            BufferedWriter w = new BufferedWriter(new FileWriter(f));
            w.write(FlatConfigGenerator.treeToFlatFile(configuration));
            w.flush();
            w.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void writeDescriptionFile(File f, ConfigurationTree configuration) {
        try {
            if (f.getParentFile() != null) {
                f.getParentFile().mkdirs();
            }
            f.createNewFile();
            BufferedWriter w = new BufferedWriter(new FileWriter(f));
            w.write(DescriptionGenerator.treeToDescription(configuration));
            w.flush();
            w.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public ConfigurationCache getConfigurationCacheForWorld(String worldname) {
        ConfigurationCache cache = this.worldnameToConfigCacheMap.get(worldname);
        if (cache != null) {
            return cache;
        }
        cache = this.worldnameToConfigCacheMap.get(null);
        this.worldnameToConfigCacheMap.put(worldname, cache);
        return cache;
    }

    public static File getDescriptionFile(String rootConfigFolder) {
        return new File(rootConfigFolder, descriptionsFileName);
    }

    public static File getDefaultActionFile(String rootConfigFolder) {
        return new File(rootConfigFolder, defaultActionFileName);
    }

    public static File getActionFile(String rootConfigFolder) {
        return new File(rootConfigFolder, actionFileName);
    }

    private class LogFileFormatter
    extends Formatter {
        private final SimpleDateFormat date = new SimpleDateFormat("yy.MM.dd HH:mm:ss");

        @Override
        public String format(LogRecord record) {
            StringBuilder builder = new StringBuilder();
            Throwable ex = record.getThrown();
            builder.append(this.date.format(record.getMillis()));
            builder.append(" [");
            builder.append(record.getLevel().getLocalizedName().toUpperCase());
            builder.append("] ");
            builder.append(record.getMessage());
            builder.append('\n');
            if (ex != null) {
                StringWriter writer = new StringWriter();
                ex.printStackTrace(new PrintWriter(writer));
                builder.append(writer);
            }
            return builder.toString();
        }
    }
}

