/*
 * Decompiled with CFR 0.152.
 */
package cc.co.evenprime.bukkit.nocheat.config.tree;

import cc.co.evenprime.bukkit.nocheat.config.tree.ChildOption;

public class BooleanOption
extends ChildOption {
    private static final long serialVersionUID = 2258827414736580449L;
    private boolean value;
    private boolean isMaster = false;

    public BooleanOption(String name, boolean initialValue, boolean isMaster) {
        super(name);
        this.value = initialValue;
        this.isMaster = isMaster;
    }

    public void setBooleanValue(boolean value) {
        this.value = value;
    }

    @Override
    public String getStringValue() {
        return Boolean.toString(this.value);
    }

    @Override
    public boolean setStringValue(String value) {
        try {
            this.value = Boolean.parseBoolean(value);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public boolean getBooleanValue() {
        return this.value;
    }

    @Override
    public BooleanOption clone() {
        return new BooleanOption(this.getIdentifier(), this.value, this.isMaster);
    }

    public boolean isMaster() {
        return this.isMaster;
    }

    public void setMaster(boolean master) {
        this.isMaster = master;
    }

    public String toString() {
        return "BooleanOption " + this.getFullIdentifier() + " " + this.getStringValue() + (this.isMaster ? " master" : "");
    }
}

