/*
 * Decompiled with CFR 0.152.
 */
package cc.co.evenprime.bukkit.nocheat.events;

import cc.co.evenprime.bukkit.nocheat.NoCheat;
import cc.co.evenprime.bukkit.nocheat.checks.blockplace.BlockPlaceCheck;
import cc.co.evenprime.bukkit.nocheat.checks.moving.MovingCheck;
import cc.co.evenprime.bukkit.nocheat.config.ConfigurationManager;
import cc.co.evenprime.bukkit.nocheat.config.cache.ConfigurationCache;
import cc.co.evenprime.bukkit.nocheat.data.DataManager;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.Listener;
import org.bukkit.event.block.BlockListener;
import org.bukkit.event.block.BlockPlaceEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.PluginManager;

public class BlockPlaceEventManager
extends BlockListener {
    private final MovingCheck movingCheck;
    private final BlockPlaceCheck blockPlaceCheck;
    private final DataManager data;
    private final ConfigurationManager config;

    public BlockPlaceEventManager(NoCheat plugin) {
        this.data = plugin.getDataManager();
        this.config = plugin.getConfigurationManager();
        this.movingCheck = new MovingCheck(plugin);
        this.blockPlaceCheck = new BlockPlaceCheck(plugin);
        PluginManager pm = Bukkit.getServer().getPluginManager();
        pm.registerEvent(Event.Type.BLOCK_PLACE, (Listener)this, Event.Priority.Lowest, (Plugin)plugin);
        pm.registerEvent(Event.Type.BLOCK_PLACE, (Listener)new BlockListener(){

            public void onBlockPlace(BlockPlaceEvent event) {
                if (!event.isCancelled()) {
                    Player player = event.getPlayer();
                    BlockPlaceEventManager.this.movingCheck.blockPlaced(player, BlockPlaceEventManager.this.data.getMovingData(player), event.getBlockPlaced());
                }
            }
        }, Event.Priority.Monitor, (Plugin)plugin);
    }

    public void onBlockPlace(BlockPlaceEvent event) {
        if (!event.isCancelled()) {
            boolean cancel = false;
            Player player = event.getPlayer();
            ConfigurationCache cc = this.config.getConfigurationCacheForWorld(player.getWorld().getName());
            if (cc.blockplace.check && !player.hasPermission("nocheat.checks.blockplace.*")) {
                cancel = this.blockPlaceCheck.check(player, event.getBlockPlaced(), event.getBlockAgainst(), this.data.getBlockPlaceData(player), cc);
            }
            if (cancel) {
                event.setCancelled(true);
            }
        }
    }
}

