/*
 * Decompiled with CFR 0.152.
 */
package cc.co.evenprime.bukkit.nocheat.events;

import cc.co.evenprime.bukkit.nocheat.NoCheat;
import cc.co.evenprime.bukkit.nocheat.checks.interact.InteractCheck;
import cc.co.evenprime.bukkit.nocheat.config.ConfigurationManager;
import cc.co.evenprime.bukkit.nocheat.config.cache.ConfigurationCache;
import cc.co.evenprime.bukkit.nocheat.data.DataManager;
import cc.co.evenprime.bukkit.nocheat.data.InteractData;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.event.player.PlayerListener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.PluginManager;

public class PlayerInteractEventManager
extends PlayerListener {
    private final InteractCheck interactCheck;
    private final DataManager data;
    private final ConfigurationManager config;

    public PlayerInteractEventManager(NoCheat plugin) {
        this.data = plugin.getDataManager();
        this.config = plugin.getConfigurationManager();
        this.interactCheck = new InteractCheck(plugin);
        PluginManager pm = Bukkit.getServer().getPluginManager();
        pm.registerEvent(Event.Type.PLAYER_INTERACT, (Listener)this, Event.Priority.Lowest, (Plugin)plugin);
    }

    public void onPlayerInteract(PlayerInteractEvent event) {
        if (event.isCancelled()) {
            return;
        }
        Player player = event.getPlayer();
        ConfigurationCache cc = this.config.getConfigurationCacheForWorld(player.getWorld().getName());
        if (cc.interact.check && !player.hasPermission("nocheat.checks.interact.*")) {
            boolean cancel = false;
            InteractData data = this.data.getInteractData(player);
            cancel = this.interactCheck.check(player, data, cc);
            if (cancel) {
                event.setCancelled(true);
            }
        }
    }
}

