/*
 * Decompiled with CFR 0.152.
 */
package cc.co.evenprime.bukkit.nocheat.wizard.gui;

import cc.co.evenprime.bukkit.nocheat.config.tree.ActionListOption;
import cc.co.evenprime.bukkit.nocheat.config.tree.ActionOption;
import cc.co.evenprime.bukkit.nocheat.wizard.Wizard;
import cc.co.evenprime.bukkit.nocheat.wizard.gui.ActionOptionGui;
import cc.co.evenprime.bukkit.nocheat.wizard.gui.ChildOptionGui;
import cc.co.evenprime.bukkit.nocheat.wizard.gui.ChildOptionGuiFactory;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JOptionPane;

public class ActionListOptionGui
extends ChildOptionGui {
    private static final long serialVersionUID = 527734534503546802L;
    private final ActionListOption option;
    private final ActionListOption defaults;

    public ActionListOptionGui(ActionListOption option, ActionListOption defaults) {
        super(option.isActive());
        this.option = option;
        this.defaults = defaults;
        this.setLayout(new GridBagLayout());
        this.recreateContent();
    }

    private void recreateContent() {
        this.removeAll();
        int line = 0;
        if (this.isActive()) {
            GridBagConstraints c = new GridBagConstraints();
            c.gridx = 1;
            c.gridy = line;
            c.anchor = 17;
            c.ipadx = 10;
            c.weightx = 0.0;
            this.add(this.createAddButton(), c);
            for (ActionOption o : this.option.getChildOptions()) {
                this.add(o, ++line);
            }
        } else {
            for (ActionOption o : this.defaults.getChildOptions()) {
                this.add(o, ++line);
            }
        }
        this.revalidate();
    }

    private Component createAddButton() {
        JButton b = new JButton("new Line");
        b.setToolTipText("Adds a new line to this action list.");
        b.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                String result = JOptionPane.showInputDialog("Please enter a new threshold: ");
                try {
                    int treshold = Integer.parseInt(result);
                    if (treshold >= 0) {
                        for (ActionOption ao : ActionListOptionGui.this.option.getChildOptions()) {
                            if (ao.getTreshold() != treshold) continue;
                            return;
                        }
                    }
                    ActionListOptionGui.this.option.add(treshold, "");
                    ActionListOptionGui.this.recreateContent();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        });
        return b;
    }

    private Component createDeleteButton(final ActionOption o) {
        JButton b = new JButton("remove");
        b.setToolTipText("Removes this line from the action list.");
        b.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                ActionListOptionGui.this.option.remove(o);
                ActionListOptionGui.this.recreateContent();
            }
        });
        return b;
    }

    private void add(ActionOption child, int line) {
        GridBagConstraints c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = line;
        c.gridwidth = 1;
        c.anchor = 13;
        c.ipadx = 10;
        c.weightx = 0.0;
        JLabel l = new JLabel(String.valueOf(child.getIdentifier()) + " : ");
        if (!this.option.isActive()) {
            l.setForeground(Wizard.disabled);
        } else {
            l.setForeground(Wizard.enabled);
        }
        this.add((Component)l, c);
        ++c.gridx;
        c.gridy = line;
        c.gridwidth = 1;
        c.anchor = 17;
        c.ipadx = 5;
        c.weightx = 0.0;
        c.fill = 2;
        ActionOptionGui tmp = ChildOptionGuiFactory.create(child);
        this.add((Component)tmp, c);
        if (!this.option.isActive()) {
            ((JComponent)tmp).setEnabled(false);
        } else {
            ++c.gridx;
            c.gridy = line;
            c.gridwidth = 1;
            c.anchor = 17;
            c.ipadx = 1;
            c.weightx = 0.0;
            this.add(this.createDeleteButton(child), c);
        }
        ++c.gridx;
        c.gridy = line;
        c.gridwidth = 1;
        c.anchor = 17;
        c.ipadx = 5;
        c.weightx = 1.0;
        this.add(Box.createHorizontalGlue(), c);
    }

    @Override
    public void setActive(boolean active) {
        super.setActive(active);
        this.option.setActive(active);
        this.option.getChildOptions().clear();
        for (ActionOption ao : this.defaults.getChildOptions()) {
            this.option.getChildOptions().add(ao.clone());
        }
    }
}

