/*
 * Decompiled with CFR 0.152.
 */
package com.earth2me.essentials;

import com.earth2me.essentials.Backup;
import com.earth2me.essentials.Console;
import com.earth2me.essentials.EssentialsBlockListener;
import com.earth2me.essentials.EssentialsEcoBlockListener;
import com.earth2me.essentials.EssentialsEcoPlayerListener;
import com.earth2me.essentials.EssentialsEntityListener;
import com.earth2me.essentials.EssentialsPlayerListener;
import com.earth2me.essentials.EssentialsTimer;
import com.earth2me.essentials.EssentialsUpgrade;
import com.earth2me.essentials.IConf;
import com.earth2me.essentials.ItemDb;
import com.earth2me.essentials.Jail;
import com.earth2me.essentials.JailPlayerListener;
import com.earth2me.essentials.OfflinePlayer;
import com.earth2me.essentials.Settings;
import com.earth2me.essentials.Spawn;
import com.earth2me.essentials.User;
import com.earth2me.essentials.Util;
import com.earth2me.essentials.Warps;
import com.earth2me.essentials.Worth;
import com.earth2me.essentials.commands.EssentialsCommand;
import com.earth2me.essentials.commands.IEssentialsCommand;
import com.earth2me.essentials.commands.NotEnoughArgumentsException;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.bukkit.ChatColor;
import org.bukkit.World;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.command.PluginCommand;
import org.bukkit.craftbukkit.entity.CraftPlayer;
import org.bukkit.craftbukkit.scheduler.CraftScheduler;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.Listener;
import org.bukkit.plugin.InvalidDescriptionException;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.PluginDescriptionFile;
import org.bukkit.plugin.PluginManager;
import org.bukkit.plugin.java.JavaPlugin;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Essentials
extends JavaPlugin {
    public static final String AUTHORS = "Zenexer, ementalo, Aelux, Brettflan, KimKandor, snowleo, ceulemans and Xeology";
    public static final int minBukkitBuildVersion = 766;
    private static final Logger logger = Logger.getLogger("Minecraft");
    private Settings settings;
    private EssentialsPlayerListener playerListener;
    private EssentialsBlockListener blockListener;
    private EssentialsEntityListener entityListener;
    private JailPlayerListener jailPlayerListener;
    private static Essentials instance = null;
    private Spawn spawn;
    private Jail jail;
    private Warps warps;
    private Worth worth;
    private List<IConf> confList;
    public ArrayList bans = new ArrayList();
    public ArrayList bannedIps = new ArrayList();
    private Backup backup;
    private Map<String, User> users = new HashMap<String, User>();
    private EssentialsTimer timer;
    private boolean iConomyFallback = true;
    private boolean newWorldsLoaded = false;

    public static Essentials getStatic() {
        return instance;
    }

    public Settings getSettings() {
        return this.settings;
    }

    public void setupForTesting() throws IOException, InvalidDescriptionException {
        File dataFolder = File.createTempFile("essentialstest", "");
        dataFolder.delete();
        dataFolder.mkdir();
        logger.log(Level.INFO, Util.i18n("usingTempFolderForTesting"));
        logger.log(Level.INFO, dataFolder.toString());
        this.initialize(null, null, new PluginDescriptionFile((Reader)new FileReader(new File("src" + File.separator + "plugin.yml"))), dataFolder, null, null);
        this.settings = new Settings(dataFolder);
    }

    public void setStatic() {
        instance = this;
    }

    public void onEnable() {
        this.setStatic();
        EssentialsUpgrade upgrade = new EssentialsUpgrade(this.getDescription().getVersion(), this);
        if (this.newWorldsLoaded) {
            logger.log(Level.SEVERE, Util.i18n("worldsLoadedRestartServer"));
            try {
                this.getServer().dispatchCommand(Console.getCommandSender(this.getServer()), "stop");
            }
            catch (Exception ex) {
                logger.log(Level.SEVERE, Util.i18n("failedStopServer"), ex);
            }
        }
        this.confList = new ArrayList<IConf>();
        this.settings = new Settings(this.getDataFolder());
        this.confList.add(this.settings);
        Util.updateLocale(this.settings.getLocale(), this.getDataFolder());
        this.spawn = new Spawn(this.getServer(), this.getDataFolder());
        this.confList.add(this.spawn);
        this.warps = new Warps(this.getServer(), this.getDataFolder());
        this.confList.add(this.warps);
        this.worth = new Worth(this.getDataFolder());
        this.confList.add(this.worth);
        this.reload();
        this.backup = new Backup();
        PluginManager pm = this.getServer().getPluginManager();
        for (Plugin plugin : pm.getPlugins()) {
            if (!plugin.getDescription().getName().startsWith("Essentials") || plugin.getDescription().getVersion().equals(this.getDescription().getVersion())) continue;
            logger.log(Level.WARNING, Util.format("versionMismatch", plugin.getDescription().getName()));
        }
        Matcher versionMatch = Pattern.compile("git-Bukkit-([0-9]+).([0-9]+).([0-9]+)-[0-9]+-[0-9a-z]+-b([0-9]+)jnks.*").matcher(this.getServer().getVersion());
        if (versionMatch.matches()) {
            int versionNumber = Integer.parseInt(versionMatch.group(4));
            if (versionNumber < 766) {
                logger.log(Level.WARNING, Util.i18n("notRecommendedBukkit"));
            }
        } else {
            logger.log(Level.INFO, Util.i18n("bukkitFormatChanged"));
        }
        this.playerListener = new EssentialsPlayerListener(this);
        pm.registerEvent(Event.Type.PLAYER_JOIN, (Listener)this.playerListener, Event.Priority.Monitor, (Plugin)this);
        pm.registerEvent(Event.Type.PLAYER_QUIT, (Listener)this.playerListener, Event.Priority.Monitor, (Plugin)this);
        pm.registerEvent(Event.Type.PLAYER_CHAT, (Listener)this.playerListener, Event.Priority.Lowest, (Plugin)this);
        if (this.getSettings().getNetherPortalsEnabled()) {
            pm.registerEvent(Event.Type.PLAYER_MOVE, (Listener)this.playerListener, Event.Priority.High, (Plugin)this);
        }
        pm.registerEvent(Event.Type.PLAYER_LOGIN, (Listener)this.playerListener, Event.Priority.High, (Plugin)this);
        pm.registerEvent(Event.Type.PLAYER_TELEPORT, (Listener)this.playerListener, Event.Priority.High, (Plugin)this);
        pm.registerEvent(Event.Type.PLAYER_INTERACT, (Listener)this.playerListener, Event.Priority.High, (Plugin)this);
        pm.registerEvent(Event.Type.PLAYER_EGG_THROW, (Listener)this.playerListener, Event.Priority.High, (Plugin)this);
        pm.registerEvent(Event.Type.PLAYER_BUCKET_EMPTY, (Listener)this.playerListener, Event.Priority.High, (Plugin)this);
        pm.registerEvent(Event.Type.PLAYER_ANIMATION, (Listener)this.playerListener, Event.Priority.High, (Plugin)this);
        this.blockListener = new EssentialsBlockListener(this);
        pm.registerEvent(Event.Type.SIGN_CHANGE, (Listener)this.blockListener, Event.Priority.Low, (Plugin)this);
        pm.registerEvent(Event.Type.BLOCK_BREAK, (Listener)this.blockListener, Event.Priority.Lowest, (Plugin)this);
        pm.registerEvent(Event.Type.BLOCK_PLACE, (Listener)this.blockListener, Event.Priority.Lowest, (Plugin)this);
        this.entityListener = new EssentialsEntityListener(this);
        pm.registerEvent(Event.Type.ENTITY_DAMAGE, (Listener)this.entityListener, Event.Priority.Lowest, (Plugin)this);
        pm.registerEvent(Event.Type.ENTITY_COMBUST, (Listener)this.entityListener, Event.Priority.Lowest, (Plugin)this);
        pm.registerEvent(Event.Type.ENTITY_DEATH, (Listener)this.entityListener, Event.Priority.Lowest, (Plugin)this);
        this.jail = new Jail(this);
        this.jailPlayerListener = new JailPlayerListener(this);
        this.confList.add(this.jail);
        pm.registerEvent(Event.Type.BLOCK_BREAK, (Listener)this.jail, Event.Priority.High, (Plugin)this);
        pm.registerEvent(Event.Type.BLOCK_DAMAGE, (Listener)this.jail, Event.Priority.High, (Plugin)this);
        pm.registerEvent(Event.Type.BLOCK_PLACE, (Listener)this.jail, Event.Priority.High, (Plugin)this);
        pm.registerEvent(Event.Type.PLAYER_INTERACT, (Listener)this.jailPlayerListener, Event.Priority.High, (Plugin)this);
        this.attachEcoListeners();
        if (this.settings.isNetherEnabled() && this.getServer().getWorlds().size() < 2) {
            this.getServer().createWorld(this.settings.getNetherName(), World.Environment.NETHER);
        }
        this.timer = new EssentialsTimer(this);
        this.getScheduler().scheduleSyncRepeatingTask((Plugin)this, (Runnable)this.timer, 1L, 50L);
        logger.info(Util.format("loadinfo", this.getDescription().getName(), this.getDescription().getVersion(), AUTHORS));
    }

    public void onDisable() {
        instance = null;
    }

    public void reload() {
        this.loadBanList();
        for (IConf iConf : this.confList) {
            iConf.reloadConfig();
        }
        try {
            ItemDb.load(this.getDataFolder(), "items.csv");
        }
        catch (Exception ex) {
            logger.log(Level.WARNING, Util.i18n("itemsCsvNotLoaded"), ex);
        }
    }

    public String[] getMotd(CommandSender sender, String def) {
        return this.getLines(sender, "motd", def);
    }

    public String[] getLines(CommandSender sender, String node, String def) {
        ArrayList<String> lines = (ArrayList<String>)this.getConfiguration().getProperty(node);
        if (lines == null) {
            return new String[0];
        }
        String[] retval = new String[lines.size()];
        if (lines == null || lines.isEmpty() || lines.get(0) == null) {
            try {
                lines = new ArrayList<String>();
                if (!this.getConfiguration().getString(node, def).equals("[]")) {
                    lines.add(this.getConfiguration().getString(node, def));
                    retval = new String[lines.size()];
                }
            }
            catch (Throwable ex2) {
                logger.log(Level.WARNING, Util.format("corruptNodeInConfig", node));
                return new String[0];
            }
        }
        if (lines == null || lines.isEmpty() || lines.get(0) == null) {
            return new String[0];
        }
        for (int i = 0; i < lines.size(); ++i) {
            String m = (String)lines.get(i);
            if (m == null) continue;
            m = m.replace('&', '\u00a7').replace("\u00a7\u00a7", "&");
            if (sender instanceof User || sender instanceof Player) {
                User user = this.getUser(sender);
                m = m.replace("{PLAYER}", user.getDisplayName());
                m = m.replace("{IP}", user.getAddress().toString());
                m = m.replace("{BALANCE}", Double.toString(user.getMoney()));
                m = m.replace("{MAILS}", Integer.toString(user.getMails().size()));
            }
            if ((m = m.replace("{ONLINE}", Integer.toString(this.getServer().getOnlinePlayers().length))).matches(".*\\{PLAYERLIST\\}.*")) {
                StringBuilder online = new StringBuilder();
                for (Player p : this.getServer().getOnlinePlayers()) {
                    if (online.length() > 0) {
                        online.append(", ");
                    }
                    online.append(p.getDisplayName());
                }
                m = m.replace("{PLAYERLIST}", online.toString());
            }
            if (sender instanceof Player) {
                try {
                    Class<?> User2 = this.getClassLoader().loadClass("bukkit.Vandolis.User");
                    Object vuser = User2.getConstructor(User.class).newInstance((Player)sender);
                    m = m.replace("{RED:BALANCE}", User2.getMethod("getMoney", new Class[0]).invoke(vuser, new Object[0]).toString());
                    m = m.replace("{RED:BUYS}", User2.getMethod("getNumTransactionsBuy", new Class[0]).invoke(vuser, new Object[0]).toString());
                    m = m.replace("{RED:SELLS}", User2.getMethod("getNumTransactionsSell", new Class[0]).invoke(vuser, new Object[0]).toString());
                }
                catch (Throwable ex) {
                    m = m.replace("{RED:BALANCE}", "N/A");
                    m = m.replace("{RED:BUYS}", "N/A");
                    m = m.replace("{RED:SELLS}", "N/A");
                }
            }
            retval[i] = m + " ";
        }
        return retval;
    }

    public static void previewCommand(CommandSender sender, Command command, String commandLabel, String[] args) {
        if (sender instanceof Player) {
            logger.info(ChatColor.BLUE + "[PLAYER_COMMAND] " + ((Player)sender).getName() + ": /" + commandLabel + " " + EssentialsCommand.getFinalArg(args, 0));
        }
    }

    public boolean onCommand(CommandSender sender, Command command, String commandLabel, String[] args) {
        return this.onCommandEssentials(sender, command, commandLabel, args, Essentials.class.getClassLoader(), "com.earth2me.essentials.commands.Command");
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean onCommandEssentials(CommandSender sender, Command command, String commandLabel, String[] args, ClassLoader classLoader, String commandPath) {
        IEssentialsCommand cmd;
        User user;
        block16: {
            List<String> mail;
            if ("msg".equals(commandLabel.toLowerCase()) || "mail".equals(commandLabel.toLowerCase()) & sender instanceof CraftPlayer) {
                StringBuilder str = new StringBuilder();
                str.append(commandLabel + " ");
                for (String string : args) {
                    str.append(string + " ");
                }
                for (String string : this.getServer().getOnlinePlayers()) {
                    if (!this.getUser(string).isSocialSpyEnabled()) continue;
                    string.sendMessage(this.getUser(sender).getDisplayName() + " : " + str);
                }
            }
            if (!this.getSettings().isCommandOverridden(command.getName()) && !commandLabel.startsWith("e")) {
                for (Plugin p : this.getServer().getPluginManager().getPlugins()) {
                    Map cmds;
                    PluginDescriptionFile pluginDescriptionFile;
                    if (p == this || (pluginDescriptionFile = p.getDescription()) == null || pluginDescriptionFile.getName() == null || !(pluginDescriptionFile.getCommands() instanceof Map) || !(cmds = (Map)pluginDescriptionFile.getCommands()).containsKey(command.getName())) continue;
                    PluginCommand pcmd = this.getServer().getPluginCommand(pluginDescriptionFile.getName() + ":" + commandLabel);
                    if (pcmd != null) return this.getServer().getPluginCommand(p.getDescription().getName() + ":" + commandLabel).execute(sender, commandLabel, args);
                }
            }
            Essentials.previewCommand(sender, command, commandLabel, args);
            User user2 = user = sender instanceof Player ? this.getUser(sender) : null;
            if (user != null && !this.getSettings().isCommandDisabled("mail") && !commandLabel.equals("mail") && user.isAuthorized("essentials.mail") && (mail = user.getMails()) != null && mail.size() > 0) {
                user.sendMessage(Util.format("youHaveNewMail", mail.size()));
            }
            if (this.getSettings().isCommandDisabled(commandLabel)) {
                return true;
            }
            try {
                cmd = (IEssentialsCommand)classLoader.loadClass(commandPath + command.getName()).newInstance();
            }
            catch (Exception ex) {
                sender.sendMessage(Util.format("commandNotLoaded", commandLabel));
                logger.log(Level.SEVERE, Util.format("commandNotLoaded", commandLabel), ex);
                return true;
            }
            if (user == null || user.isAuthorized(cmd)) break block16;
            logger.log(Level.WARNING, Util.format("deniedAccessCommand", user.getName()));
            user.sendMessage(Util.i18n("noAccessCommand"));
            return true;
            {
                catch (Throwable ex) {
                    logger.log(Level.SEVERE, Util.format("commandFailed", commandLabel), ex);
                    return true;
                }
            }
        }
        try {
            if (user == null) {
                cmd.run(this.getServer(), sender, commandLabel, command, args);
                return true;
            }
            cmd.run(this.getServer(), user, commandLabel, command, args);
            return true;
        }
        catch (NotEnoughArgumentsException ex) {
            sender.sendMessage(command.getDescription());
            sender.sendMessage(command.getUsage());
            return true;
            catch (Throwable ex2) {
                sender.sendMessage(ChatColor.RED + "Error: " + ex2.getMessage());
                if (!this.getSettings().isDebug()) return true;
                logger.log(Level.WARNING, Util.format("errorCallingCommand", commandLabel), ex2);
                return true;
            }
        }
    }

    public void loadBanList() {
        String line;
        int i;
        BufferedReader rx;
        File file = new File("banned-players.txt");
        File ipFile = new File("banned-ips.txt");
        try {
            if (!file.exists()) {
                throw new FileNotFoundException(Util.i18n("bannedPlayersFileNotFound"));
            }
            rx = new BufferedReader(new FileReader(file));
            this.bans.clear();
            try {
                i = 0;
                while (rx.ready()) {
                    line = rx.readLine().trim().toLowerCase();
                    if (!line.startsWith("#")) {
                        this.bans.add(line);
                    }
                    ++i;
                }
            }
            catch (IOException io) {
                logger.log(Level.SEVERE, Util.i18n("bannedPlayersFileError"), io);
            }
        }
        catch (FileNotFoundException ex) {
            logger.log(Level.SEVERE, Util.i18n("bannedPlayersFileError"), ex);
        }
        try {
            if (!ipFile.exists()) {
                throw new FileNotFoundException(Util.i18n("bannedIpsFileNotFound"));
            }
            rx = new BufferedReader(new FileReader(ipFile));
            this.bannedIps.clear();
            try {
                i = 0;
                while (rx.ready()) {
                    line = rx.readLine().trim().toLowerCase();
                    if (!line.startsWith("#")) {
                        this.bannedIps.add(line);
                    }
                    ++i;
                }
            }
            catch (IOException io) {
                logger.log(Level.SEVERE, Util.i18n("bannedIpsFileError"), io);
            }
        }
        catch (FileNotFoundException ex) {
            logger.log(Level.SEVERE, Util.i18n("bannedIpsFileError"), ex);
        }
    }

    private void attachEcoListeners() {
        PluginManager pm = this.getServer().getPluginManager();
        EssentialsEcoBlockListener ecoBlockListener = new EssentialsEcoBlockListener(this);
        EssentialsEcoPlayerListener ecoPlayerListener = new EssentialsEcoPlayerListener(this);
        pm.registerEvent(Event.Type.PLAYER_INTERACT, (Listener)ecoPlayerListener, Event.Priority.High, (Plugin)this);
        pm.registerEvent(Event.Type.BLOCK_BREAK, (Listener)ecoBlockListener, Event.Priority.High, (Plugin)this);
        pm.registerEvent(Event.Type.SIGN_CHANGE, (Listener)ecoBlockListener, Event.Priority.Monitor, (Plugin)this);
    }

    public CraftScheduler getScheduler() {
        return (CraftScheduler)this.getServer().getScheduler();
    }

    public static Jail getJail() {
        return Essentials.getStatic().jail;
    }

    public static Warps getWarps() {
        return Essentials.getStatic().warps;
    }

    public static Worth getWorth() {
        return Essentials.getStatic().worth;
    }

    public static Backup getBackup() {
        return Essentials.getStatic().backup;
    }

    public static Spawn getSpawn() {
        return Essentials.getStatic().spawn;
    }

    public <T> User getUser(T base) {
        if (base instanceof Player) {
            return this.getUser((Player)base);
        }
        return null;
    }

    private <T extends Player> User getUser(T base) {
        if (base == null) {
            return null;
        }
        if (base instanceof User) {
            return (User)base;
        }
        if (this.users.containsKey(base.getName())) {
            return this.users.get(base.getName()).update(base);
        }
        User u = new User(base, this);
        this.users.put(u.getName(), u);
        return u;
    }

    public User getOfflineUser(String name) {
        File userFolder = new File(this.getDataFolder(), "userdata");
        File userFile = new File(userFolder, Util.sanitizeFileName(name) + ".yml");
        if (userFile.exists()) {
            return this.getUser(new OfflinePlayer(name));
        }
        return null;
    }

    public World getWorld(String name) {
        int id;
        if (name.matches("[0-9]+") && (id = Integer.parseInt(name)) < this.getServer().getWorlds().size()) {
            return (World)this.getServer().getWorlds().get(id);
        }
        World w = this.getServer().getWorld(name);
        if (w != null) {
            return w;
        }
        File bukkitDirectory = Essentials.getStatic().getDataFolder().getParentFile().getParentFile();
        File worldDirectory = new File(bukkitDirectory, name);
        if (worldDirectory.exists() && worldDirectory.isDirectory()) {
            w = this.getServer().createWorld(name, World.Environment.NORMAL);
            if (w != null) {
                this.newWorldsLoaded = true;
            }
            return w;
        }
        return null;
    }

    public void setIConomyFallback(boolean iConomyFallback) {
        this.iConomyFallback = iConomyFallback;
    }

    public boolean isIConomyFallbackEnabled() {
        return this.iConomyFallback;
    }
}

