/*
 * Decompiled with CFR 0.152.
 */
package com.earth2me.essentials;

import com.earth2me.essentials.Util;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.Server;
import org.bukkit.World;
import org.bukkit.inventory.ItemStack;
import org.bukkit.util.config.Configuration;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EssentialsConf
extends Configuration {
    private static final Logger logger = Logger.getLogger("Minecraft");
    private File configFile;
    private String templateName = null;
    private Class<?> resourceClass = EssentialsConf.class;

    public EssentialsConf(File configFile) {
        super(configFile);
        this.configFile = configFile;
        if (this.root == null) {
            this.root = new HashMap();
        }
    }

    public void load() {
        this.configFile = this.configFile.getAbsoluteFile();
        if (!this.configFile.getParentFile().exists()) {
            this.configFile.getParentFile().mkdirs();
        }
        if (!this.configFile.exists()) {
            if (this.templateName != null) {
                logger.log(Level.INFO, Util.format("creatingConfigFromTemplate", this.configFile.toString()));
                this.createFromTemplate();
            } else {
                try {
                    logger.log(Level.INFO, Util.format("creatingEmptyConfig", this.configFile.toString()));
                    this.configFile.createNewFile();
                }
                catch (IOException ex) {
                    logger.log(Level.SEVERE, Util.format("failedToCreateConfig", this.configFile.toString()), ex);
                }
            }
        }
        super.load();
        if (this.root == null) {
            this.root = new HashMap();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void createFromTemplate() {
        InputStream istr;
        OutputStream ostr;
        block14: {
            ostr = null;
            istr = this.resourceClass.getResourceAsStream(this.templateName);
            if (istr != null) break block14;
            logger.log(Level.SEVERE, Util.format("couldNotFindTemplate", this.templateName));
            try {
                if (ostr == null) return;
                ostr.close();
                return;
            }
            catch (IOException ex) {
                logger.log(Level.SEVERE, Util.format("failedToCloseConfig", this.configFile.toString()), ex);
                return;
            }
        }
        ostr = new FileOutputStream(this.configFile);
        byte[] buffer = new byte[1024];
        int length = 0;
        length = istr.read(buffer);
        while (length > 0) {
            ostr.write(buffer, 0, length);
            length = istr.read(buffer);
        }
        istr.close();
        try {
            if (ostr == null) return;
            ostr.close();
            return;
        }
        catch (IOException ex) {
            logger.log(Level.SEVERE, Util.format("failedToCloseConfig", this.configFile.toString()), ex);
            return;
        }
        catch (IOException ex) {
            try {
                logger.log(Level.SEVERE, Util.format("failedToWriteConfig", this.configFile.toString()), ex);
            }
            catch (Throwable throwable) {
                try {
                    if (ostr == null) throw throwable;
                    ostr.close();
                    throw throwable;
                }
                catch (IOException ex2) {
                    logger.log(Level.SEVERE, Util.format("failedToCloseConfig", this.configFile.toString()), ex2);
                    return;
                }
            }
            try {
                if (ostr == null) return;
                ostr.close();
                return;
            }
            catch (IOException ex3) {
                logger.log(Level.SEVERE, Util.format("failedToCloseConfig", this.configFile.toString()), ex3);
                return;
            }
        }
    }

    public void setTemplateName(String templateName) {
        this.templateName = templateName;
    }

    public File getFile() {
        return this.configFile;
    }

    public void setTemplateName(String templateName, Class<?> resClass) {
        this.templateName = templateName;
        this.resourceClass = resClass;
    }

    public boolean hasProperty(String path) {
        return this.getProperty(path) != null;
    }

    public Location getLocation(String path, Server server) {
        String worldName = this.getString((path != null ? path + "." : "") + "world");
        if (worldName == null || worldName.isEmpty()) {
            return null;
        }
        World world = server.getWorld(worldName);
        if (world == null) {
            return null;
        }
        return new Location(world, this.getDouble((path != null ? path + "." : "") + "x", 0.0), this.getDouble((path != null ? path + "." : "") + "y", 0.0), this.getDouble((path != null ? path + "." : "") + "z", 0.0), (float)this.getDouble((path != null ? path + "." : "") + "yaw", 0.0), (float)this.getDouble((path != null ? path + "." : "") + "pitch", 0.0));
    }

    public void setProperty(String path, Location loc) {
        this.setProperty((path != null ? path + "." : "") + "world", loc.getWorld().getName());
        this.setProperty((path != null ? path + "." : "") + "x", loc.getX());
        this.setProperty((path != null ? path + "." : "") + "y", loc.getY());
        this.setProperty((path != null ? path + "." : "") + "z", loc.getZ());
        this.setProperty((path != null ? path + "." : "") + "yaw", Float.valueOf(loc.getYaw()));
        this.setProperty((path != null ? path + "." : "") + "pitch", Float.valueOf(loc.getPitch()));
    }

    public ItemStack getItemStack(String path) {
        return new ItemStack(Material.valueOf((String)this.getString(path + ".type", "AIR")), this.getInt(path + ".amount", 1), (short)this.getInt(path + ".damage", 0));
    }

    public void setProperty(String path, ItemStack stack) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("type", stack.getType().toString());
        map.put("amount", stack.getAmount());
        map.put("damage", stack.getDurability());
        this.setProperty(path, map);
    }

    public long getLong(String path, long def) {
        Number num = (Number)this.getProperty(path);
        if (num == null) {
            return def;
        }
        return num.longValue();
    }

    public double getDouble(String path, double def) {
        Number num = (Number)this.getProperty(path);
        if (num == null) {
            return def;
        }
        return num.doubleValue();
    }
}

