/*
 * Decompiled with CFR 0.152.
 */
package com.earth2me.essentials;

import com.earth2me.essentials.Essentials;
import com.earth2me.essentials.EssentialsBlockListener;
import com.earth2me.essentials.InventoryWorkaround;
import com.earth2me.essentials.ItemDb;
import com.earth2me.essentials.NetherPortal;
import com.earth2me.essentials.User;
import com.earth2me.essentials.Util;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.minecraft.server.EntityHuman;
import net.minecraft.server.InventoryPlayer;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.Server;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.block.Sign;
import org.bukkit.command.CommandSender;
import org.bukkit.craftbukkit.block.CraftSign;
import org.bukkit.craftbukkit.inventory.CraftInventoryPlayer;
import org.bukkit.entity.Player;
import org.bukkit.event.block.Action;
import org.bukkit.event.player.PlayerAnimationEvent;
import org.bukkit.event.player.PlayerAnimationType;
import org.bukkit.event.player.PlayerBucketEmptyEvent;
import org.bukkit.event.player.PlayerChatEvent;
import org.bukkit.event.player.PlayerEggThrowEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerListener;
import org.bukkit.event.player.PlayerLoginEvent;
import org.bukkit.event.player.PlayerMoveEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.event.player.PlayerRespawnEvent;
import org.bukkit.event.player.PlayerTeleportEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;

public class EssentialsPlayerListener
extends PlayerListener {
    private static final Logger logger = Logger.getLogger("Minecraft");
    private final Server server;
    private final Essentials ess;
    private EssentialsBlockListener essBlockListener = null;

    public EssentialsPlayerListener(Essentials parent) {
        this.ess = parent;
        this.server = parent.getServer();
        this.essBlockListener = new EssentialsBlockListener(parent);
    }

    public void onPlayerRespawn(PlayerRespawnEvent event) {
        User user = this.ess.getUser(event.getPlayer());
        user.setDisplayName(user.getNick());
        this.updateCompass(user);
        if (user.isJailed() && user.getJail() != null && !user.getJail().isEmpty()) {
            try {
                event.setRespawnLocation(Essentials.getJail().getJail(user.getJail()));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public void onPlayerChat(PlayerChatEvent event) {
        User user = this.ess.getUser(event.getPlayer());
        if (user.isMuted()) {
            event.setCancelled(true);
            logger.info(Util.format("mutedUserSpeaks", user.getName()));
        }
    }

    public void onPlayerMove(PlayerMoveEvent event) {
        if (event.isCancelled()) {
            return;
        }
        User user = this.ess.getUser(event.getPlayer());
        if (!this.ess.getSettings().getNetherPortalsEnabled()) {
            return;
        }
        Block block = event.getPlayer().getWorld().getBlockAt(event.getTo().getBlockX(), event.getTo().getBlockY(), event.getTo().getBlockZ());
        List worlds = this.server.getWorlds();
        if (block.getType() == Material.PORTAL && worlds.size() > 1 && user.isAuthorized("essentials.portal")) {
            World world;
            if (user.getJustPortaled()) {
                return;
            }
            Location loc = event.getTo();
            World nether = this.server.getWorld(this.ess.getSettings().getNetherName());
            if (nether == null) {
                for (World world2 : worlds) {
                    if (world2.getEnvironment() != World.Environment.NETHER) continue;
                    nether = world2;
                    break;
                }
                if (nether == null) {
                    return;
                }
            }
            World world3 = world = user.getWorld() == nether ? (World)worlds.get(0) : nether;
            double factor = user.getWorld().getEnvironment() == World.Environment.NETHER && world.getEnvironment() == World.Environment.NORMAL ? this.ess.getSettings().getNetherRatio() : (user.getWorld().getEnvironment() != world.getEnvironment() ? 1.0 / this.ess.getSettings().getNetherRatio() : 1.0);
            int x = loc.getBlockX();
            int y = loc.getBlockY();
            int z = loc.getBlockZ();
            if (user.getWorld().getBlockAt(x, y, z - 1).getType() == Material.PORTAL) {
                --z;
            }
            if (user.getWorld().getBlockAt(x - 1, y, z).getType() == Material.PORTAL) {
                --x;
            }
            x = (int)((double)x * factor);
            z = (int)((double)z * factor);
            loc = new Location(world, (double)x + 0.5, (double)y, (double)z + 0.5);
            Block dest = world.getBlockAt(x, y, z);
            NetherPortal portal = NetherPortal.findPortal(dest);
            if (portal == null) {
                if (world.getEnvironment() == World.Environment.NETHER || this.ess.getSettings().getGenerateExitPortals()) {
                    portal = NetherPortal.createPortal(dest);
                    logger.info(Util.format("userCreatedPortal ", event.getPlayer().getName()));
                    user.sendMessage(Util.i18n("generatingPortal"));
                    loc = portal.getSpawn();
                }
            } else {
                logger.info(Util.format("userUsedPortal", event.getPlayer().getName()));
                user.sendMessage(Util.i18n("usingPortal"));
                loc = portal.getSpawn();
            }
            event.setFrom(loc);
            event.setTo(loc);
            try {
                user.getTeleport().teleport(loc, "portal");
            }
            catch (Exception ex) {
                user.sendMessage(ex.getMessage());
            }
            user.setJustPortaled(true);
            user.sendMessage(Util.i18n("teleportingPortal"));
            event.setCancelled(true);
            return;
        }
        user.setJustPortaled(false);
    }

    public void onPlayerQuit(PlayerQuitEvent event) {
        User user = this.ess.getUser(event.getPlayer());
        if (user.getSavedInventory() != null) {
            user.getInventory().setContents(user.getSavedInventory());
            user.setSavedInventory(null);
        }
        if (!this.ess.getSettings().getReclaimSetting()) {
            return;
        }
        user.dispose();
        Thread thread = new Thread(new Runnable(){

            public void run() {
                try {
                    Thread.sleep(1000L);
                    Runtime rt = Runtime.getRuntime();
                    double mem = rt.freeMemory();
                    rt.runFinalization();
                    rt.gc();
                    mem = (double)rt.freeMemory() - mem;
                    logger.log(Level.INFO, Util.format("freedMemory", mem /= 1048576.0));
                }
                catch (InterruptedException ex) {
                    return;
                }
            }
        });
        thread.setPriority(1);
        thread.start();
    }

    public void onPlayerJoin(PlayerJoinEvent event) {
        Essentials.getBackup().onPlayerJoin();
        User user = this.ess.getUser(event.getPlayer());
        if (user.isIpBanned()) {
            String banReason = user.getBanReason();
            user.kickPlayer(banReason != null && !banReason.isEmpty() ? banReason : Util.i18n("defaultBanReason"));
            return;
        }
        user.setDisplayName(user.getNick());
        if (!this.ess.getSettings().isCommandDisabled("motd") && user.isAuthorized("essentials.motd")) {
            for (String m : this.ess.getMotd((CommandSender)user, null)) {
                if (m == null) continue;
                user.sendMessage(m);
            }
        }
        if (!this.ess.getSettings().isCommandDisabled("mail") && user.isAuthorized("essentials.mail")) {
            List<String> mail = user.getMails();
            if (mail.isEmpty()) {
                user.sendMessage(Util.i18n("noNewMail"));
            } else {
                user.sendMessage(Util.format("youHaveNewMail", mail.size()));
            }
        }
    }

    public void onPlayerLogin(PlayerLoginEvent event) {
        User user = this.ess.getUser(event.getPlayer());
        if (event.getResult() != PlayerLoginEvent.Result.ALLOWED) {
            return;
        }
        if (user.isBanned()) {
            String banReason = user.getBanReason();
            event.disallow(PlayerLoginEvent.Result.KICK_BANNED, banReason != null && !banReason.isEmpty() ? banReason : Util.i18n("defaultBanReason"));
            return;
        }
        if (this.server.getOnlinePlayers().length >= this.server.getMaxPlayers() && !user.isAuthorized("essentials.joinfullserver")) {
            event.disallow(PlayerLoginEvent.Result.KICK_FULL, Util.i18n("serverFull"));
            return;
        }
        user.setLastLogin(System.currentTimeMillis());
        this.updateCompass(user);
    }

    private void updateCompass(User user) {
        try {
            user.setCompassTarget(user.getHome());
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void onPlayerTeleport(PlayerTeleportEvent event) {
        if (event.isCancelled()) {
            return;
        }
        User user = this.ess.getUser(event.getPlayer());
        if (!user.isJailed() || user.getJail() == null || user.getJail().isEmpty()) {
            return;
        }
        try {
            event.setTo(Essentials.getJail().getJail(user.getJail()));
        }
        catch (Exception ex) {
            logger.log(Level.WARNING, Util.i18n("returnPlayerToJailError"), ex);
        }
        user.sendMessage(Util.i18n("jailMessage"));
    }

    public void onPlayerInteract(PlayerInteractEvent event) {
        if (event.isCancelled()) {
            return;
        }
        if (event.getAction() != Action.RIGHT_CLICK_BLOCK) {
            return;
        }
        User user = this.ess.getUser(event.getPlayer());
        if (user.isJailed()) {
            event.setCancelled(true);
            return;
        }
        if (!this.ess.getSettings().areSignsDisabled() && EssentialsBlockListener.protectedBlocks.contains(event.getClickedBlock().getType()) && !user.isAuthorized("essentials.signs.protection.override") && this.essBlockListener.isBlockProtected(event.getClickedBlock(), user)) {
            event.setCancelled(true);
            user.sendMessage(Util.format("noAccessPermission", event.getClickedBlock().getType().toString().toLowerCase()));
            return;
        }
        if (this.ess.getSettings().getBedSetsHome() && event.getClickedBlock().getType() == Material.BED_BLOCK) {
            try {
                user.setHome();
                user.sendMessage(Util.i18n("homeSetToBed"));
            }
            catch (Throwable ex) {
                // empty catch block
            }
        }
        if (this.ess.getSettings().areSignsDisabled()) {
            return;
        }
        if (event.getClickedBlock().getType() != Material.WALL_SIGN && event.getClickedBlock().getType() != Material.SIGN_POST) {
            return;
        }
        CraftSign sign = new CraftSign(event.getClickedBlock());
        try {
            if (sign.getLine(0).equals("\u00a71[Free]") && user.isAuthorized("essentials.signs.free.use")) {
                ItemStack item = ItemDb.get(sign.getLine(1));
                CraftInventoryPlayer inv = new CraftInventoryPlayer(new InventoryPlayer((EntityHuman)user.getHandle()));
                inv.clear();
                item.setAmount(2304);
                inv.addItem(new ItemStack[]{item});
                user.showInventory(inv);
                return;
            }
            if (sign.getLine(0).equals("\u00a71[Disposal]") && user.isAuthorized("essentials.signs.disposal.use")) {
                CraftInventoryPlayer inv = new CraftInventoryPlayer(new InventoryPlayer((EntityHuman)user.getHandle()));
                inv.clear();
                user.showInventory(inv);
                return;
            }
            if (sign.getLine(0).equals("\u00a71[Heal]") && user.isAuthorized("essentials.signs.heal.use")) {
                if (!sign.getLine(1).isEmpty()) {
                    String[] l1 = sign.getLine(1).split("[ :-]+");
                    boolean m1 = l1[0].matches("\\$[0-9]+");
                    int q1 = Integer.parseInt(m1 ? l1[0].substring(1) : l1[0]);
                    if (q1 < 1) {
                        throw new Exception(Util.i18n("moreThanZero"));
                    }
                    if (m1) {
                        if (user.getMoney() < (double)q1) {
                            throw new Exception(Util.i18n("notEnoughMoney"));
                        }
                        user.takeMoney(q1);
                        user.sendMessage(Util.format("moneyTaken", Util.formatCurrency(q1)));
                    } else {
                        ItemStack i = ItemDb.get(l1[1], q1);
                        if (!InventoryWorkaround.containsItem((Inventory)user.getInventory(), true, i)) {
                            throw new Exception(Util.format("missingItems", q1, l1[1]));
                        }
                        InventoryWorkaround.removeItem((Inventory)user.getInventory(), true, i);
                        user.updateInventory();
                    }
                }
                user.setHealth(20);
                user.sendMessage(Util.i18n("youAreHealed"));
                return;
            }
            if (sign.getLine(0).equals("\u00a71[Mail]") && user.isAuthorized("essentials.signs.mail.use") && user.isAuthorized("essentials.mail")) {
                List<String> mail = user.getMails();
                if (mail.isEmpty()) {
                    user.sendMessage(Util.i18n("noNewMail"));
                    return;
                }
                for (String s : mail) {
                    user.sendMessage(s);
                }
                user.sendMessage(Util.i18n("markMailAsRead"));
                return;
            }
            if (sign.getLine(0).equals("\u00a71[Balance]") && user.isAuthorized("essentials.signs.balance.use")) {
                user.sendMessage(Util.format("balance", user.getMoney()));
                return;
            }
            if (sign.getLine(0).equals("\u00a71[Warp]")) {
                if (!sign.getLine(2).isEmpty()) {
                    if (sign.getLine(2).equals("\u00a72Everyone")) {
                        this.chargeUserForWarp((Sign)sign, user);
                        user.getTeleport().warp(sign.getLine(1), "warpsign");
                        return;
                    }
                    if (user.inGroup(sign.getLine(2))) {
                        this.chargeUserForWarp((Sign)sign, user);
                        user.getTeleport().warp(sign.getLine(1), "warpsign");
                        return;
                    }
                }
                if (user.isAuthorized("essentials.signs.warp.use") && (!this.ess.getSettings().getPerWarpPermission() || user.isAuthorized("essentials.warp." + sign.getLine(1)))) {
                    this.chargeUserForWarp((Sign)sign, user);
                    user.getTeleport().warp(sign.getLine(1), "warpsign");
                }
                return;
            }
        }
        catch (Throwable ex) {
            user.sendMessage(Util.format("errorWithMessage", ex.getMessage()));
        }
    }

    private void chargeUserForWarp(Sign sign, User user) throws Exception {
        if (!sign.getLine(3).isEmpty()) {
            String[] l1 = sign.getLine(3).split("[ :-]+");
            boolean m1 = l1[0].matches("\\$[0-9]+");
            int q1 = Integer.parseInt(m1 ? l1[0].substring(1) : l1[0]);
            if (q1 < 1) {
                throw new Exception(Util.i18n("moreThanZero"));
            }
            if (m1) {
                if (user.getMoney() < (double)q1) {
                    throw new Exception(Util.i18n("notEnoughMoney"));
                }
                user.takeMoney(q1);
                user.sendMessage(Util.format("moneyTaken", Util.formatCurrency(q1)));
            } else {
                ItemStack i = ItemDb.get(l1[1], q1);
                if (!InventoryWorkaround.containsItem((Inventory)user.getInventory(), true, i)) {
                    throw new Exception(Util.format("missingItems", q1, l1[1]));
                }
                InventoryWorkaround.removeItem((Inventory)user.getInventory(), true, i);
                user.updateInventory();
            }
        }
    }

    public void onPlayerEggThrow(PlayerEggThrowEvent event) {
        ItemStack is;
        User user = this.ess.getUser(event.getPlayer());
        if (user.hasUnlimited(is = new ItemStack(Material.EGG, 1))) {
            user.getInventory().addItem(new ItemStack[]{is});
            user.updateInventory();
        }
    }

    public void onPlayerBucketEmpty(PlayerBucketEmptyEvent event) {
        final User user = this.ess.getUser(event.getPlayer());
        if (user.hasUnlimited(new ItemStack(event.getBucket()))) {
            event.getItemStack().setType(event.getBucket());
            Essentials.getStatic().getScheduler().scheduleSyncDelayedTask((Plugin)Essentials.getStatic(), new Runnable(){

                public void run() {
                    user.updateInventory();
                }
            });
        }
    }

    public void onPlayerAnimation(PlayerAnimationEvent event) {
        this.usePowertools(event);
    }

    private void usePowertools(PlayerAnimationEvent event) {
        if (event.getAnimationType() != PlayerAnimationType.ARM_SWING) {
            return;
        }
        User user = this.ess.getUser(event.getPlayer());
        ItemStack is = user.getItemInHand();
        if (is == null || is.getType() == Material.AIR) {
            return;
        }
        String command = user.getPowertool(is);
        if (command == null || command.isEmpty()) {
            return;
        }
        if (command.matches(".*\\{player\\}.*")) {
            return;
        }
        if (command.startsWith("c:")) {
            for (Player p : this.server.getOnlinePlayers()) {
                p.sendMessage(user.getDisplayName() + ":" + command.substring(2));
            }
        } else {
            user.getServer().dispatchCommand((CommandSender)user, command);
        }
    }
}

