/*
 * Decompiled with CFR 0.152.
 */
package com.earth2me.essentials;

import com.earth2me.essentials.Essentials;
import com.earth2me.essentials.IConf;
import com.earth2me.essentials.OfflinePlayer;
import com.earth2me.essentials.User;
import com.earth2me.essentials.Util;
import java.io.File;
import java.util.HashSet;
import java.util.Set;
import org.bukkit.craftbukkit.CraftServer;
import org.bukkit.entity.Player;

public class EssentialsTimer
implements Runnable,
IConf {
    private Essentials parent;
    private Set<User> allUsers = new HashSet<User>();

    EssentialsTimer(Essentials parent) {
        this.parent = parent;
        File userdir = new File(parent.getDataFolder(), "userdata");
        if (!userdir.exists()) {
            return;
        }
        for (String string : userdir.list()) {
            if (!string.endsWith(".yml")) continue;
            String name = string.substring(0, string.length() - 4);
            User u = parent.getUser(new OfflinePlayer(name));
            this.allUsers.add(u);
        }
    }

    public void run() {
        long currentTime = System.currentTimeMillis();
        for (Player player : this.parent.getServer().getOnlinePlayers()) {
            User u = this.parent.getUser(player);
            this.allUsers.add(u);
            u.setLastActivity(currentTime);
        }
        for (User user : this.allUsers) {
            if (user.getBanTimeout() > 0L && user.getBanTimeout() < currentTime) {
                user.setBanTimeout(0L);
                ((CraftServer)this.parent.getServer()).getHandle().b(user.getName());
                Essentials.getStatic().loadBanList();
            }
            if (user.getMuteTimeout() > 0L && user.getMuteTimeout() < currentTime && user.isMuted()) {
                user.setMuteTimeout(0L);
                user.sendMessage(Util.i18n("canTalkAgain"));
                user.setMuted(false);
            }
            if (user.getJailTimeout() > 0L && user.getJailTimeout() < currentTime && user.isJailed()) {
                user.setJailTimeout(0L);
                user.setJailed(false);
                user.sendMessage(Util.i18n("haveBeenReleased"));
                user.setJail(null);
                try {
                    user.getTeleport().back();
                }
                catch (Exception ex) {
                    // empty catch block
                }
            }
            if (user.getLastActivity() >= currentTime || user.getLastActivity() <= user.getLastLogout()) continue;
            user.setLastLogout(user.getLastActivity());
        }
    }

    public void reloadConfig() {
        for (User user : this.allUsers) {
            user.reloadConfig();
        }
    }
}

