/*
 * Decompiled with CFR 0.152.
 */
package com.earth2me.essentials;

import com.earth2me.essentials.Essentials;
import com.earth2me.essentials.EssentialsConf;
import com.earth2me.essentials.OfflinePlayer;
import com.earth2me.essentials.User;
import com.earth2me.essentials.Util;
import com.earth2me.essentials.Worth;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.inventory.ItemStack;

public class EssentialsUpgrade {
    private static boolean alreadyRun = false;
    private static final Logger logger = Logger.getLogger("Minecraft");
    private Essentials ess;

    EssentialsUpgrade(String version, Essentials essentials) {
        if (alreadyRun) {
            return;
        }
        alreadyRun = true;
        this.ess = essentials;
        if (!this.ess.getDataFolder().exists()) {
            this.ess.getDataFolder().mkdirs();
        }
        this.moveWorthValuesToWorthYml();
        this.sanitizeAllUserFilenames();
        this.updateUsersToNewDefaultHome();
        this.moveUsersDataToUserdataFolder();
        this.convertWarps();
    }

    private void moveWorthValuesToWorthYml() {
        try {
            File configFile = new File(this.ess.getDataFolder(), "config.yml");
            if (!configFile.exists()) {
                return;
            }
            EssentialsConf conf = new EssentialsConf(configFile);
            conf.load();
            Worth w = new Worth(this.ess.getDataFolder());
            for (Material mat : Material.values()) {
                int id = mat.getId();
                double value = conf.getDouble("worth-" + id, Double.NaN);
                if (Double.isNaN(value)) continue;
                w.setPrice(new ItemStack(mat, 1, 0, Byte.valueOf((byte)0)), value);
            }
            this.removeLinesFromConfig(configFile, "\\s*#?\\s*worth-[0-9]+.*", "# Worth values have been moved to worth.yml");
        }
        catch (Throwable e) {
            logger.log(Level.SEVERE, Util.i18n("upgradingFilesError"), e);
        }
    }

    private void removeLinesFromConfig(File file, String regex, String info) throws Exception {
        String line;
        boolean needUpdate = false;
        BufferedReader br = new BufferedReader(new FileReader(file));
        File tempFile = File.createTempFile("essentialsupgrade", ".tmp.yml", this.ess.getDataFolder());
        BufferedWriter bw = new BufferedWriter(new FileWriter(tempFile));
        while ((line = br.readLine()) != null) {
            if (line.matches(regex)) {
                if (!needUpdate && info != null) {
                    bw.write(info, 0, info.length());
                    bw.newLine();
                }
                needUpdate = true;
                continue;
            }
            if (line.endsWith("\r\n")) {
                bw.write(line, 0, line.length() - 2);
            } else if (line.endsWith("\r") || line.endsWith("\n")) {
                bw.write(line, 0, line.length() - 1);
            } else {
                bw.write(line, 0, line.length());
            }
            bw.newLine();
        }
        br.close();
        bw.close();
        if (needUpdate) {
            if (!file.renameTo(new File(file.getParentFile(), file.getName().concat("." + System.currentTimeMillis() + ".upgradebackup")))) {
                throw new Exception(Util.i18n("configFileMoveError"));
            }
            if (!tempFile.renameTo(file)) {
                throw new Exception(Util.i18n("configFileRenameError"));
            }
        } else {
            tempFile.delete();
        }
    }

    private void updateUsersToNewDefaultHome() {
        File[] userFiles;
        File userdataFolder = new File(this.ess.getDataFolder(), "userdata");
        if (!userdataFolder.exists() || !userdataFolder.isDirectory()) {
            return;
        }
        for (File file : userFiles = userdataFolder.listFiles()) {
            List vals;
            if (!file.isFile() || !file.getName().endsWith(".yml")) continue;
            EssentialsConf config = new EssentialsConf(file);
            config.load();
            if (!config.hasProperty("home") || config.hasProperty("home.default") || (vals = (List)config.getProperty("home")) == null) continue;
            World world = (World)this.ess.getServer().getWorlds().get(0);
            if (vals.size() > 5) {
                world = this.ess.getServer().getWorld((String)vals.get(5));
            }
            if (world == null) continue;
            Location loc = new Location(world, ((Number)vals.get(0)).doubleValue(), ((Number)vals.get(1)).doubleValue(), ((Number)vals.get(2)).doubleValue(), ((Number)vals.get(3)).floatValue(), ((Number)vals.get(4)).floatValue());
            String worldName = world.getName().toLowerCase();
            if (worldName == null || worldName.isEmpty()) continue;
            config.removeProperty("home");
            config.setProperty("home.default", worldName);
            config.setProperty("home.worlds." + worldName, loc);
            config.save();
        }
    }

    private void moveUsersDataToUserdataFolder() {
        File usersFile = new File(this.ess.getDataFolder(), "users.yml");
        if (!usersFile.exists()) {
            return;
        }
        EssentialsConf usersConfig = new EssentialsConf(usersFile);
        usersConfig.load();
        for (String username : usersConfig.getKeys(null)) {
            List vals;
            List mails;
            User user = new User(new OfflinePlayer(username), this.ess);
            String nickname = usersConfig.getString(username + ".nickname");
            if (nickname != null && !nickname.isEmpty() && !nickname.equals(username)) {
                user.setNickname(nickname);
            }
            if ((mails = usersConfig.getStringList(username + ".mail", null)) != null && !mails.isEmpty()) {
                user.setMails(mails);
            }
            if (user.hasHome() || (vals = (List)usersConfig.getProperty(username + ".home")) == null) continue;
            World world = (World)this.ess.getServer().getWorlds().get(0);
            if (vals.size() > 5) {
                world = this.ess.getWorld((String)vals.get(5));
            }
            if (world == null) continue;
            user.setHome(new Location(world, ((Number)vals.get(0)).doubleValue(), ((Number)vals.get(1)).doubleValue(), ((Number)vals.get(2)).doubleValue(), ((Number)vals.get(3)).floatValue(), ((Number)vals.get(4)).floatValue()), true);
        }
        usersFile.renameTo(new File(usersFile.getAbsolutePath() + ".old"));
    }

    private void convertWarps() {
        File warpFile;
        World w;
        File[] listOfFiles;
        File warpsFolder = new File(this.ess.getDataFolder(), "warps");
        if (!warpsFolder.exists()) {
            warpsFolder.mkdirs();
        }
        if ((listOfFiles = warpsFolder.listFiles()).length >= 1) {
            for (int i = 0; i < listOfFiles.length; ++i) {
                String filename = listOfFiles[i].getName();
                if (!listOfFiles[i].isFile() || !filename.endsWith(".dat")) continue;
                try {
                    BufferedReader rx = new BufferedReader(new FileReader(listOfFiles[i]));
                    double x = Double.parseDouble(rx.readLine().trim());
                    double y = Double.parseDouble(rx.readLine().trim());
                    double z = Double.parseDouble(rx.readLine().trim());
                    float yaw = Float.parseFloat(rx.readLine().trim());
                    float pitch = Float.parseFloat(rx.readLine().trim());
                    String worldName = rx.readLine();
                    rx.close();
                    w = null;
                    for (World world : this.ess.getServer().getWorlds()) {
                        if (world.getEnvironment() == World.Environment.NETHER) continue;
                        w = world;
                        break;
                    }
                    boolean forceWorldName = false;
                    if (worldName != null) {
                        worldName.trim();
                        World w1 = null;
                        w1 = this.ess.getWorld(worldName);
                        if (w1 != null) {
                            w = w1;
                        }
                    }
                    Location loc = new Location(w, x, y, z, yaw, pitch);
                    Essentials.getWarps().setWarp(filename.substring(0, filename.length() - 4), loc);
                    if (!listOfFiles[i].renameTo(new File(warpsFolder, filename + ".old"))) {
                        throw new Exception(Util.format("fileRenameError", filename));
                    }
                    continue;
                }
                catch (Exception ex) {
                    logger.log(Level.SEVERE, null, ex);
                }
            }
        }
        if ((warpFile = new File(this.ess.getDataFolder(), "warps.txt")).exists()) {
            try {
                BufferedReader rx = new BufferedReader(new FileReader(warpFile));
                String[] parts = new String[]{};
                while (rx.ready()) {
                    if (parts.length >= 6) {
                        String name = parts[0];
                        double x = Double.parseDouble(parts[1].trim());
                        double y = Double.parseDouble(parts[2].trim());
                        double z = Double.parseDouble(parts[3].trim());
                        float yaw = Float.parseFloat(parts[4].trim());
                        float pitch = Float.parseFloat(parts[5].trim());
                        if (!name.isEmpty()) {
                            w = null;
                            for (World world : this.ess.getServer().getWorlds()) {
                                if (world.getEnvironment() == World.Environment.NETHER) continue;
                                w = world;
                                break;
                            }
                            Location loc = new Location(w, x, y, z, yaw, pitch);
                            Essentials.getWarps().setWarp(name, loc);
                            if (!warpFile.renameTo(new File(this.ess.getDataFolder(), "warps.txt.old"))) {
                                throw new Exception(Util.format("fileRenameError", "warps.txt"));
                            }
                        }
                    }
                    parts = rx.readLine().split(":");
                }
            }
            catch (Exception ex) {
                logger.log(Level.SEVERE, null, ex);
            }
        }
    }

    private void sanitizeAllUserFilenames() {
        File usersFolder = new File(this.ess.getDataFolder(), "userdata");
        if (!usersFolder.exists()) {
            return;
        }
        File[] listOfFiles = usersFolder.listFiles();
        for (int i = 0; i < listOfFiles.length; ++i) {
            String sanitizedFilename;
            String filename = listOfFiles[i].getName();
            if (!listOfFiles[i].isFile() || !filename.endsWith(".yml") || (sanitizedFilename = Util.sanitizeFileName(filename.substring(0, filename.length() - 4)) + ".yml").equals(filename)) continue;
            File tmpFile = new File(listOfFiles[i].getParentFile(), sanitizedFilename + ".tmp");
            File newFile = new File(listOfFiles[i].getParentFile(), sanitizedFilename);
            if (!listOfFiles[i].renameTo(tmpFile)) {
                logger.log(Level.WARNING, Util.format("userdataMoveError", filename, sanitizedFilename));
                continue;
            }
            if (newFile.exists()) {
                logger.log(Level.WARNING, Util.format("duplicatedUserdata", filename, sanitizedFilename));
                continue;
            }
            if (tmpFile.renameTo(newFile)) continue;
            logger.log(Level.WARNING, Util.format("userdataMoveBackError", sanitizedFilename, sanitizedFilename));
        }
    }
}

