/*
 * Decompiled with CFR 0.152.
 */
package com.earth2me.essentials;

import com.earth2me.essentials.Util;
import java.lang.reflect.Constructor;
import java.util.HashMap;
import java.util.logging.Logger;
import net.minecraft.server.WorldServer;
import org.bukkit.Server;
import org.bukkit.craftbukkit.CraftServer;
import org.bukkit.craftbukkit.CraftWorld;
import org.bukkit.craftbukkit.entity.CraftEntity;
import org.bukkit.entity.Player;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum Mob {
    CHICKEN("Chicken", Enemies.FRIENDLY),
    COW("Cow", Enemies.FRIENDLY),
    CREEPER("Creeper", Enemies.ENEMY),
    GHAST("Ghast", Enemies.ENEMY),
    GIANT("Giant", "GiantZombie", Enemies.ENEMY),
    PIG("Pig", Enemies.FRIENDLY),
    PIGZOMB("PigZombie", Enemies.NEUTRAL),
    SHEEP("Sheep", Enemies.FRIENDLY, ""),
    SKELETON("Skeleton", Enemies.ENEMY),
    SLIME("Slime", Enemies.ENEMY),
    SPIDER("Spider", Enemies.ENEMY),
    SQUID("Squid", Enemies.FRIENDLY),
    ZOMBIE("Zombie", Enemies.ENEMY),
    MONSTER("Monster", Enemies.ENEMY),
    WOLF("Wolf", Enemies.NEUTRAL);

    public static final Logger logger;
    public String s = "s";
    public String name;
    public Enemies type;
    private String entityClass;
    private String craftClass;
    private static final HashMap<String, Mob> hashMap;

    private Mob(String n2, Enemies en, String s) {
        this.s = s;
        this.name = n2;
        this.craftClass = n2;
        this.entityClass = n2;
        this.type = en;
    }

    private Mob(String n2, Enemies en) {
        this.name = n2;
        this.craftClass = n2;
        this.entityClass = n2;
        this.type = en;
    }

    private Mob(String n2, String ec, Enemies en) {
        this.name = n2;
        this.craftClass = n2;
        this.entityClass = ec;
        this.type = en;
    }

    private Mob(String n2, String ec, String cc, Enemies en) {
        this.name = n2;
        this.entityClass = ec;
        this.craftClass = cc;
        this.type = en;
    }

    public CraftEntity spawn(Player player, Server server) throws MobException {
        try {
            WorldServer world = ((CraftWorld)player.getWorld()).getHandle();
            Constructor<?> craft = ClassLoader.getSystemClassLoader().loadClass("org.bukkit.craftbukkit.entity.Craft" + this.craftClass).getConstructors()[0];
            Constructor<?> entity = ClassLoader.getSystemClassLoader().loadClass("net.minecraft.server.Entity" + this.entityClass).getConstructors()[0];
            return (CraftEntity)craft.newInstance((CraftServer)server, entity.newInstance(world));
        }
        catch (Exception ex) {
            logger.warning(Util.i18n("unableToSpawnMob"));
            ex.printStackTrace();
            throw new MobException();
        }
    }

    public static Mob fromName(String n) {
        return hashMap.get(n);
    }

    static {
        logger = Logger.getLogger("Minecraft");
        hashMap = new HashMap();
        for (Mob mob : Mob.values()) {
            hashMap.put(mob.name, mob);
        }
    }

    public class MobException
    extends Exception {
        private static final long serialVersionUID = 1L;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Enemies {
        FRIENDLY("friendly"),
        NEUTRAL("neutral"),
        ENEMY("enemy");

        protected String type;

        private Enemies(String t) {
            this.type = t;
        }
    }
}

