/*
 * Decompiled with CFR 0.152.
 */
package com.earth2me.essentials;

import com.earth2me.essentials.Util;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.block.Block;

public class NetherPortal {
    private Block block;

    public NetherPortal(Block b) {
        this.block = b;
    }

    public Block getBlock() {
        return this.block;
    }

    public void setBlock(Block b) {
        this.block = b;
    }

    public Location getSpawn() {
        if (this.block.getWorld().getBlockAt(this.block.getX() + 1, this.block.getY(), this.block.getZ()).getType().equals((Object)Material.PORTAL) || this.block.getWorld().getBlockAt(this.block.getX() - 1, this.block.getY(), this.block.getZ()).getType().equals((Object)Material.PORTAL)) {
            return new Location(this.block.getWorld(), (double)(this.block.getX() + 1), (double)this.block.getY(), (double)((long)(this.block.getZ() + 1) - 2L * Math.round(Math.random())));
        }
        return new Location(this.block.getWorld(), (double)((long)(this.block.getX() + 1) - 2L * Math.round(Math.random())), (double)this.block.getY(), (double)(this.block.getZ() + 1));
    }

    public static NetherPortal findPortal(Block dest) {
        World world = dest.getWorld();
        ArrayList<Block> columns = new ArrayList<Block>();
        for (int x = dest.getX() - 16; x <= dest.getX() + 16; ++x) {
            for (int z = dest.getZ() - 16; z <= dest.getZ() + 16; ++z) {
                int dz;
                int dx = dest.getX() - x;
                if (dx * dx + (dz = dest.getZ() - z) * dz > 256) continue;
                columns.add(world.getBlockAt(x, 0, z));
            }
        }
        for (Block col : columns) {
            for (int y = 127; y >= 0; --y) {
                Block b = world.getBlockAt(col.getX(), y, col.getZ());
                if (!b.getType().equals((Object)Material.PORTAL) || Math.abs(dest.getY() - y) > 16) continue;
                return new NetherPortal(b);
            }
        }
        return null;
    }

    public static NetherPortal createPortal(Block dest) {
        World world = dest.getWorld();
        Material m = dest.getType();
        while ((m.equals((Object)Material.LAVA) || m.equals((Object)Material.WATER) || m.equals((Object)Material.STATIONARY_LAVA) || m.equals((Object)Material.STATIONARY_WATER) || m.equals((Object)Material.SAND) || m.equals((Object)Material.GRAVEL)) && dest.getY() < 120) {
            dest = world.getBlockAt(dest.getX(), dest.getY() + 4, dest.getZ());
            m = dest.getType();
        }
        if (dest.getY() > 120) {
            dest = world.getBlockAt(dest.getX(), 120, dest.getZ());
        } else if (dest.getY() < 8) {
            dest = world.getBlockAt(dest.getX(), 8, dest.getZ());
        }
        int x = dest.getX();
        int y = dest.getY();
        int z = dest.getZ();
        Logger.getLogger("Minecraft").log(Level.INFO, Util.format("creatingPortal", x, y, z));
        ArrayList<Block> columns = new ArrayList<Block>();
        for (int x2 = x - 4; x2 <= x + 4; ++x2) {
            for (int z2 = z - 4; z2 <= z + 4; ++z2) {
                double dx = (float)x + 0.5f - (float)x2;
                double dz = z - z2;
                if (!(dx * dx + dz * dz <= 13.0)) continue;
                columns.add(world.getBlockAt(x2, 0, z2));
            }
        }
        for (Block col : columns) {
            world.getBlockAt(col.getX(), y - 1, col.getZ()).setType(Material.STONE);
            for (int yd = 0; yd < 4; ++yd) {
                world.getBlockAt(col.getX(), y + yd, col.getZ()).setType(Material.AIR);
            }
        }
        for (int xd = -1; xd < 3; ++xd) {
            for (int yd = -1; yd < 4; ++yd) {
                if (xd != -1 && yd != -1 && xd != 2 && yd != 3) continue;
                world.getBlockAt(x + xd, y + yd, z).setType(Material.OBSIDIAN);
            }
        }
        dest.setType(Material.FIRE);
        return new NetherPortal(dest);
    }
}

