/*
 * Decompiled with CFR 0.152.
 */
package com.earth2me.essentials;

import com.earth2me.essentials.EssentialsConf;
import com.earth2me.essentials.IConf;
import java.io.File;
import java.util.HashMap;
import java.util.logging.Logger;
import org.bukkit.Location;
import org.bukkit.Server;
import org.bukkit.World;

public class Spawn
implements IConf {
    private static final Logger logger = Logger.getLogger("Minecraft");
    private EssentialsConf config;
    private Server server;

    public Spawn(Server server, File dataFolder) {
        File configFile = new File(dataFolder, "spawn.yml");
        this.server = server;
        this.config = new EssentialsConf(configFile);
        this.config.load();
    }

    public void setSpawn(Location loc, String group) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("world", loc.getWorld().getName());
        map.put("x", loc.getX());
        map.put("y", loc.getY());
        map.put("z", loc.getZ());
        map.put("yaw", Float.valueOf(loc.getYaw()));
        map.put("pitch", Float.valueOf(loc.getPitch()));
        this.config.setProperty(group, map);
        this.config.save();
        if ("default".equals(group)) {
            loc.getWorld().setSpawnLocation(loc.getBlockX(), loc.getBlockY(), loc.getBlockZ());
        }
    }

    public Location getSpawn(String group) {
        if (this.config.getProperty(group) == null) {
            group = "default";
        }
        if (this.config.getProperty(group) == null) {
            for (World w : this.server.getWorlds()) {
                if (w.getEnvironment() != World.Environment.NORMAL) continue;
                return w.getSpawnLocation();
            }
        }
        String worldId = this.config.getString(group + ".world", "");
        World world = (World)this.server.getWorlds().get(this.server.getWorlds().size() > 1 ? 1 : 0);
        for (World w : this.server.getWorlds()) {
            if (w.getEnvironment() != World.Environment.NORMAL) continue;
            world = w;
            break;
        }
        for (World w : this.server.getWorlds()) {
            if (!w.getName().equals(worldId)) continue;
            world = w;
            break;
        }
        double x = this.config.getDouble(group + ".x", this.config.getDouble("default.x", 0.0));
        double y = this.config.getDouble(group + ".y", this.config.getDouble("default.y", 0.0));
        double z = this.config.getDouble(group + ".z", this.config.getDouble("default.z", 0.0));
        float yaw = (float)this.config.getDouble(group + ".yaw", this.config.getDouble("default.yaw", 0.0));
        float pitch = (float)this.config.getDouble(group + ".pitch", this.config.getDouble("default.pitch", 0.0));
        Location retval = new Location(world, x, y, z, yaw, pitch);
        if (y < 1.0) {
            retval.setY((double)world.getHighestBlockYAt(retval));
        }
        return retval;
    }

    public void reloadConfig() {
        this.config.load();
    }
}

