/*
 * Decompiled with CFR 0.152.
 */
package com.earth2me.essentials;

import com.earth2me.essentials.Essentials;
import com.earth2me.essentials.IReplyTo;
import com.earth2me.essentials.OfflinePlayer;
import com.earth2me.essentials.Teleport;
import com.earth2me.essentials.UserData;
import com.earth2me.essentials.Util;
import com.earth2me.essentials.commands.IEssentialsCommand;
import com.nijikokun.bukkit.Permissions.Permissions;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.logging.Logger;
import org.bukkit.ChatColor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class User
extends UserData
implements Comparable<User>,
IReplyTo {
    private static final Logger logger = Logger.getLogger("Minecraft");
    private boolean justPortaled = false;
    private CommandSender replyTo = null;
    private User teleportRequester;
    private boolean teleportRequestHere;
    private Teleport teleport;
    private long lastActivity;

    User(Player base, Essentials ess) {
        super(base, ess);
        this.teleport = new Teleport(this, ess);
    }

    User update(Player base) {
        this.setBase(base);
        return this;
    }

    public boolean isAuthorized(IEssentialsCommand cmd) {
        return this.isAuthorized("essentials." + (cmd.getName().equals("r") ? "msg" : cmd.getName()));
    }

    public boolean isAuthorized(String node) {
        if (this.isOp()) {
            return true;
        }
        if (this.isJailed()) {
            return false;
        }
        try {
            return Permissions.Security.permission(this.base, node);
        }
        catch (Throwable ex) {
            String[] cmds = node.split("\\.", 2);
            return !this.ess.getSettings().isCommandRestricted(cmds[cmds.length - 1]);
        }
    }

    public void healCooldown() throws Exception {
        GregorianCalendar now = new GregorianCalendar();
        if (this.getLastHealTimestamp() > 0L) {
            double cooldown = this.ess.getSettings().getHealCooldown();
            GregorianCalendar cooldownTime = new GregorianCalendar();
            cooldownTime.setTimeInMillis(this.getLastHealTimestamp());
            ((Calendar)cooldownTime).add(13, (int)cooldown);
            ((Calendar)cooldownTime).add(14, (int)(cooldown * 1000.0 % 1000.0));
            if (cooldownTime.after(now) && !this.isAuthorized("essentials.heal.cooldown.bypass")) {
                throw new Exception(Util.format("timeBeforeHeal", Util.formatDateDiff(cooldownTime.getTimeInMillis())));
            }
        }
        this.setLastHealTimestamp(now.getTimeInMillis());
    }

    public void giveMoney(double value) {
        if (value == 0.0) {
            return;
        }
        this.setMoney(this.getMoney() + value);
        this.sendMessage(Util.format("addedToAccount", Util.formatCurrency(value)));
    }

    public void payUser(User reciever, double value) throws Exception {
        if (value == 0.0) {
            return;
        }
        if (!this.canAfford(value)) {
            throw new Exception(Util.i18n("notEnoughMoney"));
        }
        this.setMoney(this.getMoney() - value);
        reciever.setMoney(reciever.getMoney() + value);
        this.sendMessage(Util.format("moneySentTo", Util.formatCurrency(value), reciever.getDisplayName()));
        reciever.sendMessage(Util.format("moneyRecievedFrom", Util.formatCurrency(value), this.getDisplayName()));
    }

    public void takeMoney(double value) {
        if (value == 0.0) {
            return;
        }
        this.setMoney(this.getMoney() - value);
        this.sendMessage(Util.format("takenFromAccount", Util.formatCurrency(value)));
    }

    public void charge(String cmd) throws Exception {
        double cost;
        if (this.isAuthorized("essentials.nocommandcost.all") || this.isAuthorized("essentials.nocommandcost." + cmd)) {
            return;
        }
        double mon = this.getMoney();
        if (mon < (cost = (double)this.ess.getSettings().getCommandCost(cmd.startsWith("/") ? cmd.substring(1) : cmd)) && !this.isAuthorized("essentials.eco.loan")) {
            throw new Exception(Util.i18n("notEnoughMoney"));
        }
        this.takeMoney(cost);
    }

    public void canAfford(String cmd) throws Exception {
        double cost;
        double mon = this.getMoney();
        if (mon < (cost = (double)this.ess.getSettings().getCommandCost(cmd.startsWith("/") ? cmd.substring(1) : cmd)) && !this.isAuthorized("essentials.eco.loan")) {
            throw new Exception(Util.i18n("notEnoughMoney"));
        }
    }

    public boolean canAfford(double cost) {
        double mon = this.getMoney();
        return !(mon < cost) || this.isAuthorized("essentials.eco.loan");
    }

    public void canAfford(IEssentialsCommand cmd) throws Exception {
        this.canAfford(cmd.getName());
    }

    public void dispose() {
        this.base = new OfflinePlayer(this.getName());
    }

    public void charge(IEssentialsCommand cmd) throws Exception {
        this.charge(cmd.getName());
    }

    public boolean getJustPortaled() {
        return this.justPortaled;
    }

    public void setJustPortaled(boolean value) {
        this.justPortaled = value;
    }

    @Override
    public void setReplyTo(CommandSender user) {
        this.replyTo = user;
    }

    @Override
    public CommandSender getReplyTo() {
        return this.replyTo;
    }

    @Override
    public int compareTo(User t) {
        return ChatColor.stripColor((String)this.getDisplayName()).compareToIgnoreCase(ChatColor.stripColor((String)t.getDisplayName()));
    }

    public Boolean canSpawnItem(int itemId) {
        return !this.ess.getSettings().itemSpawnBlacklist().contains(itemId);
    }

    public void setHome() {
        this.setHome(this.getLocation(), true);
    }

    public void setHome(boolean defaultHome) {
        this.setHome(this.getLocation(), defaultHome);
    }

    public void setLastLocation() {
        this.setLastLocation(this.getLocation());
    }

    public void requestTeleport(User player, boolean here) {
        this.teleportRequester = player;
        this.teleportRequestHere = here;
    }

    public User getTeleportRequest() {
        return this.teleportRequester;
    }

    public boolean isTeleportRequestHere() {
        return this.teleportRequestHere;
    }

    public String getNick() {
        String nickname = this.getNickname();
        nickname = this.ess.getSettings().isCommandDisabled("nick") || nickname == null || nickname.isEmpty() || nickname.equals(this.getName()) ? this.getName() : this.ess.getSettings().getNicknamePrefix() + nickname;
        if (this.isOp()) {
            nickname = this.ess.getSettings().getOperatorColor().toString() + nickname + "\u00a7f";
        }
        return nickname;
    }

    public Teleport getTeleport() {
        return this.teleport;
    }

    public long getLastActivity() {
        return this.lastActivity;
    }

    public void setLastActivity(long timestamp) {
        this.lastActivity = timestamp;
    }
}

