/*
 * Decompiled with CFR 0.152.
 */
package com.earth2me.essentials.api;

import com.earth2me.essentials.Essentials;
import com.earth2me.essentials.User;
import com.earth2me.essentials.Util;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.text.DecimalFormat;
import org.bukkit.Bukkit;

public class Economy {
    protected static Essentials ess = Essentials.getStatic();

    protected static boolean accountCreated(String name) {
        File folder = new File(ess.getDataFolder(), "userdata");
        File account = new File(folder, name.toLowerCase() + ".yml");
        return account.exists();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static void createAccount(String name) {
        File folder = new File(ess.getDataFolder(), "userdata");
        File npcFile = new File(folder, name + ".yml");
        try {
            if (!npcFile.createNewFile()) {
                System.out.println("Failed file creation");
            }
            return;
        }
        catch (IOException e) {
            System.out.println("Could not create Non-player account file!");
            FileWriter fileWriter = null;
            BufferedWriter bufferWriter = null;
            try {
                if (!npcFile.exists()) {
                    npcFile.createNewFile();
                }
                fileWriter = new FileWriter(npcFile);
                bufferWriter = new BufferedWriter(fileWriter);
                bufferWriter.append("money: ");
                bufferWriter.append(Integer.valueOf(0).toString());
                bufferWriter.newLine();
            }
            catch (IOException e2) {
                System.out.println("Exception on config creation: ");
            }
            finally {
                try {
                    if (bufferWriter != null) {
                        bufferWriter.flush();
                        bufferWriter.close();
                    }
                    if (fileWriter != null) {
                        fileWriter.close();
                    }
                }
                catch (IOException e3) {
                    System.out.println("IO Exception writing file: " + npcFile.getName());
                }
            }
            return;
        }
    }

    protected static User usrConv(String name) {
        User user = null;
        if (Bukkit.getServer().getPlayer(name) != null) {
            user = ess.getUser(Bukkit.getServer().getPlayer(name));
            return user;
        }
        user = ess.getOfflineUser(name);
        return user;
    }

    public static boolean exist(String name) {
        if (name == null) {
            System.out.println("EcoAPI - Whatever plugin is calling for users that are null is BROKEN!");
            return false;
        }
        return Bukkit.getServer().getPlayer(name) != null;
    }

    public static double getMoney(String name) {
        if (!Economy.exist(name)) {
            if (Economy.accountCreated(name)) {
                User user = Economy.usrConv(name);
                return user.getMoney();
            }
            return 0.0;
        }
        User user = Economy.usrConv(name);
        return user.getMoney();
    }

    public static void setMoney(String name, double bal) {
        if (!Economy.exist(name)) {
            if (Economy.accountCreated(name)) {
                User user = Economy.usrConv(name);
                user.setMoney(bal);
            }
            return;
        }
        User user = Economy.usrConv(name);
        user.setMoney(bal);
    }

    public static void add(String name, double money) {
        if (!Economy.exist(name)) {
            if (Economy.accountCreated(name)) {
                double result = Economy.getMoney(name) + money;
                Economy.setMoney(name, result);
            }
            return;
        }
        double result = Economy.getMoney(name) + money;
        Economy.setMoney(name, result);
    }

    public static void divide(String name, double money) {
        if (!Economy.exist(name)) {
            if (Economy.accountCreated(name)) {
                double result = Economy.getMoney(name) / money;
                Economy.setMoney(name, result);
                return;
            }
            return;
        }
        double result = Economy.getMoney(name) / money;
        Economy.setMoney(name, result);
    }

    public static void multiply(String name, double money) {
        if (!Economy.exist(name)) {
            if (Economy.accountCreated(name)) {
                double result = Economy.getMoney(name) * money;
                Economy.setMoney(name, result);
                return;
            }
            return;
        }
        double result = Economy.getMoney(name) * money;
        Economy.setMoney(name, result);
    }

    public static void subtract(String name, double money) {
        if (!Economy.exist(name)) {
            if (Economy.accountCreated(name)) {
                double result = Economy.getMoney(name) - money;
                Economy.setMoney(name, result);
                return;
            }
            return;
        }
        double result = Economy.getMoney(name) - money;
        Economy.setMoney(name, result);
    }

    public static void resetBalance(String name) {
        Economy.setMoney(name, 0.0);
    }

    public static boolean hasEnough(String name, double amount) {
        return amount <= Economy.getMoney(name);
    }

    public static boolean hasMore(String name, double amount) {
        return amount < Economy.getMoney(name);
    }

    public static boolean hasLess(String name, double amount) {
        return amount > Economy.getMoney(name);
    }

    public static String getCurrency() {
        return ess.getSettings().getCurrency();
    }

    public static String getCurrencyPlural() {
        return ess.getSettings().getCurrencyPlural();
    }

    public static boolean isNegative(String name) {
        return Economy.getMoney(name) < 0.0;
    }

    public static String format(double amount) {
        DecimalFormat ecoForm = new DecimalFormat("#,##0.##");
        String formed = ecoForm.format(amount);
        if (formed.endsWith(".")) {
            formed = formed.substring(0, formed.length() - 1);
        }
        return formed + " " + (amount <= 1.0 && amount >= -1.0 ? Economy.getCurrency() : Economy.getCurrencyPlural());
    }

    public static boolean accountExist(String account) {
        return Economy.accountCreated(account);
    }

    public static boolean newAccount(String account) {
        if (!Economy.exist(account)) {
            if (!Economy.accountCreated(account)) {
                Economy.createAccount(account);
                return true;
            }
            return false;
        }
        return false;
    }

    public static void removeAccount(String name) {
        if (!Economy.exist(name) && Economy.accountCreated(name)) {
            File folder = new File(ess.getDataFolder(), "userdata");
            File account = new File(folder, Util.sanitizeFileName(name) + ".yml");
            account.delete();
        }
    }
}

