/*
 * Decompiled with CFR 0.152.
 */
package com.earth2me.essentials.commands;

import com.earth2me.essentials.User;
import com.earth2me.essentials.commands.EssentialsCommand;
import com.earth2me.essentials.commands.NotEnoughArgumentsException;
import org.bukkit.Server;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class Commandnick
extends EssentialsCommand {
    public Commandnick() {
        super("nick");
    }

    public void run(Server server, User user, String commandLabel, String[] args) throws Exception {
        if (args.length < 1) {
            throw new NotEnoughArgumentsException();
        }
        if (args.length > 1) {
            if (!user.isAuthorized("essentials.nick.others")) {
                user.sendMessage("\u00a7cYou do not have permission to change the nickname of others");
                return;
            }
            this.setOthersNickname(server, (CommandSender)user, args);
            return;
        }
        String nick = args[0];
        if ("off".equalsIgnoreCase(nick) || user.getName().equalsIgnoreCase(nick)) {
            user.setDisplayName(user.getName());
            user.setNickname(null);
            user.sendMessage("\u00a77You no longer have a nickname.");
            return;
        }
        if (nick.matches("[^a-zA-Z_0-9]")) {
            user.sendMessage("\u00a7cNicknames must be alphanumeric.");
            return;
        }
        for (Player p : server.getOnlinePlayers()) {
            if (user == p) continue;
            String dn = p.getDisplayName().toLowerCase();
            String n = p.getName().toLowerCase();
            String nk = nick.toLowerCase();
            if (!nk.equals(dn) && !nk.equals(n)) continue;
            user.sendMessage("\u00a7cThat name is already in use.");
            return;
        }
        user.charge(this);
        user.setDisplayName(this.ess.getConfiguration().getString("nickname-prefix", "~") + nick);
        user.setNickname(nick);
        user.sendMessage("\u00a77Your nickname is now \u00a7c" + user.getDisplayName() + "\u00a77.");
    }

    public void run(Server server, CommandSender sender, String commandLabel, String[] args) throws Exception {
        if (args.length < 2) {
            throw new NotEnoughArgumentsException();
        }
        this.setOthersNickname(server, sender, args);
    }

    private void setOthersNickname(Server server, CommandSender sender, String[] args) throws Exception {
        User target = this.getPlayer(server, args, 0);
        String nick = args[1];
        if ("off".equalsIgnoreCase(nick) || target.getName().equalsIgnoreCase(nick)) {
            target.setDisplayName(target.getName());
            target.setNickname(null);
            target.sendMessage("\u00a77You no longer have a nickname.");
        } else {
            target.setDisplayName(this.ess.getSettings().getNicknamePrefix() + nick);
            target.setNickname(nick);
            target.sendMessage("\u00a77Your nickname is now \u00a7c" + target.getDisplayName() + "\u00a77.");
        }
        sender.sendMessage("Nickname changed.");
    }
}

