/*
 * Decompiled with CFR 0.152.
 */
package com.earth2me.essentials.commands;

import com.earth2me.essentials.Mob;
import com.earth2me.essentials.TargetBlock;
import com.earth2me.essentials.User;
import com.earth2me.essentials.commands.EssentialsCommand;
import com.earth2me.essentials.commands.NotEnoughArgumentsException;
import net.minecraft.server.EntityWolf;
import net.minecraft.server.PathEntity;
import net.minecraft.server.WorldServer;
import org.bukkit.DyeColor;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.Server;
import org.bukkit.block.Block;
import org.bukkit.command.CommandSender;
import org.bukkit.craftbukkit.CraftWorld;
import org.bukkit.craftbukkit.entity.CraftCreeper;
import org.bukkit.craftbukkit.entity.CraftEntity;
import org.bukkit.craftbukkit.entity.CraftSheep;
import org.bukkit.craftbukkit.entity.CraftSlime;
import org.bukkit.craftbukkit.entity.CraftWolf;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;

public class Commandspawnmob
extends EssentialsCommand {
    public Commandspawnmob() {
        super("spawnmob");
    }

    public void run(Server server, User user, String commandLabel, String[] args) throws Exception {
        if (args.length < 1) {
            throw new NotEnoughArgumentsException();
        }
        String[] mountparts = args[0].split(",");
        String[] parts = mountparts[0].split(":");
        String mobType = parts[0];
        mobType = mobType.equalsIgnoreCase("PigZombie") ? "PigZombie" : this.capitalCase(mobType);
        String mobData = null;
        if (parts.length == 2) {
            mobData = parts[1];
        }
        String mountType = null;
        String mountData = null;
        if (mountparts.length > 1) {
            parts = mountparts[1].split(":");
            mountType = parts[0];
            String string = mountType = mountType.equalsIgnoreCase("PigZombie") ? "PigZombie" : this.capitalCase(mountType);
            if (parts.length == 2) {
                mountData = parts[1];
            }
        }
        CraftEntity spawnedMob = null;
        Mob mob = null;
        CraftEntity spawnedMount = null;
        Mob mobMount = null;
        mob = Mob.fromName(mobType);
        if (mob == null) {
            user.sendMessage("Invalid mob type.");
            return;
        }
        this.charge((CommandSender)user);
        WorldServer world = ((CraftWorld)user.getWorld()).getHandle();
        try {
            spawnedMob = mob.spawn(user, server);
        }
        catch (Mob.MobException e) {
            user.sendMessage("Unable to spawn mob.");
            return;
        }
        int[] ignore = new int[]{8, 9};
        Location loc = new TargetBlock((Player)user, 300, 0.2, ignore).getTargetBlock().getLocation();
        Block block = user.getWorld().getBlockAt(loc);
        while (block.getType() != Material.AIR && block.getType() != Material.WATER && block.getType() != Material.STATIONARY_WATER) {
            loc.setY(loc.getY() + 1.0);
            block = user.getWorld().getBlockAt(loc);
        }
        spawnedMob.teleportTo(loc);
        world.addEntity(spawnedMob.getHandle());
        if (mountType != null) {
            mobMount = Mob.fromName(mountType);
            if (mobMount == null) {
                user.sendMessage("Invalid mob type.");
                return;
            }
            try {
                spawnedMount = mobMount.spawn(user, server);
            }
            catch (Mob.MobException e) {
                user.sendMessage("Unable to spawn mob.");
                return;
            }
            spawnedMount.teleportTo((Entity)spawnedMob);
            spawnedMount.getHandle().setPassengerOf(spawnedMob.getHandle());
            world.addEntity(spawnedMount.getHandle());
        }
        if (mobData != null) {
            this.changeMobData(mob.name, spawnedMob, mobData, user);
        }
        if (spawnedMount != null && mountData != null) {
            this.changeMobData(mobMount.name, spawnedMount, mountData, user);
        }
        if (args.length == 2) {
            int serverLimit;
            int mobCount = Integer.parseInt(args[1]);
            if (mobCount > (serverLimit = this.ess.getSettings().getSpawnMobLimit())) {
                mobCount = serverLimit;
                user.sendMessage("Mob quantity limited to server limit");
            }
            try {
                for (int i = 1; i < mobCount; ++i) {
                    spawnedMob = mob.spawn(user, server);
                    spawnedMob.teleportTo(loc);
                    world.addEntity(spawnedMob.getHandle());
                    if (mobMount != null) {
                        try {
                            spawnedMount = mobMount.spawn(user, server);
                        }
                        catch (Mob.MobException e) {
                            user.sendMessage("Unable to spawn mob.");
                            return;
                        }
                        spawnedMount.teleportTo((Entity)spawnedMob);
                        spawnedMount.getHandle().setPassengerOf(spawnedMob.getHandle());
                        world.addEntity(spawnedMount.getHandle());
                    }
                    if (mobData != null) {
                        this.changeMobData(mob.name, spawnedMob, mobData, user);
                    }
                    if (spawnedMount == null || mountData == null) continue;
                    this.changeMobData(mobMount.name, spawnedMount, mountData, user);
                }
                user.sendMessage(args[1] + " " + mob.name.toLowerCase() + mob.s + " spawned.");
            }
            catch (Mob.MobException e1) {
                throw new Exception("Unable to spawn mobs. Insert bad excuse here.");
            }
            catch (NumberFormatException e2) {
                throw new Exception("A number goes there, silly.");
            }
            catch (NullPointerException np) {
                throw new Exception("That mob likes to be alone");
            }
        }
        user.sendMessage(mob.name + " spawned.");
    }

    private String capitalCase(String s) {
        return s.toUpperCase().charAt(0) + s.toLowerCase().substring(1);
    }

    private void changeMobData(String type, CraftEntity spawned, String data, User user) throws Exception {
        if ("Slime".equalsIgnoreCase(type)) {
            try {
                ((CraftSlime)spawned).setSize(Integer.parseInt(data));
            }
            catch (Exception e) {
                throw new Exception("Malformed size.");
            }
        }
        if ("Sheep".equalsIgnoreCase(type)) {
            try {
                ((CraftSheep)spawned).setColor(DyeColor.valueOf((String)data.toUpperCase()));
            }
            catch (Exception e) {
                throw new Exception("Malformed color.");
            }
        }
        if ("Wolf".equalsIgnoreCase(type) && data.equalsIgnoreCase("tamed")) {
            EntityWolf wolf = ((CraftWolf)spawned).getHandle();
            wolf.d(true);
            wolf.a((PathEntity)null);
            wolf.setSitting(true);
            wolf.health = 20;
            wolf.a(user.getName());
            wolf.world.a((net.minecraft.server.Entity)wolf, (byte)7);
        }
        if ("Wolf".equalsIgnoreCase(type) && data.equalsIgnoreCase("angry")) {
            ((CraftWolf)spawned).setAngry(true);
        }
        if ("Creeper".equalsIgnoreCase(type) && data.equalsIgnoreCase("powered")) {
            ((CraftCreeper)spawned).setPowered(true);
        }
    }
}

