/*
 * Decompiled with CFR 0.152.
 */
package com.earth2me.essentials.commands;

import com.earth2me.essentials.Essentials;
import com.earth2me.essentials.User;
import com.earth2me.essentials.Warps;
import com.earth2me.essentials.commands.EssentialsCommand;
import org.bukkit.Server;

public class Commandwarp
extends EssentialsCommand {
    public Commandwarp() {
        super("warp");
    }

    public void run(Server server, User user, String commandLabel, String[] args) throws Exception {
        if (args.length == 0) {
            if (!user.isAuthorized("essentials.warp.list")) {
                user.sendMessage("\u00a7cYou do not have Permission to list that warps.");
                return;
            }
            Warps warps = Essentials.getWarps();
            if (warps.isEmpty()) {
                throw new Exception("No warps defined");
            }
            StringBuilder sb = new StringBuilder();
            int i = 0;
            for (String warpName : warps.getWarpNames()) {
                if (this.ess.getSettings().getPerWarpPermission()) {
                    if (!user.isAuthorized("essentials.warp." + warpName)) continue;
                    if (i++ > 0) {
                        sb.append(", ");
                    }
                    sb.append(warpName);
                    continue;
                }
                if (i++ > 0) {
                    sb.append(", ");
                }
                sb.append(warpName);
            }
            user.sendMessage(sb.toString());
            return;
        }
        if (args.length > 0) {
            User otherUser = null;
            if (args.length == 2 && user.isAuthorized("essentials.warp.otherplayers")) {
                otherUser = this.ess.getUser(server.getPlayer(args[1]));
                if (otherUser == null) {
                    user.sendMessage("\u00a7cPlayer not found");
                    return;
                }
                this.warpUser(otherUser, args[0]);
                return;
            }
            this.warpUser(user, args[0]);
        }
    }

    private void warpUser(User user, String name) throws Exception {
        if (this.ess.getSettings().getPerWarpPermission()) {
            if (user.isAuthorized("essentials.warp." + name)) {
                user.getTeleport().warp(name, this.getName());
                return;
            }
            user.sendMessage("\u00a7cYou do not have Permission to use that warp.");
            return;
        }
        user.getTeleport().warp(name, this.getName());
    }
}

