/*
 * Decompiled with CFR 0.152.
 */
package be.Balor.Manager;

import be.Balor.Manager.ACCommand;
import be.Balor.Manager.ACCommandContainer;
import be.Balor.Manager.Exceptions.CommandAlreadyExist;
import be.Balor.Manager.Exceptions.CommandDisabled;
import be.Balor.Tools.Type;
import be.Balor.Tools.Utils;
import be.Balor.bukkit.AdminCmd.ACHelper;
import be.Balor.bukkit.AdminCmd.AdminCmd;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.Semaphore;
import java.util.logging.Logger;
import org.bukkit.ChatColor;
import org.bukkit.command.Command;
import org.bukkit.command.CommandException;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.PluginCommand;
import org.bukkit.command.PluginCommandYamlParser;
import org.bukkit.command.SimpleCommandMap;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public class CommandManager
implements CommandExecutor {
    private HashMap<Command, ACCommand> commands = new HashMap();
    private final int MAX_THREADS = 5;
    private ArrayList<ExecutorThread> threads = new ArrayList(5);
    private int cmdCount = 0;
    private static CommandManager instance = null;
    private JavaPlugin plugin;
    private boolean threadsStarted = false;
    private List<String> disabledCommands;
    private List<String> prioritizedCommands;
    private HashMap<String, ACCommand> commandReplacer = new HashMap();
    private HashMap<String, Command> pluginCommands = new HashMap();

    public static CommandManager getInstance() {
        if (instance == null) {
            instance = new CommandManager();
        }
        return instance;
    }

    public static void killInstance() {
        instance = null;
    }

    public void setDisabledCommands(List<String> disabledCommands) {
        this.disabledCommands = disabledCommands;
    }

    public void setPrioritizedCommands(List<String> prioritizedCommands) {
        this.prioritizedCommands = prioritizedCommands;
    }

    private Object getPrivateField(Object object, String field) throws SecurityException, NoSuchFieldException, IllegalArgumentException, IllegalAccessException {
        Class<?> clazz = object.getClass();
        Field objectField = clazz.getDeclaredField(field);
        objectField.setAccessible(true);
        Object result = objectField.get(object);
        objectField.setAccessible(false);
        return result;
    }

    private void unRegisterBukkitCommand(PluginCommand cmd) {
        try {
            Object result = this.getPrivateField(this.plugin.getServer().getPluginManager(), "commandMap");
            SimpleCommandMap commandMap = (SimpleCommandMap)result;
            Object map = this.getPrivateField(commandMap, "knownCommands");
            HashMap knownCommands = (HashMap)map;
            knownCommands.remove(cmd.getName());
            for (String alias : cmd.getAliases()) {
                knownCommands.remove(alias);
            }
        }
        catch (SecurityException e) {
            e.printStackTrace();
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
        }
        catch (NoSuchFieldException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
    }

    public ACCommand getCommand(String alias) {
        return this.commandReplacer.get(alias);
    }

    public void setPlugin(JavaPlugin plugin) {
        this.plugin = plugin;
        for (Command cmd : PluginCommandYamlParser.parse((Plugin)plugin)) {
            this.pluginCommands.put(cmd.getName(), cmd);
        }
        this.startThreads();
    }

    public void startThreads() {
        if (!this.threadsStarted) {
            this.threads.clear();
            for (int i = 0; i < 5; ++i) {
                this.threads.add(new ExecutorThread());
                this.threads.get(i).start();
            }
        }
        this.threadsStarted = true;
    }

    public void registerCommand(Class<?> clazz) {
        block11: {
            ACCommand command = null;
            try {
                command = (ACCommand)clazz.newInstance();
                command.initializeCommand(this.plugin);
                for (String alias : this.pluginCommands.get(command.getCmdName()).getAliases()) {
                    if (this.disabledCommands.contains(alias)) {
                        throw new CommandDisabled("Command " + command.getCmdName() + " selected to be disabled in the configuration file.");
                    }
                    if (!this.prioritizedCommands.contains(alias)) continue;
                    this.commandReplacer.put(alias, command);
                }
                command.registerBukkitPerm();
                command.getPluginCommand().setExecutor((CommandExecutor)this);
                this.commands.put((Command)command.getPluginCommand(), command);
            }
            catch (InstantiationException e) {
                e.printStackTrace();
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
            catch (CommandDisabled e) {
                this.unRegisterBukkitCommand(command.getPluginCommand());
                if (((Boolean)ACHelper.getInstance().getConfValue("verboseLog")).booleanValue()) {
                    Logger.getLogger("Minecraft").info("[AdminCmd] " + e.getMessage());
                }
            }
            catch (CommandAlreadyExist e) {
                for (String alias : this.pluginCommands.get(command.getCmdName()).getAliases()) {
                    if (!this.prioritizedCommands.contains(alias)) continue;
                    this.commandReplacer.put(alias, command);
                    command.registerBukkitPerm();
                    command.getPluginCommand().setExecutor((CommandExecutor)this);
                    this.commands.put((Command)command.getPluginCommand(), command);
                    return;
                }
                this.unRegisterBukkitCommand(command.getPluginCommand());
                if (((Boolean)ACHelper.getInstance().getConfValue("verboseLog")).booleanValue()) {
                    Logger.getLogger("Minecraft").info("[AdminCmd] " + e.getMessage());
                }
            }
            catch (CommandException e) {
                if (!((Boolean)ACHelper.getInstance().getConfValue("verboseLog")).booleanValue()) break block11;
                Logger.getLogger("Minecraft").info("[AdminCmd] " + e.getMessage());
            }
        }
    }

    public void checkAlias() {
        if (((Boolean)ACHelper.getInstance().getConfValue("verboseLog")).booleanValue()) {
            for (String cmdName : this.pluginCommands.keySet()) {
                Command cmd = this.pluginCommands.get(cmdName);
                if (this.plugin.getCommand(cmd.getName()) == null) continue;
                cmd.getAliases().removeAll(this.plugin.getCommand(cmd.getName()).getAliases());
                cmd.getAliases().removeAll(this.prioritizedCommands);
                String aliases = "";
                for (String alias : cmd.getAliases()) {
                    aliases = aliases + alias + ", ";
                }
                if (aliases.isEmpty() || !((Boolean)ACHelper.getInstance().getConfValue("verboseLog")).booleanValue()) continue;
                Logger.getLogger("Minecraft").info("[" + this.plugin.getDescription().getName() + "] Disabled Alias(es) for " + cmd.getName() + " : " + aliases);
            }
        }
    }

    public void stopAllExecutorThreads() {
        for (ExecutorThread t : this.threads) {
            t.stopThread();
        }
        this.threadsStarted = false;
    }

    public boolean executeCommand(CommandSender sender, ACCommand cmd, String[] args) {
        try {
            if (cmd.permissionCheck(sender) && cmd.argsCheck(args)) {
                if (cmd.getCmdName().equals("bal_replace") || cmd.getCmdName().equals("bal_undo") || cmd.getCmdName().equals("bal_extinguish")) {
                    this.plugin.getServer().getScheduler().scheduleSyncDelayedTask((Plugin)this.plugin, (Runnable)new SyncTask(cmd, sender, args));
                } else {
                    this.threads.get(this.cmdCount).addCommand(new ACCommandContainer(sender, cmd, args));
                    ++this.cmdCount;
                    if (this.cmdCount == 5) {
                        this.cmdCount = 0;
                    }
                }
                if (!cmd.getCmdName().equals("bal_repeat")) {
                    if (Utils.isPlayer(sender, false)) {
                        ACHelper.getInstance().addValue(Type.REPEAT_CMD, (Player)sender, (Object)new ACCommandContainer(sender, cmd, args));
                    } else {
                        ACHelper.getInstance().addValue(Type.REPEAT_CMD, "serverConsole", (Object)new ACCommandContainer(sender, cmd, args));
                    }
                }
                return true;
            }
            return false;
        }
        catch (Throwable t) {
            Logger.getLogger("Minecraft").severe("[AdminCmd] The command " + cmd.getCmdName() + " throw an Exception please report the log to this thread : http://forums.bukkit.org/threads/admincmd.10770");
            sender.sendMessage("[AdminCmd]" + ChatColor.RED + " The command " + cmd.getCmdName() + " throw an Exception please report the server.log to this thread : http://forums.bukkit.org/threads/admincmd.10770");
            t.printStackTrace();
            if (this.cmdCount == 0) {
                this.threads.get(4).start();
            } else {
                this.threads.get(this.cmdCount - 1).start();
            }
            return false;
        }
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        ACCommand cmd = null;
        cmd = this.commands.get(command);
        if (cmd != null) {
            return this.executeCommand(sender, cmd, args);
        }
        return false;
    }

    private class SyncTask
    implements Runnable {
        private ACCommand cmd;
        private CommandSender sender;
        private String[] args;

        public SyncTask(ACCommand cmd, CommandSender sender, String[] args) {
            this.cmd = cmd;
            this.sender = sender;
            this.args = args;
        }

        @Override
        public void run() {
            this.cmd.execute(this.sender, this.args);
        }
    }

    private class ExecutorThread
    extends Thread {
        protected LinkedBlockingQueue<ACCommandContainer> commands;
        protected final int MAX_REQUEST = 5;
        boolean stop = false;
        Semaphore sema;
        Object threadSync = new Object();

        public ExecutorThread() {
            this.commands = new LinkedBlockingQueue(5);
            this.sema = new Semaphore(0);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            String cmdname = null;
            block6: while (true) {
                try {
                    while (true) {
                        this.sema.acquire();
                        Object object = this.threadSync;
                        synchronized (object) {
                            if (this.stop) {
                                break block6;
                            }
                        }
                        cmdname = this.commands.peek().getCmdName();
                        this.commands.poll().execute();
                    }
                }
                catch (InterruptedException e) {
                    continue;
                }
                catch (Throwable t) {
                    Logger.getLogger("Minecraft").severe("[AdminCmd] The command " + cmdname + " throw an Exception please report the log to this thread : http://forums.bukkit.org/threads/admincmd.10770");
                    AdminCmd.getBukkitServer().broadcastMessage("[AdminCmd] The command " + cmdname + " throw an Exception please report the log to this thread : http://forums.bukkit.org/threads/admincmd.10770");
                    t.printStackTrace();
                    continue;
                }
                break;
            }
        }

        public synchronized void stopThread() {
            this.stop = true;
            this.sema.release();
        }

        public synchronized void addCommand(ACCommandContainer cmd) throws InterruptedException {
            this.commands.put(cmd);
            this.sema.release();
        }
    }
}

