/*
 * Decompiled with CFR 0.152.
 */
package be.Balor.Manager.Commands.Mob;

import be.Balor.Manager.ACCommand;
import be.Balor.Tools.MobCheck;
import be.Balor.Tools.Utils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.bukkit.World;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Entity;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;

public class KillMob
extends ACCommand {
    public KillMob() {
        this.permNode = "admincmd.mob.kill";
        this.cmdName = "bal_killmob";
    }

    @Override
    public void execute(CommandSender sender, String ... args) {
        final ArrayList mobs = new ArrayList();
        HashMap<String, String> replace = new HashMap<String, String>();
        String type = "all";
        if (args.length >= 1) {
            type = args[0];
        }
        replace.put("type", type);
        if (Utils.isPlayer(sender, false)) {
            mobs.addAll(((Player)sender).getWorld().getLivingEntities());
            replace.put("worlds", ((Player)sender).getWorld().getName());
            Utils.sI18n(sender, "killMob", replace);
        } else {
            String worlds = "";
            for (World w : sender.getServer().getWorlds()) {
                mobs.addAll(w.getLivingEntities());
                worlds = worlds + w.getName() + ", ";
            }
            if (!worlds.equals("")) {
                if (worlds.endsWith(", ")) {
                    worlds = worlds.substring(0, worlds.lastIndexOf(","));
                }
                replace.put("worlds", worlds);
                Utils.sI18n(sender, "killMob", replace);
            }
        }
        final String finalType = type;
        final CommandSender finalSender = sender;
        this.pluginCommand.getPlugin().getServer().getScheduler().scheduleAsyncDelayedTask(this.pluginCommand.getPlugin(), new Runnable(){

            @Override
            public void run() {
                KillMob.this.killMobs(mobs, finalType, finalSender);
            }
        });
    }

    @Override
    public boolean argsCheck(String ... args) {
        return args != null;
    }

    private void killMobs(List<LivingEntity> mobs, String type, CommandSender sender) {
        int mobKilled = 0;
        for (LivingEntity m : mobs) {
            if (m instanceof HumanEntity) continue;
            if (type.equalsIgnoreCase("all") && (MobCheck.isAnimal((Entity)m) || MobCheck.isMonster((Entity)m))) {
                m.setHealth(0);
                ++mobKilled;
                continue;
            }
            if (MobCheck.isAnimal((Entity)m) && type.equalsIgnoreCase("animals")) {
                m.setHealth(0);
                ++mobKilled;
                continue;
            }
            if (MobCheck.isMonster((Entity)m) && type.equalsIgnoreCase("monsters")) {
                m.setHealth(0);
                ++mobKilled;
                continue;
            }
            if (MobCheck.isZombie(m) && type.equalsIgnoreCase("zombie")) {
                m.setHealth(0);
                ++mobKilled;
                continue;
            }
            if (MobCheck.isCreeper(m) && type.equalsIgnoreCase("creeper")) {
                m.setHealth(0);
                ++mobKilled;
                continue;
            }
            if (MobCheck.isSkeleton(m) && type.equalsIgnoreCase("skeleton")) {
                m.setHealth(0);
                ++mobKilled;
                continue;
            }
            if (MobCheck.isSpider(m) && type.equalsIgnoreCase("spider")) {
                m.setHealth(0);
                ++mobKilled;
                continue;
            }
            if (MobCheck.isGhast(m) && type.equalsIgnoreCase("ghast")) {
                m.setHealth(0);
                ++mobKilled;
                continue;
            }
            if (MobCheck.isSlime(m) && type.equalsIgnoreCase("slime")) {
                m.setHealth(0);
                ++mobKilled;
                continue;
            }
            if (MobCheck.isGiant(m) && type.equalsIgnoreCase("giant")) {
                m.setHealth(0);
                ++mobKilled;
                continue;
            }
            if (MobCheck.isPigZombie(m) && type.equalsIgnoreCase("pigzombie")) {
                m.setHealth(0);
                ++mobKilled;
                continue;
            }
            if (MobCheck.Monster(m) && type.equalsIgnoreCase("pigzombie")) {
                m.setHealth(0);
                ++mobKilled;
                continue;
            }
            if (MobCheck.isSheep(m) && type.equalsIgnoreCase("sheep")) {
                m.setHealth(0);
                ++mobKilled;
                continue;
            }
            if (MobCheck.isChicken(m) && type.equalsIgnoreCase("chicken")) {
                m.setHealth(0);
                ++mobKilled;
                continue;
            }
            if (MobCheck.isSquid(m) && type.equalsIgnoreCase("squid")) {
                m.setHealth(0);
                ++mobKilled;
                continue;
            }
            if (MobCheck.isCow(m) && type.equalsIgnoreCase("cow")) {
                m.setHealth(0);
                ++mobKilled;
                continue;
            }
            if (MobCheck.isPig(m) && type.equalsIgnoreCase("pig")) {
                m.setHealth(0);
                ++mobKilled;
                continue;
            }
            if (!MobCheck.isWolf(m) || !type.equalsIgnoreCase("wolf")) continue;
            m.setHealth(0);
            ++mobKilled;
        }
        Utils.sI18n(sender, "killedMobs", "nbKilled", String.valueOf(mobKilled));
    }
}

