/*
 * Decompiled with CFR 0.152.
 */
package be.Balor.Manager.Commands.Mob;

import be.Balor.Manager.ACCommand;
import be.Balor.Tools.Utils;
import be.Balor.bukkit.AdminCmd.ACHelper;
import be.Balor.bukkit.AdminCmd.AdminCmd;
import java.util.HashMap;
import org.bukkit.Location;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.CreatureType;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;

public class SpawnMob
extends ACCommand {
    public SpawnMob() {
        this.permNode = "admincmd.mob.spawn";
        this.cmdName = "bal_mob";
    }

    @Override
    public void execute(CommandSender sender, String ... args) {
        if (Utils.isPlayer(sender)) {
            Location loc;
            int nbTaped;
            HashMap<String, String> replace = new HashMap<String, String>();
            String name = args[0];
            replace.put("mob", name);
            int distance = 0;
            try {
                nbTaped = Integer.parseInt(args[1]);
            }
            catch (Exception e) {
                nbTaped = 1;
            }
            try {
                distance = Integer.parseInt(args[2]);
            }
            catch (Exception e) {
                distance = 0;
            }
            Player player = (Player)sender;
            if (distance == 0) {
                loc = player.getTargetBlock(null, 100).getLocation().add(0.0, 1.0, 0.0);
            } else {
                Location playerLoc = player.getLocation();
                loc = playerLoc.add(playerLoc.getDirection().normalize().multiply(distance).toLocation(player.getWorld(), playerLoc.getYaw(), playerLoc.getPitch())).add(0.0, 1.0, 0.0);
            }
            CreatureType ct = null;
            if (name.contains(":")) {
                String[] creatures = name.split(":");
                ct = CreatureType.fromName((String)creatures[0]);
                CreatureType ct2 = CreatureType.fromName((String)creatures[1]);
                if (ct == null) {
                    replace.put("mob", creatures[0]);
                    Utils.sI18n(sender, "errorMob", replace);
                }
                if (ct2 == null) {
                    replace.put("mob", creatures[1]);
                    Utils.sI18n(sender, "errorMob", replace);
                }
                if (ct == null || ct2 == null) {
                    return;
                }
                AdminCmd.getBukkitServer().getScheduler().scheduleAsyncDelayedTask((Plugin)ACHelper.getInstance().getPluginInstance(), (Runnable)new PassengerMob(loc, nbTaped, ct, ct2, player));
            } else {
                ct = CreatureType.fromName((String)name);
                if (ct == null) {
                    Utils.sI18n(sender, "errorMob", replace);
                    return;
                }
                AdminCmd.getBukkitServer().getScheduler().scheduleAsyncDelayedTask((Plugin)ACHelper.getInstance().getPluginInstance(), (Runnable)new NormalMob(loc, nbTaped, ct, player));
            }
        }
    }

    @Override
    public boolean argsCheck(String ... args) {
        return args != null && args.length >= 1;
    }

    protected class PassengerMob
    extends NormalMob {
        protected CreatureType passenger;

        public PassengerMob(Location loc, int nb, CreatureType mount, CreatureType passenger, Player player) {
            super(loc, nb, mount, player);
            this.passenger = passenger;
        }

        @Override
        public void run() {
            HashMap<String, String> replace = new HashMap<String, String>();
            replace.put("mob", this.ct.getName() + "-" + this.passenger.getName());
            for (int i = 0; i < this.nb; ++i) {
                this.loc.getWorld().spawnCreature(this.loc, this.ct).setPassenger((Entity)this.loc.getWorld().spawnCreature(this.loc, this.passenger));
                try {
                    Thread.sleep(5L);
                    continue;
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            replace.put("nb", String.valueOf(this.nb));
            Utils.sI18n((CommandSender)this.player, "spawnMob", replace);
        }
    }

    protected class NormalMob
    implements Runnable {
        protected Location loc;
        protected int nb;
        protected CreatureType ct;
        protected Player player;

        public NormalMob(Location loc, int nb, CreatureType ct, Player player) {
            this.loc = loc;
            this.nb = nb;
            this.ct = ct;
            this.player = player;
        }

        @Override
        public void run() {
            HashMap<String, String> replace = new HashMap<String, String>();
            replace.put("mob", this.ct.getName());
            for (int i = 0; i < this.nb; ++i) {
                this.loc.getWorld().spawnCreature(this.loc, this.ct);
                try {
                    Thread.sleep(5L);
                    continue;
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            replace.put("nb", String.valueOf(this.nb));
            Utils.sI18n((CommandSender)this.player, "spawnMob", replace);
        }
    }
}

