/*
 * Decompiled with CFR 0.152.
 */
package be.Balor.Manager.Commands.Player;

import be.Balor.Manager.ACCommand;
import be.Balor.Manager.Permissions.PermissionManager;
import be.Balor.Tools.Utils;
import belgium.Balor.Workers.InvisibleWorker;
import java.util.HashMap;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.permissions.PermissionDefault;

public class Invisible
extends ACCommand {
    public Invisible() {
        this.permNode = "admincmd.player.invisible";
        this.cmdName = "bal_invisible";
        this.other = true;
    }

    @Override
    public void execute(CommandSender sender, String ... args) {
        Player target = Utils.getUser(sender, args, this.permNode);
        if (target != null) {
            HashMap<String, String> replace = new HashMap<String, String>();
            replace.put("player", target.getName());
            if (!InvisibleWorker.getInstance().hasInvisiblePowers(target.getName())) {
                InvisibleWorker.getInstance().vanish(target);
                Utils.sI18n((CommandSender)target, "invisibleEnabled");
                if (!target.equals(sender)) {
                    Utils.sI18n(sender, "invisibleEnabledTarget", replace);
                }
            } else {
                InvisibleWorker.getInstance().reappear(target);
                Utils.sI18n((CommandSender)target, "invisibleDisabled");
                if (!target.equals(sender)) {
                    Utils.sI18n(sender, "invisibleDisabledTarget", replace);
                }
            }
        }
    }

    @Override
    public boolean argsCheck(String ... args) {
        return args != null;
    }

    @Override
    public void registerBukkitPerm() {
        super.registerBukkitPerm();
        PermissionManager.getInstance().addPermChild("admincmd.invisible.notatarget", PermissionDefault.OP);
        PermissionManager.getInstance().addPermChild("admincmd.invisible.cansee", PermissionDefault.OP);
    }
}

