/*
 * Decompiled with CFR 0.152.
 */
package be.Balor.Manager.Commands.Player;

import be.Balor.Manager.ACCommand;
import be.Balor.Manager.Permissions.PermissionManager;
import be.Balor.Tools.Utils;
import belgium.Balor.Workers.AFKWorker;
import belgium.Balor.Workers.InvisibleWorker;
import org.bukkit.ChatColor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class PlayerList
extends ACCommand {
    public PlayerList() {
        this.permNode = "admincmd.player.list";
        this.cmdName = "bal_playerlist";
    }

    @Override
    public void execute(CommandSender sender, String ... args) {
        Player[] online = sender.getServer().getOnlinePlayers();
        int amount = online.length;
        if (!PermissionManager.hasPerm(sender, "admincmd.invisible.cansee", false)) {
            amount -= InvisibleWorker.getInstance().nbInvisibles();
        }
        sender.sendMessage(Utils.I18n("onlinePlayers") + " " + ChatColor.WHITE + amount);
        String buffer = "";
        if (!PermissionManager.hasInfoNode()) {
            boolean isInv = false;
            for (int i = 0; i < online.length; ++i) {
                Player p = online[i];
                isInv = InvisibleWorker.getInstance().hasInvisiblePowers(p.getName());
                if (isInv && !PermissionManager.hasPerm(sender, "admincmd.invisible.cansee", false)) continue;
                String name = "";
                name = isInv ? Utils.I18n("invTitle") + p.getName() : p.getDisplayName();
                if (AFKWorker.getInstance().isAfk(p)) {
                    name = Utils.I18n("afkTitle") + name;
                }
                if (buffer.length() + name.length() + 2 >= 256) {
                    sender.sendMessage(buffer);
                    buffer = "";
                }
                buffer = buffer + name + ", ";
            }
        } else {
            boolean isInv = false;
            for (int i = 0; i < online.length; ++i) {
                String result;
                String prefixstring;
                String name = online[i].getName();
                String invPrefix = "";
                isInv = InvisibleWorker.getInstance().hasInvisiblePowers(name);
                if (isInv && !PermissionManager.hasPerm(sender, "admincmd.invisible.cansee", false)) continue;
                if (isInv) {
                    invPrefix = Utils.I18n("invTitle");
                }
                if (AFKWorker.getInstance().isAfk(online[i])) {
                    invPrefix = Utils.I18n("afkTitle") + invPrefix;
                }
                buffer = (prefixstring = PermissionManager.getPrefix(online[i])) != null && prefixstring.length() > 1 ? ((result = Utils.colorParser(prefixstring)) == null ? buffer + invPrefix + prefixstring + name + ChatColor.WHITE + ", " : buffer + invPrefix + result + name + ChatColor.WHITE + ", ") : buffer + invPrefix + name + ", ";
                if (buffer.length() < 256) continue;
                sender.sendMessage(buffer);
                buffer = "";
            }
        }
        if (!buffer.equals("")) {
            if (buffer.endsWith(", ")) {
                buffer = buffer.substring(0, buffer.lastIndexOf(","));
            }
            sender.sendMessage(buffer);
        }
    }

    @Override
    public boolean argsCheck(String ... args) {
        return true;
    }
}

