/*
 * Decompiled with CFR 0.152.
 */
package be.Balor.Manager.Permissions;

import be.Balor.Manager.Permissions.AbstractPermission;
import be.Balor.Manager.Permissions.PermParent;
import be.Balor.Manager.Permissions.Plugins.BukkitPermissions;
import be.Balor.Manager.Permissions.Plugins.PermissionsEx;
import be.Balor.Manager.Permissions.Plugins.YetiPermissions;
import be.Balor.bukkit.AdminCmd.ACHelper;
import be.Balor.bukkit.AdminCmd.AdminCmd;
import com.nijiko.permissions.PermissionHandler;
import java.util.LinkedList;
import java.util.logging.Logger;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.permissions.Permission;
import org.bukkit.permissions.PermissionDefault;

public class PermissionManager {
    private LinkedList<PermParent> permissions = new LinkedList();
    private PermParent majorPerm;
    private static PermissionManager instance = null;
    private static boolean permissionsEx = false;
    private static boolean yetiPermissions = false;
    public static final Logger log = Logger.getLogger("Minecraft");
    private static AbstractPermission permissionHandler;

    private PermissionManager() {
        permissionHandler = new BukkitPermissions();
    }

    public static PermissionManager getInstance() {
        if (instance == null) {
            instance = new PermissionManager();
        }
        return instance;
    }

    public void setMajorPerm(PermParent major) {
        this.majorPerm = major;
        for (PermParent pp : this.permissions) {
            this.majorPerm.addChild(pp.getPermName());
        }
    }

    public void addPermParent(PermParent toAdd) {
        this.permissions.add(toAdd);
    }

    public Permission addPermChild(String permNode, PermissionDefault bukkitDefault) {
        Permission bukkitPerm = null;
        bukkitPerm = AdminCmd.getBukkitServer().getPluginManager().getPermission(permNode);
        if (bukkitPerm == null) {
            bukkitPerm = new Permission(permNode, bukkitDefault);
            AdminCmd.getBukkitServer().getPluginManager().addPermission(bukkitPerm);
            for (PermParent pp : this.permissions) {
                if (!permNode.contains(pp.getCompareName())) continue;
                pp.addChild(permNode);
            }
        }
        return bukkitPerm;
    }

    public Permission addOnTheFly(String permNode, String parentNode) {
        Permission child = AdminCmd.getBukkitServer().getPluginManager().getPermission(permNode);
        if (child == null) {
            Permission parent = AdminCmd.getBukkitServer().getPluginManager().getPermission(parentNode);
            child = new Permission(permNode, PermissionDefault.OP);
            AdminCmd.getBukkitServer().getPluginManager().addPermission(child);
            parent.getChildren().put(permNode, true);
        }
        return child;
    }

    public Permission addPermChild(String permNode) {
        return this.addPermChild(permNode, PermissionDefault.OP);
    }

    public void registerAllPermParent() {
        for (PermParent pp : this.permissions) {
            pp.registerBukkitPerm();
        }
        this.majorPerm.registerBukkitPerm();
        this.permissions = null;
        this.majorPerm = null;
    }

    public static boolean hasPerm(CommandSender player, String perm) {
        return permissionHandler.hasPerm(player, perm);
    }

    public static boolean hasPerm(CommandSender player, Permission perm) {
        return permissionHandler.hasPerm(player, perm);
    }

    public static boolean hasPerm(CommandSender player, String perm, boolean errorMsg) {
        return permissionHandler.hasPerm(player, perm, errorMsg);
    }

    public static boolean hasPerm(CommandSender player, Permission perm, boolean errorMsg) {
        return permissionHandler.hasPerm(player, perm, errorMsg);
    }

    public static String getPermissionLimit(Player p, String limit) {
        return permissionHandler.getPermissionLimit(p, limit);
    }

    public static String getPrefix(Player player) {
        return permissionHandler.getPrefix(player);
    }

    public static boolean hasInfoNode() {
        return permissionHandler.haveInfoNode();
    }

    public static boolean isPermissionsExSet() {
        return permissionsEx;
    }

    public static boolean isYetiPermissionsSet() {
        return yetiPermissions;
    }

    public static boolean setPEX(ru.tehkode.permissions.PermissionManager pEX) {
        if (!permissionsEx) {
            if (!((Boolean)ACHelper.getInstance().getConfValue("forceOfficialBukkitPerm")).booleanValue()) {
                permissionsEx = true;
                permissionHandler = new PermissionsEx(pEX);
                if (!yetiPermissions) {
                    System.out.println("[AdminCmd] Successfully linked with PermissionsEX");
                } else {
                    System.out.println("[AdminCmd] Use PermissionsEX instead of Yeti's Permissions.");
                }
            } else {
                System.out.println("[AdminCmd] Plugin Forced to use Offical Bukkit Permission System instead of PermissionsEX.");
            }
            return true;
        }
        return false;
    }

    public static boolean setYetiPermissions(PermissionHandler plugin) {
        if (!yetiPermissions && !permissionsEx) {
            if (!((Boolean)ACHelper.getInstance().getConfValue("forceOfficialBukkitPerm")).booleanValue()) {
                yetiPermissions = true;
                permissionHandler = new YetiPermissions(plugin);
                System.out.println("[AdminCmd] Successfully linked with Yeti's Permissions.");
            } else {
                System.out.println("[AdminCmd] Plugin Forced to use Offical Bukkit Permission System instead of Yeti's Permissions.");
            }
        } else {
            return false;
        }
        return true;
    }
}

